/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.utils;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.server.internal.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationUtils {
    public static void registerApplication(Application application, ServletContext servletContext) {
        RegistrationUtils.registerApplication(application, servletContext, null);
    }

    public static void registerClasses(ServletContext servletContext, Class<?> ... classes) {
        RegistrationUtils.registerClasses(servletContext, null, classes);
    }

    public static void registerInstances(ServletContext servletContext, Object ... instances) {
        RegistrationUtils.registerInstances(servletContext, null, instances);
    }

    public static void registerInstances(ServletContext servletContext, String requestProcessorAttribute, Object ... instances) {
        RegistrationUtils.registerApplication((Application)new InnerApplication(instances), servletContext, requestProcessorAttribute);
    }

    public static void registerClasses(ServletContext servletContext, String requestProcessorAttribute, Class<?> ... classes) {
        RegistrationUtils.registerApplication((Application)new InnerApplication(classes), servletContext, requestProcessorAttribute);
    }

    public static void registerApplication(Application application, ServletContext servletContext, String requestProcessorAttribute) {
        RequestProcessor requestProcessor = RequestProcessor.getRequestProcessor(servletContext, requestProcessorAttribute);
        requestProcessor.getConfiguration().addApplication(application, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InnerApplication
    extends WinkApplication {
        private Set<Class<?>> classes = null;
        private Set<Object> instances = null;
        private double priority = 0.5;

        public InnerApplication(Set<Class<?>> set) {
            this.classes = set;
        }

        public InnerApplication(Class<?> ... classes) {
            this.classes = new HashSet(classes.length);
            for (Class<?> cls : classes) {
                this.classes.add(cls);
            }
        }

        public InnerApplication(Object ... instances) {
            this.instances = new HashSet<Object>(instances.length);
            for (Object obj : instances) {
                this.instances.add(obj);
            }
        }

        public Set<Class<?>> getClasses() {
            if (this.classes == null) {
                return super.getClasses();
            }
            return this.classes;
        }

        public Set<Object> getInstances() {
            if (this.instances == null) {
                return super.getInstances();
            }
            return this.instances;
        }

        public void setPriority(double priority) {
            this.priority = priority;
        }

        public double getPriority() {
            return this.priority;
        }
    }
}

