/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.spring.internal;

import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.spring.internal.SpringLifecycleManager;
import org.apache.wink.spring.internal.SpringObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagerPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
ApplicationListener {
    private ApplicationContext applicationContext;
    private SpringLifecycleManager<?> springOFFactory;
    private boolean loadingOfContextCompleted = false;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.loadingOfContextCompleted && this.applicationContext.containsBean(beanName)) {
            Class<?> cls = bean.getClass();
            if (ResourceMetadataCollector.isStaticResource(cls)) {
                this.springOFFactory.addResourceOrProvider(bean, beanName, new SpringObjectFactory(this.applicationContext, beanName, ResourceMetadataCollector.collectMetadata(cls)));
            } else if (ProviderMetadataCollector.isProvider(cls)) {
                this.springOFFactory.addResourceOrProvider(bean, beanName, new SpringObjectFactory(this.applicationContext, beanName, ProviderMetadataCollector.collectMetadata(cls)));
            } else if (ResourceMetadataCollector.isDynamicResource(cls)) {
                this.springOFFactory.addDynamicResource(bean, beanName, new SpringObjectFactory(this.applicationContext, beanName, ResourceMetadataCollector.collectMetadata(cls)));
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setSpringOFFactory(SpringLifecycleManager<?> springOFFactory) {
        this.springOFFactory = springOFFactory;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.loadingOfContextCompleted = true;
        }
    }
}

