/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.SchemaTransformer;
import org.apache.ws.jaxme.xs.XSContentHandler;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSObjectFactory;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.impl.DOMSerializer;
import org.apache.ws.jaxme.xs.impl.XSContentHandlerImpl;
import org.apache.ws.jaxme.xs.impl.XSElementImpl;
import org.apache.ws.jaxme.xs.impl.XSGroupImpl;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.util.LoggingContentHandler;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;
import org.apache.ws.jaxme.xs.xml.XsEAnnotation;
import org.apache.ws.jaxme.xs.xml.XsEImport;
import org.apache.ws.jaxme.xs.xml.XsEInclude;
import org.apache.ws.jaxme.xs.xml.XsENotation;
import org.apache.ws.jaxme.xs.xml.XsERedefine;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsETopLevelSimpleType;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsObjectFactory;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsRedefinable;
import org.apache.ws.jaxme.xs.xml.XsTAttribute;
import org.apache.ws.jaxme.xs.xml.XsTAttributeGroup;
import org.apache.ws.jaxme.xs.xml.XsTComplexType;
import org.apache.ws.jaxme.xs.xml.XsTLocalElement;
import org.apache.ws.jaxme.xs.xml.XsTNamedGroup;
import org.apache.ws.jaxme.xs.xml.XsTSimpleExplicitGroup;
import org.apache.ws.jaxme.xs.xml.XsTTopLevelElement;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public class XSLogicalParser {
    private boolean notValidating;
    private List syntaxSchemas = new ArrayList();
    private XsESchema[] syntaxSchemaArray;
    private XSSchema schema;
    private Set parsedSchemas;
    private List addedImports = new ArrayList();

    protected XSContext getData() {
        return XSParser.getRunningInstance().getContext();
    }

    public void setValidating(boolean pValidating) {
        this.notValidating = !pValidating;
    }

    public boolean isValidating() {
        return !this.notValidating;
    }

    public void addImport(String pNamespace, String pSchemaLocation) {
        this.addedImports.add(new AddedImport(pNamespace, pSchemaLocation));
    }

    public void addImport(String pNamespace, String pSchemaLocation, Node pSchema) {
        this.addedImports.add(new AddedImport(pNamespace, pSchemaLocation, pSchema));
    }

    public AddedImport[] getAddedImports() {
        return this.addedImports.toArray(new AddedImport[this.addedImports.size()]);
    }

    public XSSchema getSchema() {
        return this.schema;
    }

    protected void setSchema(XSSchema pSchema) {
        this.schema = pSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XsESchema parseSyntax(Node pNode) throws SAXException {
        XSContext data = this.getData();
        try {
            XsObjectFactory factory = data.getXsObjectFactory();
            XsESchema mySchema = factory.newXsESchema();
            XsSAXParser xsSAXParser = factory.newXsSAXParser(mySchema);
            this.addSyntaxSchema(mySchema);
            try {
                data.setCurrentContentHandler(xsSAXParser);
                DOMSerializer ds = new DOMSerializer();
                ds.serialize(pNode, xsSAXParser);
                XsESchema xsESchema = (XsESchema)xsSAXParser.getBean();
                this.removeSyntaxSchema();
                return xsESchema;
            }
            catch (Throwable throwable) {
                this.removeSyntaxSchema();
                throw throwable;
            }
        }
        finally {
            data.setCurrentContentHandler(null);
        }
    }

    protected InputSource getInputSource(String pReferencingSystemId, String pURI) throws SAXException {
        URL url = null;
        if (pReferencingSystemId != null) {
            try {
                url = new URL(new URL(pReferencingSystemId), pURI);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (url == null) {
                try {
                    url = new File(new File(pReferencingSystemId).getParentFile(), pURI).toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if (url == null) {
            try {
                url = new URL(pURI);
            }
            catch (MalformedURLException e) {
                try {
                    url = new File(pURI).toURL();
                }
                catch (MalformedURLException f) {
                    throw new SAXException("Failed to parse the URI " + pURI);
                }
            }
        }
        try {
            InputSource isource = new InputSource(url.openStream());
            isource.setSystemId(url.toString());
            return isource;
        }
        catch (IOException e) {
            throw new SAXException("Failed to open the URL " + url, e);
        }
    }

    protected XsESchema parseSyntax(Locator pLocator, String pSchemaLocation) throws SAXException, IOException, ParserConfigurationException {
        XsESchema result = this.getData().getXsObjectFactory().newXsESchema();
        this.parseSyntax(pLocator, pSchemaLocation, result);
        return result;
    }

    private void runContentHandler(XMLReader pReader, ContentHandler pHandler, InputSource pSource) throws SAXException, IOException {
        String logDir = System.getProperty("org.apache.ws.jaxme.xs.logDir");
        FileOutputStream fos = null;
        try {
            SchemaTransformer transformer = this.getData().getXSObjectFactory().getSchemaTransformer();
            if (transformer != null) {
                transformer.parse(pSource, pReader);
                InputSource newSource = transformer.getTransformedInputSource();
                newSource.setSystemId(pSource.getSystemId());
                newSource.setPublicId(pSource.getPublicId());
                pSource = newSource;
                pReader = transformer.getTransformedXMLReader();
            }
            if (logDir != null) {
                File tmpFile = File.createTempFile("jaxmexs", ".xsd", new File(logDir));
                fos = new FileOutputStream(tmpFile);
                LoggingContentHandler lch = new LoggingContentHandler(fos);
                lch.setParent(pReader);
                pReader = lch;
                String msg = "Read from " + pSource.getPublicId() + ", " + pSource.getSystemId() + " at " + new Date();
                lch.comment(msg.toCharArray(), 0, msg.length());
            }
            pReader.setContentHandler(pHandler);
            LocatorImpl loc = new LocatorImpl();
            loc.setSystemId(pSource.getSystemId());
            loc.setPublicId(pSource.getPublicId());
            loc.setLineNumber(-1);
            loc.setColumnNumber(-1);
            pHandler.setDocumentLocator(loc);
            pReader.parse(pSource);
            if (fos != null) {
                fos.close();
                fos = null;
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSyntax(Locator pLocator, String pSchemaLocation, XsESchema pSchema) throws SAXException, IOException, ParserConfigurationException {
        XSContext data = this.getData();
        try {
            XsObjectFactory factory = data.getXsObjectFactory();
            XMLReader xr = factory.newXMLReader(this.isValidating());
            EntityResolver entityResolver = xr.getEntityResolver();
            InputSource schemaSource = null;
            if (entityResolver != null) {
                schemaSource = entityResolver.resolveEntity(null, pSchemaLocation);
            }
            if (schemaSource == null) {
                schemaSource = this.getInputSource(pLocator == null ? null : pLocator.getSystemId(), pSchemaLocation);
            }
            XsSAXParser xsSAXParser = factory.newXsSAXParser(pSchema);
            this.addSyntaxSchema(pSchema);
            try {
                data.setCurrentContentHandler(xsSAXParser);
                this.runContentHandler(xr, xsSAXParser, schemaSource);
            }
            finally {
                this.removeSyntaxSchema();
            }
        }
        finally {
            data.setCurrentContentHandler(null);
        }
    }

    protected void redefine(XsESchema pSyntaxSchema, XsERedefine pRedefine, XsRedefinable pChild) throws SAXException {
        XSSchema mySchema = this.getSchema();
        XSContext data = this.getData();
        XSObjectFactory factory = data.getXSObjectFactory();
        if (pChild instanceof XsTAttributeGroup) {
            XsTAttributeGroup attributeGroup = (XsTAttributeGroup)pChild;
            mySchema.redefine(factory.newXSAttributeGroup(mySchema, attributeGroup));
        } else if (pChild instanceof XsTNamedGroup) {
            XsTNamedGroup group = (XsTNamedGroup)pChild;
            mySchema.redefine(factory.newXSGroup((XSObject)mySchema, group));
        } else if (pChild instanceof XsETopLevelSimpleType) {
            XsETopLevelSimpleType type = (XsETopLevelSimpleType)pChild;
            mySchema.redefine(factory.newXSType((XSObject)mySchema, type));
        } else if (pChild instanceof XsTComplexType) {
            XsTComplexType type = (XsTComplexType)pChild;
            mySchema.redefine(factory.newXSType((XSObject)mySchema, type));
        } else {
            Locator locator = pChild instanceof XsObject ? ((XsObject)((Object)pChild)).getLocator() : pRedefine.getLocator();
            throw new LocSAXException("Unknown type for redefinition: " + pChild.getClass().getName() + ", perhaps you should handle this in a subclass?", locator);
        }
    }

    protected void add(XsESchema pSyntaxSchema, Object pChild) throws SAXException {
        XSSchema mySchema = this.getSchema();
        XSContext data = this.getData();
        XSObjectFactory factory = data.getXSObjectFactory();
        if (pChild instanceof XsEAnnotation) {
            XsEAnnotation annotation = (XsEAnnotation)pChild;
            mySchema.add(factory.newXSAnnotation(mySchema, annotation));
        } else if (pChild instanceof XsETopLevelSimpleType) {
            XsETopLevelSimpleType type = (XsETopLevelSimpleType)pChild;
            mySchema.add(factory.newXSType((XSObject)mySchema, type));
        } else if (pChild instanceof XsTComplexType) {
            XsTComplexType type = (XsTComplexType)pChild;
            mySchema.add(factory.newXSType((XSObject)mySchema, type));
        } else if (pChild instanceof XsTNamedGroup) {
            XsTNamedGroup group = (XsTNamedGroup)pChild;
            mySchema.add(factory.newXSGroup((XSObject)mySchema, group));
        } else if (pChild instanceof XsTAttributeGroup) {
            XsTAttributeGroup attributeGroup = (XsTAttributeGroup)pChild;
            mySchema.add(factory.newXSAttributeGroup(mySchema, attributeGroup));
        } else if (pChild instanceof XsTTopLevelElement) {
            XsTTopLevelElement element = (XsTTopLevelElement)pChild;
            mySchema.add(factory.newXSElement(mySchema, element));
        } else if (pChild instanceof XsTAttribute) {
            XsTAttribute attribute = (XsTAttribute)pChild;
            mySchema.add(factory.newXSAttribute(mySchema, attribute));
        } else if (pChild instanceof XsENotation) {
            XsENotation notation = (XsENotation)pChild;
            mySchema.add(factory.newXSNotation(mySchema, notation));
        } else {
            Locator locator = pChild instanceof XsObject ? ((XsObject)pChild).getLocator() : pSyntaxSchema.getLocator();
            throw new LocSAXException("Unknown child type: " + pChild.getClass().getName() + ", perhaps you should handle this in a subclass?", locator);
        }
    }

    protected void redefineSchema(XsESchema pRedefiningSchema, XsERedefine pRedefine) throws SAXException, IOException, ParserConfigurationException {
        throw new LocSAXException("Redefine isn't yet implemented.", pRedefine.getLocator());
    }

    protected void includeSchema(XsESchema pIncludingSchema, XsEInclude pInclude, Locator pLocator, String pSchemaLocation) throws SAXException, IOException, ParserConfigurationException {
        XsAnyURI schemaLocation = pInclude.getSchemaLocation();
        if (schemaLocation == null) {
            throw new LocSAXException("Invalid include: Missing 'schemaLocation' attribute.", pInclude.getLocator());
        }
        XsESchema includedSchema = this.parseSyntax(pLocator, schemaLocation.toString());
        XsAnyURI incNamespace = includedSchema.getTargetNamespace();
        if (incNamespace == null) {
            if (pIncludingSchema.getTargetNamespace() != null) {
                includedSchema.setTargetNamespace(pIncludingSchema.getTargetNamespace());
            }
        } else {
            XsAnyURI myNamespace = includedSchema.getTargetNamespace();
            if (!incNamespace.equals(myNamespace)) {
                throw new LocSAXException("Invalid include: The included schemas target namespace " + incNamespace + " and the including schemas target namespace " + myNamespace + " do not match.", pInclude.getLocator());
            }
        }
        this.parse(includedSchema, pSchemaLocation);
    }

    private void checkValidImportSchema(XsESchema pImportingSchema, String pNamespace, Locator pLocator) throws SAXException {
        if (pNamespace == null) {
            if (pImportingSchema.getTargetNamespace() == null) {
                throw new LocSAXException("The importing schema has no 'targetNamespace' attribute and the 'import' element has no 'namespace' attribute, which is forbidden. Perhaps you want to use include?", pLocator);
            }
        } else {
            if ("".equals(pNamespace)) {
                throw new LocSAXException("Invalid import: Empty 'namespace' attribute, which is forbidden. Perhaps you want to omit the attribute to indicate the absence of a namespace?", pLocator);
            }
            XsAnyURI targetNamespace = pImportingSchema.getTargetNamespace();
            if (targetNamespace != null && pNamespace.equals(targetNamespace.toString())) {
                throw new LocSAXException("The importing schema and the imported schema have the same namespace, which is forbidden. Perhaps you want to use include?", pLocator);
            }
        }
    }

    private void importSchema(XsESchema pImportingSchema, String pNamespace, XsESchema pImportedSchema, Locator pLocator, String pSchemaLocation) throws SAXException, ParserConfigurationException, IOException {
        XsAnyURI impNamespace = pImportedSchema.getTargetNamespace();
        if (pNamespace == null) {
            if (impNamespace != null) {
                throw new LocSAXException("The 'import' element does not have a 'namespace' attribute, but the imported schema has target namespace " + impNamespace + ", it ought to match and have none.", pLocator);
            }
        } else {
            if (impNamespace == null) {
                throw new LocSAXException("The 'import' element has a 'namespace' attribute (" + pNamespace + "), but the imported schema has no 'targetNamespace' attribute.", pLocator);
            }
            if (!pNamespace.equals(impNamespace.toString())) {
                throw new LocSAXException("The 'import' elements 'namespace' attribute (" + pNamespace + ") and the imported schemas 'targetNamespace' attribute (" + impNamespace + ") do not match.", pLocator);
            }
        }
        this.parse(pImportedSchema, pSchemaLocation);
    }

    protected void importSchema(XsESchema pImportingSchema, String pNamespace, String pSchemaLocation, Locator pLocator) throws SAXException, IOException, ParserConfigurationException {
        if (pSchemaLocation == null) {
            return;
        }
        this.checkValidImportSchema(pImportingSchema, pNamespace, pLocator);
        XsESchema importedSchema = this.parseSyntax(pLocator, pSchemaLocation);
        this.importSchema(pImportingSchema, pNamespace, importedSchema, pLocator, pSchemaLocation);
    }

    protected void importSchema(XsESchema pImportingSchema, String pNamespace, Node pNode, String pSchemaLocation) throws SAXException, IOException, ParserConfigurationException {
        this.checkValidImportSchema(pImportingSchema, pNamespace, null);
        XsESchema importedSchema = this.parseSyntax(pNode);
        this.importSchema(pImportingSchema, pNamespace, importedSchema, null, pSchemaLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(XsESchema pSyntaxSchema, String pSchemaLocation) throws ParserConfigurationException, SAXException, IOException {
        int i;
        if (pSchemaLocation != null) {
            AddedImport schema = new AddedImport(pSyntaxSchema.getTargetNamespace(), pSchemaLocation);
            if (this.parsedSchemas == null) {
                this.parsedSchemas = new HashSet();
            } else if (this.parsedSchemas.contains(schema)) {
                return;
            }
            this.parsedSchemas.add(schema);
            for (i = 0; i < this.addedImports.size(); ++i) {
                AddedImport addedImport = (AddedImport)this.addedImports.get(i);
                if (!schema.equals(addedImport)) continue;
                return;
            }
        }
        this.addSyntaxSchema(pSyntaxSchema);
        try {
            Object[] childs = pSyntaxSchema.getChilds();
            for (i = 0; i < childs.length; ++i) {
                Object o = childs[i];
                if (o instanceof XsEInclude) {
                    XsEInclude xsEInclude = (XsEInclude)o;
                    XsAnyURI schemaLocation = xsEInclude.getSchemaLocation();
                    this.includeSchema(pSyntaxSchema, xsEInclude, this.getImportLocator(xsEInclude, pSchemaLocation), schemaLocation == null ? null : schemaLocation.toString());
                    continue;
                }
                if (o instanceof XsERedefine) {
                    this.redefineSchema(pSyntaxSchema, (XsERedefine)o);
                    continue;
                }
                if (o instanceof XsEImport) {
                    XsEImport xsEImport = (XsEImport)o;
                    XsAnyURI namespace = xsEImport.getNamespace();
                    XsAnyURI schemaLocation = xsEImport.getSchemaLocation();
                    this.importSchema(pSyntaxSchema, namespace == null ? null : namespace.toString(), schemaLocation == null ? null : schemaLocation.toString(), this.getImportLocator(xsEImport, pSchemaLocation));
                    continue;
                }
                this.add(pSyntaxSchema, childs[i]);
            }
        }
        finally {
            this.removeSyntaxSchema();
        }
    }

    private Locator getImportLocator(XsObject pObject, String pSchemaLocation) {
        Locator result = pObject.getLocator();
        if (result == null && pSchemaLocation != null) {
            LocatorImpl loc = new LocatorImpl();
            loc.setSystemId(pSchemaLocation);
            result = loc;
        }
        return result;
    }

    protected void createSubstitutionGroups(XSSchema pSchema) throws SAXException {
        Object[] myChilds = pSchema.getChilds();
        HashMap<XsQName, SubstitutionGroup> substitutionGroups = new HashMap<XsQName, SubstitutionGroup>();
        for (int i = 0; i < myChilds.length; ++i) {
            XSElement element;
            XsQName qName;
            if (!(myChilds[i] instanceof XSElement) || (qName = (element = (XSElement)myChilds[i]).getSubstitutionGroupName()) == null) continue;
            SubstitutionGroup group = (SubstitutionGroup)substitutionGroups.get(qName);
            if (group == null) {
                XSElement head = pSchema.getElement(qName);
                if (head == null) {
                    throw new LocSAXException("The substituted element " + qName + " is missing in the schema.", element.getLocator());
                }
                if (head.isBlockedForSubstitution()) {
                    throw new LocSAXException("The substituted element " + qName + " is blocked for substitution.", element.getLocator());
                }
                group = new SubstitutionGroup(head);
                if (!head.isAbstract()) {
                    group.addMember(head);
                }
                substitutionGroups.put(qName, group);
            }
            group.addMember(element);
        }
        Iterator iter = substitutionGroups.values().iterator();
        while (iter.hasNext()) {
            String localName;
            SubstitutionGroup group = (SubstitutionGroup)iter.next();
            XSElementImpl head = (XSElementImpl)group.getHead();
            XsObject object = head.getXsObject();
            XsESchema syntaxSchema = object.getXsESchema();
            String namespace = syntaxSchema.getTargetNamespace().toString();
            XsQName suggestion = new XsQName(namespace, localName = head.getName().getLocalName() + "Group");
            if (pSchema.getGroup(suggestion) != null) {
                int i = 0;
                while (pSchema.getGroup(suggestion = new XsQName(namespace, localName + i)) != null) {
                    ++i;
                }
            }
            XsTNamedGroup namedGroup = object.getObjectFactory().newXsTNamedGroup(syntaxSchema);
            namedGroup.setName(new XsNCName(suggestion.getLocalName()));
            XsTSimpleExplicitGroup choice = namedGroup.createChoice();
            XSElement[] members = group.getMembers();
            for (int j = 0; j < members.length; ++j) {
                XSElement member = members[j];
                XsTLocalElement memberElement = choice.createElement();
                memberElement.setRef(member.getName());
            }
            XSGroupImpl xsGroup = (XSGroupImpl)this.getSchema().getXSObjectFactory().newXSGroup((XSObject)pSchema, namedGroup);
            pSchema.add(xsGroup);
            head.setSubstitutionGroup(xsGroup);
        }
    }

    public XSContentHandler getXSContentHandler(String pSystemId) throws SAXException {
        return new XSContentHandlerImpl(this, pSystemId);
    }

    public XSSchema parse(Node pNode) throws SAXException {
        XSContentHandler handler = this.getXSContentHandler(null);
        DOMSerializer ds = new DOMSerializer();
        ds.serialize(pNode, handler);
        return handler.getXSSchema();
    }

    public XSSchema parse(InputSource pSource) throws ParserConfigurationException, SAXException, IOException {
        XSContentHandler contentHandler = this.getXSContentHandler(pSource.getSystemId());
        XSContext data = this.getData();
        XMLReader xr = data.getXsObjectFactory().newXMLReader(this.isValidating());
        this.runContentHandler(xr, contentHandler, pSource);
        return this.getSchema();
    }

    protected void clearSyntaxSchemas() {
        this.syntaxSchemas.clear();
        this.syntaxSchemaArray = null;
    }

    protected void addSyntaxSchema(XsESchema pSyntaxSchema) {
        this.syntaxSchemas.add(pSyntaxSchema);
        this.syntaxSchemaArray = null;
    }

    protected void removeSyntaxSchema() {
        this.syntaxSchemas.remove(this.syntaxSchemas.size() - 1);
        this.syntaxSchemaArray = null;
    }

    public XsESchema[] getSyntaxSchemas() {
        if (this.syntaxSchemaArray == null) {
            this.syntaxSchemaArray = this.syntaxSchemas.toArray(new XsESchema[this.syntaxSchemas.size()]);
        }
        return this.syntaxSchemaArray;
    }

    public XsESchema getCurrentSyntaxSchema() {
        if (this.syntaxSchemaArray == null || this.syntaxSchemaArray.length == 0) {
            return null;
        }
        return this.syntaxSchemaArray[this.syntaxSchemaArray.length - 1];
    }

    private static class SubstitutionGroup {
        private final List members = new ArrayList();
        private final XSElement head;

        SubstitutionGroup(XSElement pHead) {
            this.head = pHead;
        }

        XSElement getHead() {
            return this.head;
        }

        XSElement[] getMembers() {
            return this.members.toArray(new XSElement[this.members.size()]);
        }

        void addMember(XSElement pElement) {
            this.members.add(pElement);
        }
    }

    public static class AddedImport {
        private final String targetNamespace;
        private final String schemaLocation;
        private final Node node;

        public AddedImport(XsAnyURI pTargetNamespace, String pSchemaLocation) {
            this(pTargetNamespace == null ? "" : pTargetNamespace.toString(), pSchemaLocation);
        }

        public AddedImport(String pTargetNamespace, String pSchemaLocation) {
            this(pTargetNamespace, pSchemaLocation, null);
        }

        public AddedImport(String pTargetNamespace, String pSchemaLocation, Node pNode) {
            String string = this.targetNamespace = pTargetNamespace == null ? "" : pTargetNamespace.toString();
            if (pSchemaLocation == null) {
                throw new IllegalStateException("The schemaLocation must not be null.");
            }
            this.schemaLocation = pSchemaLocation;
            this.node = pNode;
        }

        public boolean equals(Object pOther) {
            if (pOther instanceof AddedImport) {
                AddedImport other = (AddedImport)pOther;
                return this.targetNamespace.equals(other.targetNamespace) && this.schemaLocation.equals(other.schemaLocation);
            }
            return false;
        }

        public int hashCode() {
            return this.targetNamespace.hashCode() + this.schemaLocation.hashCode();
        }

        public String getNamespace() {
            return this.targetNamespace;
        }

        public String getSchemaLocation() {
            return this.schemaLocation;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

