/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.parser.impl;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LocSAXException
extends SAXParseException {
    public static String formatMsg(String pMsg, String pPublicId, String pSystemId, int pLineNumber, int pColNumber) {
        StringBuffer sb = new StringBuffer();
        if (pSystemId != null) {
            sb.append(pSystemId);
        }
        if (pLineNumber != -1) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("line ").append(pLineNumber);
        }
        if (pColNumber != -1) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("column ").append(pColNumber);
        }
        if (sb.length() == 0) {
            return "" + pMsg;
        }
        return "At " + sb + ": " + pMsg;
    }

    private static String formatMsg(String pMsg, Locator pLocator) {
        if (pLocator == null) {
            return pMsg;
        }
        return LocSAXException.formatMsg(pMsg, pLocator.getPublicId(), pLocator.getSystemId(), pLocator.getLineNumber(), pLocator.getColumnNumber());
    }

    public LocSAXException(String pMsg, String pPublicId, String pSystemId, int pLineNumber, int pColumnNumber, Exception pException) {
        super(LocSAXException.formatMsg(pMsg, pPublicId, pSystemId, pLineNumber, pColumnNumber), pPublicId, pSystemId, pLineNumber, pColumnNumber, pException);
    }

    public LocSAXException(String pMsg, String pPublicId, String pSystemId, int pLineNumber, int pColumnNumber) {
        super(LocSAXException.formatMsg(pMsg, pPublicId, pSystemId, pLineNumber, pColumnNumber), pPublicId, pSystemId, pLineNumber, pColumnNumber);
    }

    public LocSAXException(String pMsg, Locator pLocator, Exception pException) {
        super(LocSAXException.formatMsg(pMsg, pLocator), pLocator, pException);
    }

    public LocSAXException(String pMsg, Locator pLocator) {
        super(LocSAXException.formatMsg(pMsg, pLocator), pLocator);
    }

    public void printStackTrace(PrintStream pStream) {
        super.printStackTrace(pStream);
        Exception e = this.getException();
        while (e != null) {
            pStream.println("Caused by:");
            e.printStackTrace(pStream);
            if (e instanceof SAXException) {
                e = ((SAXException)e).getException();
                continue;
            }
            e = null;
        }
    }

    public void printStackTrace(PrintWriter pWriter) {
        super.printStackTrace(pWriter);
        Exception e = this.getException();
        while (e != null) {
            pWriter.println("Caused by:");
            e.printStackTrace(pWriter);
            if (e instanceof SAXException) {
                e = ((SAXException)e).getException();
                continue;
            }
            e = null;
        }
    }
}

