/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.impl.XSLogicalParser;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.impl.XSContextImpl;
import org.apache.ws.jaxme.xs.types.XSAnyType;
import org.apache.ws.jaxme.xs.types.XSEntities;
import org.apache.ws.jaxme.xs.types.XSEntity;
import org.apache.ws.jaxme.xs.types.XSID;
import org.apache.ws.jaxme.xs.types.XSIDREF;
import org.apache.ws.jaxme.xs.types.XSIDREFs;
import org.apache.ws.jaxme.xs.types.XSNMToken;
import org.apache.ws.jaxme.xs.types.XSNMTokens;
import org.apache.ws.jaxme.xs.types.XSNotation;
import org.apache.ws.jaxme.xs.types.XSString;
import org.apache.ws.jaxme.xs.xml.XsAGOccurs;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;
import org.apache.ws.jaxme.xs.xml.XsEChoice;
import org.apache.ws.jaxme.xs.xml.XsEComplexContent;
import org.apache.ws.jaxme.xs.xml.XsEEnumeration;
import org.apache.ws.jaxme.xs.xml.XsERestriction;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsESimpleContent;
import org.apache.ws.jaxme.xs.xml.XsGAttrDecls;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTAttribute;
import org.apache.ws.jaxme.xs.xml.XsTExplicitGroup;
import org.apache.ws.jaxme.xs.xml.XsTExtensionType;
import org.apache.ws.jaxme.xs.xml.XsTLocalComplexType;
import org.apache.ws.jaxme.xs.xml.XsTLocalElement;
import org.apache.ws.jaxme.xs.xml.XsTLocalSimpleType;
import org.apache.ws.jaxme.xs.xml.XsTSimpleExtensionType;
import org.apache.ws.jaxme.xs.xml.XsTTopLevelElement;
import org.apache.ws.jaxme.xs.xml.impl.XsESchemaImpl;
import org.apache.ws.jaxme.xs.xml.impl.XsObjectFactoryImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class DTDParser
extends XSLogicalParser {
    private Locator locator;
    private final Map elements = new HashMap();
    private String dummyElementName;
    private XsAnyURI targetNamespace;
    private XSContext context;

    public XSContext getData() {
        return this.context;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator pLocator) {
        this.locator = pLocator;
        XSContext context = this.getData();
        if (context != null) {
            context.setLocator(pLocator);
        }
    }

    protected String getDummyElementName() {
        if (this.dummyElementName == null) {
            int i = 0;
            while (true) {
                String name;
                if (!this.elements.containsKey(name = "dummyElement" + i)) {
                    this.dummyElementName = name;
                    break;
                }
                ++i;
            }
        }
        return this.dummyElementName;
    }

    protected void runXMLReader(final InputSource pSource) throws ParserConfigurationException, IOException, SAXException {
        String s = "<!DOCTYPE a SYSTEM 'uri:dtd'><a/>";
        InputSource isource = new InputSource(new StringReader(s));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        XMLReader xr = spf.newSAXParser().getXMLReader();
        xr.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String pSystemId) throws SAXException, IOException {
                return "uri:dtd".equals(pSystemId) ? pSource : null;
            }
        });
        DtdDeclHandler handler = new DtdDeclHandler();
        xr.setContentHandler(handler);
        xr.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
        xr.parse(isource);
    }

    private ChildToken addToChildToken(ChildToken pToken, String pTokenValue, String pMultiplicity, int pType, Locator pLocator) throws SAXException {
        if ("".equals(pTokenValue)) {
            throw new SAXParseException("Expected name, choice, or sequence, found empty string", pLocator);
        }
        if (pToken == null) {
            pToken = new ChildToken(pType, pMultiplicity);
        } else if (pType != pToken.getType()) {
            throw new SAXParseException("Mixed use of ',' and '|' in a choice or sequence", pLocator);
        }
        if (pTokenValue.startsWith("(")) {
            pToken.add(this.parseChildren(pTokenValue, pLocator));
        } else {
            pToken.add(pTokenValue);
        }
        return pToken;
    }

    protected String getMultiplicity(String pToken) {
        if (pToken.endsWith("*")) {
            return "*";
        }
        if (pToken.endsWith("?")) {
            return "?";
        }
        if (pToken.endsWith("+")) {
            return "+";
        }
        return "";
    }

    protected ChildToken parseChildren(String pModel, Locator pLocator) throws SAXException {
        String model = pModel;
        if (!model.startsWith("(")) {
            throw new SAXParseException("A choice or sequence must start with '('", pLocator);
        }
        model = model.substring(1).trim();
        String multiplicity = this.getMultiplicity(model);
        model = model.substring(0, model.length() - multiplicity.length()).trim();
        if (!model.endsWith(")")) {
            throw new SAXParseException("A choice or sequence must end with ')', ')?', ')*', or ')+'", pLocator);
        }
        model = model.substring(0, model.length() - 1);
        ChildToken ct = null;
        int level = 0;
        int offset = 0;
        block5: for (int i = 0; i < model.length(); ++i) {
            char c = model.charAt(i);
            switch (c) {
                case '(': {
                    ++level;
                    continue block5;
                }
                case ')': {
                    --level;
                    continue block5;
                }
                case ',': 
                case '|': {
                    if (level != 0) continue block5;
                    String t = model.substring(offset, i).trim();
                    ct = this.addToChildToken(ct, t, multiplicity, c == '|' ? 2 : 1, pLocator);
                    offset = i + 1;
                }
            }
        }
        String t = model.substring(offset).trim();
        return this.addToChildToken(ct, t, multiplicity, ct == null ? 1 : ct.getType(), pLocator);
    }

    protected void setMultiplicity(XsAGOccurs pOccurs, String pMultiplicity) {
        if ("?".equals(pMultiplicity)) {
            pOccurs.setMinOccurs(0);
        } else if ("*".equals(pMultiplicity)) {
            pOccurs.setMinOccurs(0);
            pOccurs.setMaxOccurs("unbounded");
        } else if ("+".equals(pMultiplicity)) {
            pOccurs.setMaxOccurs("unbounded");
        } else if (!"".equals(pMultiplicity)) {
            throw new IllegalArgumentException("Invalid multiplicity: " + pMultiplicity);
        }
    }

    protected void addChildren(XsTTopLevelElement pElement, XsTExplicitGroup pGroup, ChildToken pToken, Locator pLocator) throws SAXException {
        this.setMultiplicity(pGroup, pToken.getMultiplicity());
        Object[] tokens = pToken.getChilds();
        for (int i = 0; i < tokens.length; ++i) {
            Object o = tokens[i];
            if (o instanceof String) {
                String name = (String)o;
                String multiplicity = this.getMultiplicity(name);
                if (!this.elements.containsKey(name = name.substring(0, name.length() - multiplicity.length()).trim())) {
                    throw new SAXParseException("Element " + pElement.getName() + " references an undeclared element " + name, pLocator);
                }
                XsTLocalElement e = pGroup.createElement();
                e.setRef(new XsQName(this.getTargetNamespace(), this.getLocalPart(name)));
                this.setMultiplicity(e, multiplicity);
                continue;
            }
            if (o instanceof ChildToken) {
                ChildToken ct = (ChildToken)o;
                XsTExplicitGroup group = ct.type == 1 ? pGroup.createSequence() : pGroup.createChoice();
                this.addChildren(pElement, group, ct, pLocator);
                continue;
            }
            throw new IllegalStateException("Unknown token type: " + tokens[i].getClass().getName());
        }
    }

    protected XsGAttrDecls parseChildren(XsTTopLevelElement pElement, String pModel, Locator pLocator) throws SAXException {
        ChildToken ct = this.parseChildren(pModel, pLocator);
        XsTLocalComplexType complexType = pElement.createComplexType();
        XsTExplicitGroup group = ct.getType() == 1 ? complexType.createSequence() : complexType.createChoice();
        this.addChildren(pElement, group, ct, pLocator);
        return complexType;
    }

    protected XsGAttrDecls parseMixed(XsTTopLevelElement pElement, String pModel, Locator pLocator, boolean pHasAttributes) throws SAXException {
        boolean unbounded;
        if (!pModel.startsWith("(")) {
            throw new SAXParseException("Mixed content model must start with '(#PCDATA'", pLocator);
        }
        if (!(pModel = pModel.substring(1).trim()).startsWith("#PCDATA")) {
            throw new SAXParseException("Mixed content model must start with '(#PCDATA'", pLocator);
        }
        if ((pModel = pModel.substring("#PCDATA".length()).trim()).endsWith("*")) {
            pModel = pModel.substring(0, pModel.length() - 1).trim();
            unbounded = true;
        } else {
            unbounded = false;
        }
        if (!pModel.endsWith(")")) {
            throw new SAXParseException("Mixed content model must end with ')' or ')*'", pLocator);
        }
        if ("".equals(pModel = pModel.substring(0, pModel.length() - 1))) {
            XsQName qName = XSString.getInstance().getName();
            qName = new XsQName(qName.getNamespaceURI(), qName.getLocalName(), "xs");
            if (pHasAttributes) {
                XsTLocalComplexType complexType = pElement.createComplexType();
                XsESimpleContent simpleContent = complexType.createSimpleContent();
                XsTSimpleExtensionType ext = simpleContent.createExtension();
                ext.setBase(qName);
                return ext;
            }
            pElement.setType(qName);
            return null;
        }
        if (!unbounded) {
            throw new SAXParseException("Mixed content must be either #PCDATA or have multiplicity '*'", pLocator);
        }
        XsTLocalComplexType complexType = pElement.createComplexType();
        complexType.setMixed(true);
        XsEChoice choice = complexType.createChoice();
        choice.setMinOccurs(0);
        choice.setMaxOccurs("unbounded");
        while (!"".equals(pModel)) {
            String name;
            if (!pModel.startsWith("|")) {
                throw new SAXParseException("Expected '|' while parsing mixed content", pLocator);
            }
            pModel = pModel.substring(1).trim();
            int offset = pModel.indexOf(124);
            if (offset == -1) {
                name = pModel.trim();
                pModel = "";
            } else {
                name = pModel.substring(0, offset).trim();
                pModel = pModel.substring(offset);
            }
            if (this.elements.containsKey(name)) {
                XsTLocalElement e = choice.createElement();
                e.setRef(new XsQName(this.getTargetNamespace(), this.getLocalPart(name)));
                continue;
            }
            throw new SAXParseException("Element " + pElement.getName() + " references element " + name + ", which is not declared", pLocator);
        }
        return complexType;
    }

    protected void createAttribute(XsGAttrDecls pAttrDecls, DTDAttribute pAttribute) throws SAXException {
        XsQName qName;
        XsTAttribute attr = pAttrDecls.createAttribute();
        attr.setName(new XsNCName(this.getLocalPart(pAttribute.getName())));
        String type = pAttribute.getType();
        if ("CDATA".equals(type)) {
            qName = XSString.getInstance().getName();
        } else if ("ID".equals(type)) {
            qName = XSID.getInstance().getName();
        } else if ("IDREF".equals(type)) {
            qName = XSIDREF.getInstance().getName();
        } else if ("IDREFS".equals(type)) {
            qName = XSIDREFs.getInstance().getName();
        } else if ("ENTITY".equals(type)) {
            qName = XSEntity.getInstance().getName();
        } else if ("ENTITIES".equals(type)) {
            qName = XSEntities.getInstance().getName();
        } else if ("NMTOKEN".equals(type)) {
            qName = XSNMToken.getInstance().getName();
        } else if ("NMTOKENS".equals(type)) {
            qName = XSNMTokens.getInstance().getName();
        } else {
            qName = type.startsWith("NOTATION") && Character.isWhitespace(type.charAt("NOTATION".length())) ? XSNotation.getInstance().getName() : XSNMToken.getInstance().getName();
            XsTLocalSimpleType simpleType = attr.createSimpleType();
            XsERestriction restriction = simpleType.createRestriction();
            restriction.setBase(new XsQName(qName.getNamespaceURI(), qName.getLocalName(), "xs"));
            if (!type.startsWith("(")) {
                throw new SAXParseException("The enumeration in the type of attribute " + pAttribute.getName() + " must begin with an '('.", pAttribute.getLocator());
            }
            type = type.substring(1).trim();
            if (!type.endsWith(")")) {
                throw new SAXParseException("The enumeration in the type of attribute " + pAttribute.getName() + " must begin with an '('.", pAttribute.getLocator());
            }
            type = type.substring(0, type.length() - 1).trim();
            StringTokenizer st = new StringTokenizer(type, "|");
            if (!st.hasMoreTokens()) {
                throw new SAXParseException("The enumeration in the type of attribute " + pAttribute.getName() + " contains no tokens.", pAttribute.getLocator());
            }
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if ("".equals(token)) {
                    throw new SAXParseException("The enumeration in the type of attribute " + pAttribute.getName() + " contains an empty token.", pAttribute.getLocator());
                }
                XsEEnumeration enumeration = restriction.createEnumeration();
                enumeration.setValue(token);
            }
            qName = null;
        }
        if (qName != null) {
            attr.setType(new XsQName(qName.getNamespaceURI(), qName.getLocalName(), "xs"));
        }
    }

    private String getLocalPart(String pName) {
        int offset = pName.indexOf(58);
        if (offset >= 0) {
            return pName.substring(offset + 1);
        }
        return pName;
    }

    protected XsTTopLevelElement createElement(XsESchema pSchema, String pName, String pModel, DTDAttribute[] pAttributes, Locator pLocator) throws SAXException {
        XsGAttrDecls attrDecls;
        XsTTopLevelElement result = pSchema.createElement();
        result.setName(new XsNCName(this.getLocalPart(pName)));
        if ("EMPTY".equals(pModel)) {
            attrDecls = result.createComplexType();
        } else if ("ANY".equals(pModel)) {
            XsQName qName = XSAnyType.getInstance().getName();
            qName = new XsQName(qName.getNamespaceURI(), qName.getLocalName(), "xs");
            if (pAttributes.length == 0) {
                result.setType(qName);
                attrDecls = null;
            } else {
                XsTLocalComplexType complexType = result.createComplexType();
                XsEComplexContent complexContent = complexType.createComplexContent();
                XsTExtensionType extensionType = complexContent.createExtension();
                extensionType.setBase(qName);
                attrDecls = extensionType;
            }
        } else if (pModel.startsWith("(")) {
            String pcData = pModel.substring(1).trim();
            attrDecls = pcData.startsWith("#PCDATA") ? this.parseMixed(result, pModel, pLocator, pAttributes.length > 0) : this.parseChildren(result, pModel, pLocator);
        } else {
            throw new SAXParseException("Invalid content model in element " + pName + ", expected EMPTY|ANY|(...", pLocator);
        }
        for (int i = 0; i < pAttributes.length; ++i) {
            this.createAttribute(attrDecls, pAttributes[i]);
        }
        return result;
    }

    protected void parse(XsESchema pSchema, InputSource pSource) throws ParserConfigurationException, IOException, SAXException {
        this.runXMLReader(pSource);
        Iterator iter = this.elements.values().iterator();
        while (iter.hasNext()) {
            DTDElement element = (DTDElement)iter.next();
            String name = element.getName();
            String model = element.getModel();
            DTDAttribute[] attrs = element.getAttributes();
            if (attrs.length > 0 && model == null) {
                throw new SAXParseException("The element " + name + " is referred by attribute " + attrs[0].getName() + ", but never declared.", attrs[0].getLocator());
            }
            this.createElement(pSchema, name, model, element.getAttributes(), element.getLocator());
        }
    }

    public XSSchema parse(InputSource pInputSource) throws ParserConfigurationException, IOException, SAXException {
        XsObjectFactoryImpl xsObjectFactory = new XsObjectFactoryImpl(){

            public XSContext getContext() {
                return DTDParser.this.getData();
            }
        };
        this.context = new XSContextImpl();
        this.context.setXSLogicalParser(this);
        this.context.setXsObjectFactory(xsObjectFactory);
        this.clearSyntaxSchemas();
        XsESchemaImpl syntaxSchema = new XsESchemaImpl(this.context){};
        this.parse((XsESchema)syntaxSchema, pInputSource);
        XSSchema schema = this.context.getXSObjectFactory().newXSSchema(this.context, syntaxSchema);
        this.setSchema(schema);
        this.parse((XsESchema)syntaxSchema, pInputSource.getSystemId());
        schema.validate();
        return schema;
    }

    public void setTargetNamespace(XsAnyURI pTargetNamespace) {
        this.targetNamespace = pTargetNamespace;
    }

    public XsAnyURI getTargetNamespace() {
        return this.targetNamespace;
    }

    public class DtdDeclHandler
    extends DefaultHandler
    implements DeclHandler {
        public void setDocumentLocator(Locator pLocator) {
            DTDParser.this.setLocator(pLocator);
        }

        public void elementDecl(String pName, String pModel) throws SAXException {
            DTDElement element = (DTDElement)DTDParser.this.elements.get(pName);
            if (element == null) {
                element = new DTDElement(pName);
                DTDParser.this.elements.put(pName, element);
            } else if (element.getModel() != null) {
                throw new SAXParseException("Element " + pName + " declared twice", DTDParser.this.getLocator());
            }
            element.setModel(pModel);
        }

        public void attributeDecl(String pElementName, String pAttributeName, String pType, String pMode, String pValue) throws SAXException {
            DTDElement element = (DTDElement)DTDParser.this.elements.get(pElementName);
            if (element == null) {
                element = new DTDElement(pElementName);
                DTDParser.this.elements.put(pElementName, element);
            }
            DTDAttribute attr = new DTDAttribute(pAttributeName, pType, pMode, pValue);
            element.addAttribute(attr);
        }

        public void internalEntityDecl(String pName, String pValue) throws SAXException {
        }

        public void externalEntityDecl(String pName, String publicId, String pSystemId) throws SAXException {
        }
    }

    public static class StringBufferReader
    extends Reader {
        private final StringBuffer sb = new StringBuffer();

        public void append(String pString) {
            this.sb.append(pString);
        }

        public String requestInput() {
            return null;
        }

        public int read(char[] pBuffer, int pOffset, int pLen) throws IOException {
            if (this.sb.length() == 0) {
                String s = this.requestInput();
                if (s != null && s.length() > 0) {
                    this.append(s);
                }
                if (this.sb.length() == 0) {
                    return -1;
                }
            }
            if (pLen >= this.sb.length()) {
                pLen = this.sb.length();
            }
            for (int i = 0; i < pLen; ++i) {
                pBuffer[pOffset + i] = this.sb.charAt(i);
            }
            this.sb.delete(0, pLen);
            return pLen;
        }

        public void close() throws IOException {
        }
    }

    protected static class ChildToken {
        public static final int SEQUENCE = 1;
        public static final int CHOICE = 2;
        private final int type;
        private final List tokens = new ArrayList();
        private final String multiplicity;

        protected ChildToken(int pType, String pMultiplicity) {
            this.type = pType;
            this.multiplicity = pMultiplicity;
        }

        public int getType() {
            return this.type;
        }

        public void add(ChildToken pToken) {
            this.tokens.add(pToken);
        }

        public void add(String pName) {
            this.tokens.add(pName);
        }

        public Object[] getChilds() {
            return this.tokens.toArray();
        }

        public String getMultiplicity() {
            return this.multiplicity;
        }
    }

    public class DTDElement {
        private final String name;
        private Locator loc;
        private String model;
        private Map attributes = new HashMap();

        public DTDElement(String pName) {
            this.name = pName;
        }

        public void setModel(String pModel) {
            Locator l = DTDParser.this.getLocator();
            this.loc = l == null ? null : new LocatorImpl(l);
            this.model = pModel;
        }

        public String getModel() {
            return this.model;
        }

        public String getName() {
            return this.name;
        }

        public void addAttribute(DTDAttribute pAttribute) throws SAXException {
            if (this.attributes.put(pAttribute.getName(), pAttribute) != null) {
                throw new SAXParseException("Duplicate attribute " + pAttribute.getName() + " in element " + this.getName(), pAttribute.getLocator());
            }
        }

        public DTDAttribute[] getAttributes() {
            return this.attributes.values().toArray(new DTDAttribute[this.attributes.size()]);
        }

        public Locator getLocator() {
            return this.loc;
        }
    }

    public class DTDAttribute {
        private final String name;
        private final String type;
        private final String mode;
        private final String value;
        private final Locator loc;

        public DTDAttribute(String pName, String pType, String pMode, String pValue) {
            this.name = pName;
            this.type = pType;
            this.mode = pMode;
            this.value = pValue;
            Locator l = DTDParser.this.getLocator();
            this.loc = l == null ? null : new LocatorImpl(l);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getMode() {
            return this.mode;
        }

        public String getValue() {
            return this.value;
        }

        public Locator getLocator() {
            return this.loc;
        }
    }
}

