/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;

public class AlgorithmSuite
extends AbstractSecurityAssertion
implements PolicyContainingAssertion {
    protected static final Map<String, AlgorithmSuiteType> algorithmSuiteTypes = new HashMap<String, AlgorithmSuiteType>();
    private Policy nestedPolicy;
    private AlgorithmSuiteType algorithmSuiteType;
    private C14NType c14n = C14NType.ExclusiveC14N;
    private SOAPNormType soapNormType = SOAPNormType.SOAPNormalizationNone;
    private STRType strType = STRType.STRTransformNone;
    private XPathType xPathType = XPathType.XPathNone;
    private String symmetricSignature = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private String asymmetricSignature = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String computedKey = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";

    public AlgorithmSuite(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version);
        this.nestedPolicy = nestedPolicy;
        this.parseNestedPolicy(nestedPolicy, this);
    }

    public Policy getPolicy() {
        return this.nestedPolicy;
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getAlgorithmSuite();
    }

    @Override
    public PolicyComponent normalize() {
        return super.normalize(this.getPolicy());
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        super.serialize(writer, this.getPolicy());
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new AlgorithmSuite(this.getVersion(), nestedPolicy);
    }

    protected void parseNestedPolicy(Policy nestedPolicy, AlgorithmSuite algorithmSuite) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (!this.getVersion().getNamespace().equals(assertionNamespace)) {
                    this.parseCustomAssertion(assertion);
                    continue;
                }
                AlgorithmSuiteType algorithmSuiteType = algorithmSuiteTypes.get(assertionName);
                if (algorithmSuiteType != null) {
                    if (algorithmSuite.getAlgorithmSuiteType() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    AlgorithmSuiteType newAlgorithmSuiteType = new AlgorithmSuiteType(algorithmSuiteType);
                    newAlgorithmSuiteType.setNamespace(this.getVersion().getNamespace());
                    algorithmSuite.setAlgorithmSuiteType(newAlgorithmSuiteType);
                    continue;
                }
                C14NType c14NType = C14NType.lookUp(assertionName);
                if (c14NType != null) {
                    algorithmSuite.setC14n(c14NType);
                    continue;
                }
                SOAPNormType soapNormType = SOAPNormType.lookUp(assertionName);
                if (soapNormType != null) {
                    if (algorithmSuite.getSoapNormType() == SOAPNormType.SOAPNormalization10) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    algorithmSuite.setSoapNormType(soapNormType);
                    continue;
                }
                STRType strType = STRType.lookUp(assertionName);
                if (strType != null) {
                    if (algorithmSuite.getStrType() == STRType.STRTransform10) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    algorithmSuite.setStrType(strType);
                    continue;
                }
                XPathType xPathType = XPathType.lookUp(assertionName);
                if (xPathType == null) continue;
                if (algorithmSuite.getXPathType() != XPathType.XPathNone) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                algorithmSuite.setXPathType(xPathType);
            }
        }
    }

    protected void parseCustomAssertion(Assertion assertion) {
    }

    public AlgorithmSuiteType getAlgorithmSuiteType() {
        return this.algorithmSuiteType;
    }

    protected void setAlgorithmSuiteType(AlgorithmSuiteType algorithmSuiteType) {
        this.algorithmSuiteType = algorithmSuiteType;
    }

    public C14NType getC14n() {
        return this.c14n;
    }

    protected void setC14n(C14NType c14n) {
        this.c14n = c14n;
    }

    public SOAPNormType getSoapNormType() {
        return this.soapNormType;
    }

    protected void setSoapNormType(SOAPNormType soapNormType) {
        this.soapNormType = soapNormType;
    }

    public STRType getStrType() {
        return this.strType;
    }

    protected void setStrType(STRType strType) {
        this.strType = strType;
    }

    public XPathType getXPathType() {
        return this.xPathType;
    }

    protected void setXPathType(XPathType xPathType) {
        this.xPathType = xPathType;
    }

    public String getAsymmetricSignature() {
        return this.asymmetricSignature;
    }

    public String getSymmetricSignature() {
        return this.symmetricSignature;
    }

    public String getComputedKey() {
        return this.computedKey;
    }

    public static Collection<String> getSupportedAlgorithmSuiteNames() {
        return algorithmSuiteTypes.keySet();
    }

    public void setSymmetricSignature(String symmetricSignature) {
        this.symmetricSignature = symmetricSignature;
    }

    public void setAsymmetricSignature(String asymmetricSignature) {
        this.asymmetricSignature = asymmetricSignature;
    }

    static {
        algorithmSuiteTypes.put("Basic256", new AlgorithmSuiteType("Basic256", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 256, 192, 256, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic192", new AlgorithmSuiteType("Basic192", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic128", new AlgorithmSuiteType("Basic128", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
        algorithmSuiteTypes.put("TripleDes", new AlgorithmSuiteType("TripleDes", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#kw-tripledes", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic256Rsa15", new AlgorithmSuiteType("Basic256Rsa15", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 256, 192, 256, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic192Rsa15", new AlgorithmSuiteType("Basic192Rsa15", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic128Rsa15", new AlgorithmSuiteType("Basic128Rsa15", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
        algorithmSuiteTypes.put("TripleDesRsa15", new AlgorithmSuiteType("TripleDesRsa15", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#kw-tripledes", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic256Sha256", new AlgorithmSuiteType("Basic256Sha256", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 256, 256, 256, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic192Sha256", new AlgorithmSuiteType("Basic192Sha256", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic128Sha256", new AlgorithmSuiteType("Basic128Sha256", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
        algorithmSuiteTypes.put("TripleDesSha256", new AlgorithmSuiteType("TripleDesSha256", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#kw-tripledes", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic256Sha256Rsa15", new AlgorithmSuiteType("Basic256Sha256Rsa15", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 256, 192, 256, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic192Sha256Rsa15", new AlgorithmSuiteType("Basic192Sha256Rsa15", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
        algorithmSuiteTypes.put("Basic128Sha256Rsa15", new AlgorithmSuiteType("Basic128Sha256Rsa15", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
        algorithmSuiteTypes.put("TripleDesSha256Rsa15", new AlgorithmSuiteType("TripleDesSha256Rsa15", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#kw-tripledes", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
    }

    public static enum STRType {
        STRTransformNone(null),
        STRTransform10("STRTransform10");

        private static final Map<String, STRType> lookup;
        private String value;

        public static STRType lookUp(String name) {
            return lookup.get(name);
        }

        public String getValue() {
            return this.value;
        }

        private STRType(String value) {
            this.value = value;
        }

        static {
            lookup = new HashMap<String, STRType>();
            for (STRType u : EnumSet.allOf(STRType.class)) {
                lookup.put(u.name(), u);
            }
        }
    }

    public static enum SOAPNormType {
        SOAPNormalizationNone(null),
        SOAPNormalization10("SoapNormalization10");

        private static final Map<String, SOAPNormType> lookup;
        private String value;

        public static SOAPNormType lookUp(String name) {
            return lookup.get(name);
        }

        public String getValue() {
            return this.value;
        }

        private SOAPNormType(String value) {
            this.value = value;
        }

        static {
            lookup = new HashMap<String, SOAPNormType>();
            for (SOAPNormType u : EnumSet.allOf(SOAPNormType.class)) {
                lookup.put(u.name(), u);
            }
        }
    }

    public static enum C14NType {
        ExclusiveC14N("http://www.w3.org/2001/10/xml-exc-c14n#"),
        InclusiveC14N("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"),
        InclusiveC14N11("http://www.w3.org/2006/12/xml-c14n11");

        private static final Map<String, C14NType> lookup;
        private String value;

        public static C14NType lookUp(String name) {
            return lookup.get(name);
        }

        public String getValue() {
            return this.value;
        }

        private C14NType(String value) {
            this.value = value;
        }

        static {
            lookup = new HashMap<String, C14NType>();
            for (C14NType u : EnumSet.allOf(C14NType.class)) {
                lookup.put(u.name(), u);
            }
        }
    }

    public static enum XPathType {
        XPathNone(null),
        XPath10("http://www.w3.org/TR/1999/REC-xpath-19991116"),
        XPathFilter20("http://www.w3.org/2002/06/xmldsig-filter2"),
        AbsXPath("http://docs.oasis-open.org/...TBD.../AbsXPath");

        private static final Map<String, XPathType> lookup;
        private String value;

        public static XPathType lookUp(String name) {
            return lookup.get(name);
        }

        public String getValue() {
            return this.value;
        }

        private XPathType(String value) {
            this.value = value;
        }

        static {
            lookup = new HashMap<String, XPathType>();
            for (XPathType u : EnumSet.allOf(XPathType.class)) {
                lookup.put(u.name(), u);
            }
        }
    }

    public static final class AlgorithmSuiteType {
        private String name;
        private String digest;
        private String encryption;
        private String symmetricKeyWrap;
        private String asymmetricKeyWrap;
        private String encryptionKeyDerivation;
        private String signatureKeyDerivation;
        private int encryptionDerivedKeyLength;
        private int signatureDerivedKeyLength;
        private int minimumSymmetricKeyLength;
        private int maximumSymmetricKeyLength;
        private int minimumAsymmetricKeyLength;
        private int maximumAsymmetricKeyLength;
        private String mgfAlgo;
        private String ns;

        public AlgorithmSuiteType(String name, String digest, String encryption, String symmetricKeyWrap, String asymmetricKeyWrap, String encryptionKeyDerivation, String signatureKeyDerivation, int encryptionDerivedKeyLength, int signatureDerivedKeyLength, int minimumSymmetricKeyLength, int maximumSymmetricKeyLength, int minimumAsymmetricKeyLength, int maximumAsymmetricKeyLength) {
            this.name = name;
            this.digest = digest;
            this.encryption = encryption;
            this.symmetricKeyWrap = symmetricKeyWrap;
            this.asymmetricKeyWrap = asymmetricKeyWrap;
            this.encryptionKeyDerivation = encryptionKeyDerivation;
            this.signatureKeyDerivation = signatureKeyDerivation;
            this.encryptionDerivedKeyLength = encryptionDerivedKeyLength;
            this.signatureDerivedKeyLength = signatureDerivedKeyLength;
            this.minimumSymmetricKeyLength = minimumSymmetricKeyLength;
            this.maximumSymmetricKeyLength = maximumSymmetricKeyLength;
            this.minimumAsymmetricKeyLength = minimumAsymmetricKeyLength;
            this.maximumAsymmetricKeyLength = maximumAsymmetricKeyLength;
        }

        public AlgorithmSuiteType(AlgorithmSuiteType algorithmSuiteType) {
            this.name = algorithmSuiteType.name;
            this.digest = algorithmSuiteType.digest;
            this.encryption = algorithmSuiteType.encryption;
            this.symmetricKeyWrap = algorithmSuiteType.symmetricKeyWrap;
            this.asymmetricKeyWrap = algorithmSuiteType.asymmetricKeyWrap;
            this.encryptionKeyDerivation = algorithmSuiteType.encryptionKeyDerivation;
            this.signatureKeyDerivation = algorithmSuiteType.signatureKeyDerivation;
            this.encryptionDerivedKeyLength = algorithmSuiteType.encryptionDerivedKeyLength;
            this.signatureDerivedKeyLength = algorithmSuiteType.signatureDerivedKeyLength;
            this.minimumSymmetricKeyLength = algorithmSuiteType.minimumSymmetricKeyLength;
            this.maximumSymmetricKeyLength = algorithmSuiteType.maximumSymmetricKeyLength;
            this.minimumAsymmetricKeyLength = algorithmSuiteType.minimumAsymmetricKeyLength;
            this.maximumAsymmetricKeyLength = algorithmSuiteType.maximumAsymmetricKeyLength;
            this.mgfAlgo = algorithmSuiteType.mgfAlgo;
        }

        public String getName() {
            return this.name;
        }

        public String getDigest() {
            return this.digest;
        }

        public String getEncryption() {
            return this.encryption;
        }

        public String getSymmetricKeyWrap() {
            return this.symmetricKeyWrap;
        }

        public String getAsymmetricKeyWrap() {
            return this.asymmetricKeyWrap;
        }

        public String getEncryptionKeyDerivation() {
            return this.encryptionKeyDerivation;
        }

        public String getSignatureKeyDerivation() {
            return this.signatureKeyDerivation;
        }

        public int getEncryptionDerivedKeyLength() {
            return this.encryptionDerivedKeyLength;
        }

        public int getSignatureDerivedKeyLength() {
            return this.signatureDerivedKeyLength;
        }

        public int getMinimumSymmetricKeyLength() {
            return this.minimumSymmetricKeyLength;
        }

        public int getMaximumSymmetricKeyLength() {
            return this.maximumSymmetricKeyLength;
        }

        public int getMinimumAsymmetricKeyLength() {
            return this.minimumAsymmetricKeyLength;
        }

        public int getMaximumAsymmetricKeyLength() {
            return this.maximumAsymmetricKeyLength;
        }

        public void setNamespace(String ns) {
            this.ns = ns;
        }

        public String getNamespace() {
            return this.ns;
        }

        public void setMGFAlgo(String mgfAlgo) {
            this.mgfAlgo = mgfAlgo;
        }

        public String getMGFAlgo() {
            return this.mgfAlgo;
        }
    }
}

