/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.wss4j.common.crypto.SantuarioUtil;
import org.apache.wss4j.common.util.Loader;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSProviderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WSProviderConfig.class);
    private static boolean addJceProviders = true;
    private static boolean staticallyInitialized = false;

    private WSProviderConfig() {
    }

    public static synchronized void init() {
        if (!staticallyInitialized) {
            if (addJceProviders) {
                WSProviderConfig.initializeResourceBundles();
                WSProviderConfig.setXmlSecIgnoreLineBreak();
                AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        WSProviderConfig.addXMLDSigRIInternal();
                        WSProviderConfig.addJceProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
                        return true;
                    }
                });
            }
            staticallyInitialized = true;
        }
    }

    public static void setAddJceProviders(boolean value) {
        addJceProviders = value;
    }

    public static void setXmlSecIgnoreLineBreak() {
        boolean wasSet = false;
        try {
            wasSet = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
                    if (System.getProperty(lineBreakPropName) == null) {
                        System.setProperty(lineBreakPropName, "true");
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Throwable t) {
            // empty catch block
        }
        Init.init();
        if (!wasSet) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        Field f = XMLUtils.class.getDeclaredField("ignoreLineBreaks");
                        f.setAccessible(true);
                        f.set(null, Boolean.TRUE);
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void addXMLDSigRIInternal() {
        WSProviderConfig.addJceProvider("ApacheXMLDSig", SantuarioUtil.getSantuarioProvider());
    }

    private static void initializeResourceBundles() {
        ResourceBundle resourceBundle = new ResourceBundle(){
            private final ResourceBundle wss4jSecResourceBundle = ResourceBundle.getBundle("messages.wss4j_errors");
            private final ResourceBundle xmlSecResourceBundle = ResourceBundle.getBundle("org/apache/xml/security/resource/xmlsecurity");

            @Override
            protected Object handleGetObject(String key) {
                Object value = null;
                try {
                    value = this.wss4jSecResourceBundle.getObject(key);
                }
                catch (MissingResourceException e) {
                    try {
                        value = this.xmlSecResourceBundle.getObject(key);
                    }
                    catch (MissingResourceException ex) {
                        // empty catch block
                    }
                }
                return value;
            }

            @Override
            public Enumeration<String> getKeys() {
                throw new UnsupportedOperationException("getKeys not supported");
            }
        };
        I18n.init((ResourceBundle)resourceBundle);
    }

    public static String addJceProvider(String name, String className) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                Class<Provider> clazz = Loader.loadClass(className, false, Provider.class);
                Provider provider = clazz.newInstance();
                return WSProviderConfig.addJceProvider(name, provider);
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + name + " could not be added: " + t.getMessage(), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    public static String addJceProvider(String name, Provider provider) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                int ret = 0;
                Provider[] provs = Security.getProviders();
                for (int i = 0; i < provs.length; ++i) {
                    if (!"SUN".equals(provs[i].getName()) && !"IBMJCE".equals(provs[i].getName())) continue;
                    ret = Security.insertProviderAt(provider, i + 2);
                    break;
                }
                if (ret == 0) {
                    ret = Security.insertProviderAt(provider, 2);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + provider.getName() + " - " + provider.getVersion() + " was added at position: " + ret);
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + name + " could not be added: " + t.getMessage(), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    public static String appendJceProvider(String name, String className) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                Class<Provider> clazz = Loader.loadClass(className, false, Provider.class);
                Provider provider = clazz.newInstance();
                int ret = Security.addProvider(provider);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + provider.getName() + " was added at position: " + ret);
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + name + " could not be added: " + t.getMessage(), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    public static String appendJceProvider(String name, Provider provider) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                int ret = Security.addProvider(provider);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + provider.getName() + " was added at position: " + ret);
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The provider " + name + " could not be added: " + t.getMessage(), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }
}

