/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.ext;

import javax.xml.namespace.QName;
import org.apache.xml.security.exceptions.XMLSecurityException;

public class WSSecurityException
extends XMLSecurityException {
    private static final long serialVersionUID = 4703352039717763655L;
    public static final String NS_WSSE10 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final QName UNSUPPORTED_SECURITY_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UnsupportedSecurityToken");
    public static final QName UNSUPPORTED_ALGORITHM = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UnsupportedAlgorithm");
    public static final QName INVALID_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity");
    public static final QName INVALID_SECURITY_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurityToken");
    public static final QName FAILED_AUTHENTICATION = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication");
    public static final QName FAILED_CHECK = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedCheck");
    public static final QName SECURITY_TOKEN_UNAVAILABLE = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenUnavailable");
    public static final QName MESSAGE_EXPIRED = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "MessageExpired");
    private ErrorCode errorCode;

    public WSSecurityException(ErrorCode errorCode, String msgId, Exception exception, Object ... arguments) {
        super(msgId, arguments, exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode, String msgId, Exception exception) {
        super(msgId, exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode, Exception exception) {
        super(exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode, String msgId, Object ... arguments) {
        super(msgId, arguments);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode) {
        this(errorCode, errorCode.name(), new Object[0]);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public QName getFaultCode() {
        return this.errorCode.getQName();
    }

    public static enum ErrorCode {
        FAILURE(null),
        UNSUPPORTED_SECURITY_TOKEN(UNSUPPORTED_SECURITY_TOKEN),
        UNSUPPORTED_ALGORITHM(UNSUPPORTED_ALGORITHM),
        INVALID_SECURITY(INVALID_SECURITY),
        INVALID_SECURITY_TOKEN(INVALID_SECURITY_TOKEN),
        FAILED_AUTHENTICATION(FAILED_AUTHENTICATION),
        FAILED_CHECK(FAILED_CHECK),
        SECURITY_TOKEN_UNAVAILABLE(SECURITY_TOKEN_UNAVAILABLE),
        MESSAGE_EXPIRED(MESSAGE_EXPIRED),
        FAILED_ENCRYPTION(null),
        FAILED_SIGNATURE(null);

        private QName qName;

        private ErrorCode(QName qName) {
            this.qName = qName;
        }

        public QName getQName() {
            return this.qName;
        }
    }
}

