/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.kerberos;

import java.security.Principal;
import java.security.PrivilegedAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClientAction
implements PrivilegedAction<byte[]> {
    private static Logger log = LoggerFactory.getLogger(KerberosClientAction.class);
    private Principal clientPrincipal;
    private String serviceName;

    public KerberosClientAction(Principal clientPrincipal, String serviceName) {
        this.clientPrincipal = clientPrincipal;
        this.serviceName = serviceName;
    }

    @Override
    public byte[] run() {
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid kerberos5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSName gssClient = gssManager.createName(this.clientPrincipal.getName(), GSSName.NT_USER_NAME);
            GSSCredential credentials = gssManager.createCredential(gssClient, 0, kerberos5Oid, 1);
            GSSName gssService = gssManager.createName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext secContext = gssManager.createContext(gssService, kerberos5Oid, credentials, 0);
            secContext.requestMutualAuth(false);
            byte[] token = new byte[]{};
            byte[] returnedToken = secContext.initSecContext(token, 0, token.length);
            secContext.dispose();
            return returnedToken;
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error in obtaining a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }
}

