/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static Logger LOG = LoggerFactory.getLogger(DateUtil.class);

    public static boolean verifyCreated(Date createdDate, int timeToLive, int futureTimeToLive) {
        if (createdDate == null) {
            return true;
        }
        Date validCreation = new Date();
        long currentTime = validCreation.getTime();
        if (futureTimeToLive > 0) {
            validCreation.setTime(currentTime + (long)futureTimeToLive * 1000L);
        }
        if (createdDate.after(validCreation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validation of Created: The message was created in the future!");
            }
            return false;
        }
        validCreation.setTime(currentTime -= (long)timeToLive * 1000L);
        if (createdDate.before(validCreation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validation of Created: The message was created too long ago");
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation of Created: Everything is ok");
        }
        return true;
    }
}

