/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyUtils {
    private static Logger LOG = LoggerFactory.getLogger(KeyUtils.class);

    public static int getKeyLength(String algorithm) throws WSSecurityException {
        return JCEMapper.getKeyLengthFromURI((String)algorithm) / 8;
    }

    public static SecretKey prepareSecretKey(String symEncAlgo, byte[] rawKey) {
        int size;
        block2: {
            size = 0;
            try {
                size = KeyUtils.getKeyLength(symEncAlgo);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug(e.getMessage());
            }
        }
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)symEncAlgo);
        SecretKeySpec keySpec = size > 0 && !symEncAlgo.endsWith("gcm") ? new SecretKeySpec(rawKey, 0, rawKey.length > size ? size : rawKey.length, keyAlgorithm) : new SecretKeySpec(rawKey, keyAlgorithm);
        return keySpec;
    }
}

