/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.kerberos;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.kerberos.KerberosServiceContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosServiceExceptionAction
implements PrivilegedExceptionAction<KerberosServiceContext> {
    private static final String javaVersion = System.getProperty("java.version");
    private static final boolean isJava5Or6 = javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6");
    private static final boolean isOracleJavaVendor = System.getProperty("java.vendor").startsWith("Oracle");
    private static final boolean isIBMJavaVendor = System.getProperty("java.vendor").startsWith("IBM");
    private static final String SUN_JGSS_INQUIRE_TYPE_CLASS = "com.sun.security.jgss.InquireType";
    private static final String SUN_JGSS_EXT_GSSCTX_CLASS = "com.sun.security.jgss.ExtendedGSSContext";
    private static final String IBM_JGSS_INQUIRE_TYPE_CLASS = "com.ibm.security.jgss.InquireType";
    private static final String IBM_JGSS_EXT_GSSCTX_CLASS = "com.ibm.security.jgss.ExtendedGSSContext";
    private static final String EXTENDED_JGSS_CONTEXT_INQUIRE_SEC_CONTEXT_METHOD_NAME = "inquireSecContext";
    private static final String EXTENDED_JGSS_CONTEXT_INQUIRE_TYPE_KRB5_GET_SESSION_KEY = "KRB5_GET_SESSION_KEY";
    private static final String JGSS_KERBEROS_TICKET_OID = "1.2.840.113554.1.2.2";
    private static final String KERBEROS_TICKET_VALIDATION_ERROR_MSG_ID = "kerberosTicketValidationError";
    private byte[] ticket;
    private String serviceName;
    private boolean isUsernameServiceNameForm;

    public KerberosServiceExceptionAction(byte[] ticket, String serviceName, boolean isUsernameServiceNameForm) {
        this.ticket = ticket;
        this.serviceName = serviceName;
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KerberosServiceContext run() throws GSSException, WSSecurityException {
        KerberosServiceContext krbServiceCtx;
        block9: {
            GSSManager gssManager = GSSManager.getInstance();
            Oid kerberos5Oid = new Oid(JGSS_KERBEROS_TICKET_OID);
            GSSName gssService = gssManager.createName(this.serviceName, this.isUsernameServiceNameForm ? GSSName.NT_USER_NAME : GSSName.NT_HOSTBASED_SERVICE);
            GSSCredential credentials = gssManager.createCredential(gssService, 0, kerberos5Oid, 2);
            krbServiceCtx = null;
            GSSContext secContext = null;
            try {
                secContext = gssManager.createContext(credentials);
                secContext.acceptSecContext(this.ticket, 0, this.ticket.length);
                krbServiceCtx = new KerberosServiceContext();
                GSSName clientName = secContext.getSrcName();
                krbServiceCtx.setPrincipal(new KerberosPrincipal(((Object)clientName).toString()));
                if (isJava5Or6 || !isOracleJavaVendor && !isIBMJavaVendor) break block9;
                try {
                    Class<?> inquireType = Class.forName(isOracleJavaVendor ? SUN_JGSS_INQUIRE_TYPE_CLASS : IBM_JGSS_INQUIRE_TYPE_CLASS);
                    Class<?> extendedGSSContext = Class.forName(isOracleJavaVendor ? SUN_JGSS_EXT_GSSCTX_CLASS : IBM_JGSS_EXT_GSSCTX_CLASS);
                    Method inquireSecContext = extendedGSSContext.getMethod(EXTENDED_JGSS_CONTEXT_INQUIRE_SEC_CONTEXT_METHOD_NAME, inquireType);
                    Key key = (Key)inquireSecContext.invoke((Object)secContext, Enum.valueOf(inquireType, EXTENDED_JGSS_CONTEXT_INQUIRE_TYPE_KRB5_GET_SESSION_KEY));
                    krbServiceCtx.setSessionKey(key);
                }
                catch (ClassNotFoundException e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, KERBEROS_TICKET_VALIDATION_ERROR_MSG_ID, new Object[0], e);
                }
                catch (NoSuchMethodException e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, KERBEROS_TICKET_VALIDATION_ERROR_MSG_ID, new Object[0], e);
                }
                catch (InvocationTargetException e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, KERBEROS_TICKET_VALIDATION_ERROR_MSG_ID, new Object[0], e.getCause());
                }
                catch (IllegalAccessException e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, KERBEROS_TICKET_VALIDATION_ERROR_MSG_ID, new Object[0], e);
                }
            }
            finally {
                if (null != secContext) {
                    secContext.dispose();
                }
            }
        }
        return krbServiceCtx;
    }
}

