/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.DERDecoder;
import org.apache.wss4j.common.crypto.X509SubjectPublicKeyInfo;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CryptoBase
implements Crypto {
    public static final String SKI_OID = "2.5.29.14";
    public static final String NAME_CONSTRAINTS_OID = "2.5.29.30";
    private static final Logger LOG = LoggerFactory.getLogger(CryptoBase.class);
    private static final Constructor<?> BC_509CLASS_CONS;
    protected Map<String, CertificateFactory> certFactMap = new HashMap<String, CertificateFactory>();
    protected String defaultAlias = null;
    protected String cryptoProvider = null;

    protected CryptoBase() {
    }

    @Override
    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    @Override
    public void setCryptoProvider(String provider) {
        this.cryptoProvider = provider;
    }

    @Override
    public String getDefaultX509Identifier() throws WSSecurityException {
        return this.defaultAlias;
    }

    @Override
    public void setDefaultX509Identifier(String identifier) {
        this.defaultAlias = identifier;
    }

    @Override
    public void setCertificateFactory(String provider, CertificateFactory certFactory) {
        if (provider == null || provider.length() == 0) {
            this.certFactMap.put(certFactory.getProvider().getName(), certFactory);
        } else {
            this.certFactMap.put(provider, certFactory);
        }
    }

    @Override
    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        String provider = this.getCryptoProvider();
        CertificateFactory factory = null;
        factory = provider != null && provider.length() != 0 ? this.certFactMap.get(provider) : this.certFactMap.get("DEFAULT");
        if (factory == null) {
            try {
                if (provider == null || provider.length() == 0) {
                    factory = CertificateFactory.getInstance("X.509");
                    this.certFactMap.put("DEFAULT", factory);
                } else {
                    factory = CertificateFactory.getInstance("X.509", provider);
                    this.certFactMap.put(provider, factory);
                }
                this.certFactMap.put(factory.getProvider().getName(), factory);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "noSecProvider");
            }
        }
        return factory;
    }

    @Override
    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        try {
            CertificateFactory certFactory = this.getCertificateFactory();
            return (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "parseError");
        }
    }

    @Override
    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            X509SubjectPublicKeyInfo spki = new X509SubjectPublicKeyInfo(cert.getPublicKey());
            byte[] value = spki.getSubjectPublicKey();
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                return digest.digest(value);
            }
            catch (Exception ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_SECURITY_TOKEN, ex, "noSKIHandling", new Object[]{"No SKI certificate extension and no SHA1 message digest available"});
            }
        }
        DERDecoder extVal = new DERDecoder(derEncodedValue);
        extVal.expect((byte)4);
        extVal.getLength();
        extVal.expect((byte)4);
        int keyIDLen = extVal.getLength();
        return extVal.getBytes(keyIDLen);
    }

    @Override
    public byte[] getBytesFromCertificates(X509Certificate[] certs) throws WSSecurityException {
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(Arrays.asList(certs));
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "encodeError");
        }
        catch (CertificateException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "parseError");
        }
    }

    @Override
    public X509Certificate[] getCertificatesFromBytes(byte[] data) throws WSSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertPath path = null;
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "parseError");
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        int i = 0;
        Iterator<? extends Certificate> iterator = l.iterator();
        while (iterator.hasNext()) {
            certs[i++] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    @Override
    public void verifyDirectTrust(X509Certificate[] certs) throws WSSecurityException {
        this.verifyTrust(certs, true, null);
    }

    protected Object createBCX509Name(String s) {
        if (BC_509CLASS_CONS != null) {
            try {
                return BC_509CLASS_CONS.newInstance(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new X500Principal(s);
    }

    protected boolean matches(X509Certificate cert, Collection<Pattern> subjectDNPatterns) {
        if (subjectDNPatterns == null || subjectDNPatterns.isEmpty()) {
            LOG.warn("No Subject DN Certificate Constraints were defined. This could be a security issue");
            return true;
        }
        if (!subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                LOG.debug("The certificate is null so no constraints matching was possible");
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                LOG.debug("Subject DN " + subjectName + " matches with pattern " + subjectDNPattern);
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }

    static {
        Constructor<?> cons = null;
        try {
            Class<?> c = Class.forName("org.bouncycastle.asn1.x500.X500Name");
            cons = c.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BC_509CLASS_CONS = cons;
    }
}

