/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecSignatureConfirmation;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureConfirmationAction
implements Action {
    private static final Logger log = LoggerFactory.getLogger(SignatureConfirmationAction.class);

    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, Document doc, RequestData reqData) throws WSSecurityException {
        List results;
        if (log.isDebugEnabled()) {
            log.debug("Perform Signature confirmation");
        }
        if ((results = (List)handler.getProperty(reqData.getMsgContext(), "RECV_RESULTS")) == null) {
            return;
        }
        ArrayList<Integer> actions = new ArrayList<Integer>(3);
        actions.add(2);
        actions.add(16);
        actions.add(64);
        ArrayList<WSSecurityEngineResult> signatureActions = new ArrayList<WSSecurityEngineResult>();
        for (WSHandlerResult wshResult : results) {
            List<WSSecurityEngineResult> resultList = wshResult.getResults();
            signatureActions.addAll(WSSecurityUtil.fetchAllActionResults(resultList, actions));
        }
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation(reqData.getWssConfig());
        SignatureActionToken signatureToken = (SignatureActionToken)actionToken;
        if (signatureToken == null) {
            signatureToken = reqData.getSignatureToken();
        }
        List signatureParts = signatureToken.getParts();
        if (signatureActions.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Signature Confirmation: number of Signature results: " + signatureActions.size());
            }
            for (int i = 0; i < signatureActions.size(); ++i) {
                WSSecurityEngineResult wsr = (WSSecurityEngineResult)signatureActions.get(i);
                byte[] sigVal = (byte[])wsr.get("signature-value");
                wsc.build(doc, sigVal, reqData.getSecHeader());
                signatureParts.add(new WSEncryptionPart(wsc.getId()));
            }
        } else {
            wsc.build(doc, null, reqData.getSecHeader());
            signatureParts.add(new WSEncryptionPart(wsc.getId()));
        }
        handler.setProperty(reqData.getMsgContext(), "_sigConfDone_", "");
    }
}

