/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.CallbackLookup;
import org.apache.wss4j.dom.message.DOMCallbackLookup;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.message.token.Reference;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSSecEncrypt
extends WSSecEncryptedKey {
    private static Logger log = LoggerFactory.getLogger(WSSecEncrypt.class);
    private SecurityTokenReference securityTokenReference;
    private boolean encryptSymmKey = true;
    private String customReferenceValue;
    private boolean encKeyIdDirectId;
    private boolean embedEncryptedKey;

    public WSSecEncrypt() {
    }

    public WSSecEncrypt(WSSConfig config) {
        super(config);
    }

    public void setKeyEnc(String keyEnc) {
        this.keyEncAlgo = keyEnc;
    }

    @Override
    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        this.document = doc;
        if (this.ephemeralKey == null) {
            if (this.symmetricKey == null) {
                KeyGenerator keyGen = this.getKeyGenerator();
                this.symmetricKey = keyGen.generateKey();
            }
            this.ephemeralKey = this.symmetricKey.getEncoded();
        }
        this.symmetricKey = KeyUtils.prepareSecretKey((String)this.symEncAlgo, (byte[])this.ephemeralKey);
        if (this.encryptSymmKey) {
            X509Certificate remoteCert = this.useThisCert;
            if (remoteCert == null) {
                CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                cryptoType.setAlias(this.user);
                X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
                if (certs == null || certs.length <= 0) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noUserCertsFound", new Object[]{this.user, "encryption"});
                }
                remoteCert = certs[0];
            }
            this.prepareInternal(this.symmetricKey, remoteCert, crypto);
        } else {
            this.encryptedEphemeralKey = this.ephemeralKey;
        }
    }

    public Document build(Document doc, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        this.prepare(doc, crypto);
        if (this.envelope == null) {
            this.envelope = this.document.getDocumentElement();
        }
        if (this.parts == null) {
            this.parts = new ArrayList(1);
            String soapNamespace = WSSecurityUtil.getSOAPNamespace(this.envelope);
            WSEncryptionPart encP = new WSEncryptionPart("Body", soapNamespace, "Content");
            this.parts.add(encP);
        }
        if (this.doDebug) {
            log.debug("Beginning Encryption...");
        }
        Element refs = this.encryptForRef(null, this.parts);
        if (this.encryptedKeyElement != null) {
            this.addInternalRefElement(refs);
            this.prependToHeader(secHeader);
        } else {
            this.addExternalRefElement(refs, secHeader);
        }
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        log.debug("Encryption complete.");
        return doc;
    }

    public Element encryptForRef(Element dataRef, List<WSEncryptionPart> references) throws WSSecurityException {
        KeyInfo keyInfo = this.createKeyInfo();
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.symmetricKey.getEncoded(), this.symmetricKey.getAlgorithm());
        List<String> encDataRefs = WSSecEncrypt.doEncryption(this.document, this.getWsConfig(), keyInfo, secretKeySpec, this.symEncAlgo, references, this.callbackLookup);
        if (dataRef == null) {
            dataRef = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
            if (!this.encryptSymmKey) {
                WSSecurityUtil.setNamespace(dataRef, "http://www.w3.org/2001/04/xmlenc#", "xenc");
            }
        }
        return WSSecEncrypt.createDataRefList(this.document, dataRef, encDataRefs);
    }

    public void addInternalRefElement(Element dataRef) {
        this.encryptedKeyElement.appendChild(dataRef);
    }

    public void addExternalRefElement(Element dataRef, WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), dataRef);
    }

    public static List<String> doEncryption(Document doc, WSSConfig config, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, List<WSEncryptionPart> references, CallbackLookup callbackLookup) throws WSSecurityException {
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)encryptionAlgorithm);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
        ArrayList<String> encDataRef = new ArrayList<String>();
        for (int part = 0; part < references.size(); ++part) {
            List<Element> elementsToEncrypt;
            WSEncryptionPart encPart = references.get(part);
            if (callbackLookup == null) {
                callbackLookup = new DOMCallbackLookup(doc);
            }
            if ((elementsToEncrypt = WSSecurityUtil.findElements(encPart, callbackLookup, doc)) == null || elementsToEncrypt.size() == 0) {
                if (!encPart.isRequired()) continue;
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noEncElement", new Object[]{"{" + encPart.getNamespace() + "}" + encPart.getName()});
            }
            String modifier = encPart.getEncModifier();
            for (Element elementToEncrypt : elementsToEncrypt) {
                String id = WSSecEncrypt.encryptElement(doc, elementToEncrypt, modifier, config, xmlCipher, secretKey, keyInfo);
                encPart.setEncId(id);
                encDataRef.add("#" + id);
            }
            if (part == references.size() - 1) continue;
            try {
                keyInfo = new KeyInfo((Element)keyInfo.getElement().cloneNode(true), null);
                continue;
            }
            catch (Exception ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, ex);
            }
        }
        return encDataRef;
    }

    private static String encryptElement(Document doc, Element elementToEncrypt, String modifier, WSSConfig config, XMLCipher xmlCipher, SecretKey secretKey, KeyInfo keyInfo) throws WSSecurityException {
        boolean content = "Content".equals(modifier);
        String xencEncryptedDataId = config.getIdAllocator().createId("ED-", elementToEncrypt);
        try {
            String headerId = "";
            if ("Header".equals(modifier)) {
                Element elem = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:EncryptedHeader");
                WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
                String wsuPrefix = WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                headerId = config.getIdAllocator().createId("EH-", elementToEncrypt);
                elem.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", headerId);
                Node parent = elementToEncrypt.getParentNode();
                elementToEncrypt = (Element)parent.replaceChild(elem, elementToEncrypt);
                elem.appendChild(elementToEncrypt);
                NamedNodeMap map = elementToEncrypt.getAttributes();
                for (int i = 0; i < map.getLength(); ++i) {
                    Attr attr = (Attr)map.item(i);
                    if (!attr.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !attr.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) continue;
                    String soapEnvPrefix = WSSecurityUtil.setNamespace(elem, attr.getNamespaceURI(), "soapenv");
                    elem.setAttributeNS(attr.getNamespaceURI(), soapEnvPrefix + ":" + attr.getLocalName(), attr.getValue());
                }
            }
            xmlCipher.init(1, (Key)secretKey);
            EncryptedData encData = xmlCipher.getEncryptedData();
            encData.setId(xencEncryptedDataId);
            encData.setKeyInfo(keyInfo);
            xmlCipher.doFinal(doc, elementToEncrypt, content);
            return xencEncryptedDataId;
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, ex);
        }
    }

    private KeyInfo createKeyInfo() throws WSSecurityException {
        SecurityTokenReference secToken;
        KeyInfo keyInfo = new KeyInfo(this.document);
        if (this.embedEncryptedKey) {
            keyInfo.addUnknownElement(this.getEncryptedKeyElement());
        } else if (this.keyIdentifierType == 10) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            if (this.customReferenceValue != null) {
                secToken.setKeyIdentifierEncKeySHA1(this.customReferenceValue);
            } else {
                byte[] encodedBytes = WSSecurityUtil.generateDigest(this.encryptedEphemeralKey);
                secToken.setKeyIdentifierEncKeySHA1(Base64.encode((byte[])encodedBytes));
            }
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            secToken.setKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", this.encKeyId);
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            secToken.setKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", this.encKeyId);
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
            secToken.setKeyIdentifier(this.customReferenceValue, this.encKeyId, true);
            keyInfo.addUnknownElement(secToken.getElement());
        } else if (this.securityTokenReference != null) {
            Element tmpE = this.securityTokenReference.getElement();
            tmpE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tmpE.getPrefix(), tmpE.getNamespaceURI());
            keyInfo.addUnknownElement(this.securityTokenReference.getElement());
        } else if (this.encKeyId != null) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            Reference ref = new Reference(this.document);
            if (this.encKeyIdDirectId) {
                ref.setURI(this.encKeyId);
            } else {
                ref.setURI("#" + this.encKeyId);
            }
            if (this.customReferenceValue != null) {
                ref.setValueType(this.customReferenceValue);
            }
            secToken.setReference(ref);
            if (KerberosSecurity.isKerberosToken(this.customReferenceValue)) {
                secToken.addTokenType(this.customReferenceValue);
            } else if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(this.customReferenceValue)) {
                secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            }
            keyInfo.addUnknownElement(secToken.getElement());
        }
        Element keyInfoElement = keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        return keyInfo;
    }

    public static Element createDataRefList(Document doc, Element referenceList, List<String> encDataRefs) {
        for (String dataReferenceUri : encDataRefs) {
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        return referenceList;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReference = reference;
    }

    public boolean isEncryptSymmKey() {
        return this.encryptSymmKey;
    }

    public void setEncryptSymmKey(boolean encryptSymmKey) {
        this.encryptSymmKey = encryptSymmKey;
    }

    public void setCustomReferenceValue(String customReferenceValue) {
        this.customReferenceValue = customReferenceValue;
    }

    public void setEncKeyIdDirectId(boolean b) {
        this.encKeyIdDirectId = b;
    }

    public void setEmbedEncryptedKey(boolean embedEncryptedKey) {
        this.embedEncryptedKey = embedEncryptedKey;
    }

    public boolean isEmbedEncryptedKey() {
        return this.embedEncryptedKey;
    }
}

