/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.WSSecBase;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecTimestamp
extends WSSecBase {
    private static Logger log = LoggerFactory.getLogger(WSSecTimestamp.class);
    private Timestamp ts;
    private int timeToLive = 300;

    public WSSecTimestamp() {
    }

    public WSSecTimestamp(WSSConfig config) {
        super(config);
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    public void prepare(Document doc) {
        this.ts = new Timestamp(this.getWsConfig().isPrecisionInMilliSeconds(), doc, this.getWsConfig().getCurrentTime(), this.timeToLive);
        String tsId = this.getWsConfig().getIdAllocator().createId("TS-", this.ts);
        this.ts.setID(tsId);
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.ts.getElement());
    }

    public Document build(Document doc, WSSecHeader secHeader) {
        log.debug("Begin add timestamp...");
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }

    public String getId() {
        if (this.ts == null) {
            return null;
        }
        return this.ts.getID();
    }

    public Element getElement() {
        if (this.ts == null) {
            return null;
        }
        return this.ts.getElement();
    }
}

