/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.kerberos.KerberosClientAction;
import org.apache.wss4j.common.kerberos.KerberosContextAndServiceNameCallback;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KerberosSecurity
extends BinarySecurity {
    private static Logger log = LoggerFactory.getLogger(KerberosSecurity.class);
    private SecretKey secretKey;

    public KerberosSecurity(Element elem, BSPEnforcer bspEnforcer) throws WSSecurityException {
        super(elem, bspEnforcer);
        String valueType = this.getValueType();
        if (!"http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType)) {
            bspEnforcer.handleBSPRule(BSPRule.R6902);
        }
    }

    public KerberosSecurity(Document doc) {
        super(doc);
    }

    public boolean isV5ApReq() {
        String type = this.getValueType();
        return "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ1510".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ4120".equals(type);
    }

    public boolean isGssV5ApReq() {
        String type = this.getValueType();
        return "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ4120".equals(type);
    }

    public void retrieveServiceTicket(CallbackHandler callbackHandler) throws WSSecurityException {
        KerberosContextAndServiceNameCallback contextAndServiceNameCallback = new KerberosContextAndServiceNameCallback();
        try {
            callbackHandler.handle(new Callback[]{contextAndServiceNameCallback});
        }
        catch (IOException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e);
        }
        String jaasLoginModuleName = contextAndServiceNameCallback.getContextName();
        if (jaasLoginModuleName == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosCallbackContextNameNotSupplied", new Object[0]);
        }
        String serviceName = contextAndServiceNameCallback.getServiceName();
        if (serviceName == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosCallbackServiceNameNotSupplied", new Object[0]);
        }
        this.retrieveServiceTicket(jaasLoginModuleName, callbackHandler, serviceName);
    }

    public void retrieveServiceTicket(String jaasLoginModuleName, CallbackHandler callbackHandler, String serviceName) throws WSSecurityException {
        KerberosTicket serviceTicket;
        Subject clientSubject;
        Set<Principal> clientPrincipals;
        LoginContext loginContext = null;
        try {
            loginContext = callbackHandler == null ? new LoginContext(jaasLoginModuleName) : new LoginContext(jaasLoginModuleName, callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (log.isDebugEnabled()) {
                log.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", (Exception)ex, new Object[]{ex.getMessage()});
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully authenticated to the TGT");
        }
        if ((clientPrincipals = (clientSubject = loginContext.getSubject()).getPrincipals()).isEmpty()) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", new Object[]{"No Client principals found after login"});
        }
        KerberosTicket tgt = this.getKerberosTicket(clientSubject, null);
        KerberosClientAction action = new KerberosClientAction(clientPrincipals.iterator().next(), serviceName);
        byte[] ticket = (byte[])Subject.doAs(clientSubject, action);
        if (ticket == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosServiceTicketError", new Object[0]);
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully retrieved a service ticket");
        }
        if ((serviceTicket = this.getKerberosTicket(clientSubject, tgt)) != null) {
            this.secretKey = serviceTicket.getSessionKey();
        }
        this.setToken(ticket);
        if ("".equals(this.getValueType())) {
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
        }
    }

    private KerberosTicket getKerberosTicket(Subject clientSubject, KerberosTicket previousTicket) {
        Set<KerberosTicket> privateCredentials = clientSubject.getPrivateCredentials(KerberosTicket.class);
        if (privateCredentials == null || privateCredentials.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Kerberos client subject private credentials are null");
            }
            return null;
        }
        for (KerberosTicket privateCredential : privateCredentials) {
            if (privateCredential.equals(previousTicket)) continue;
            return privateCredential;
        }
        return null;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public static boolean isKerberosToken(String valueType) {
        return "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ1510".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ4120".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ4120".equals(valueType);
    }
}

