/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.io.IOException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.common.util.WSCurrentTimeSource;
import org.apache.wss4j.common.util.WSTimeSource;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.XmlSchemaDateFormat;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UsernameToken {
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    public static final String PASSWORD_TYPE = "passwordType";
    public static final int DEFAULT_ITERATION = 1000;
    public static final QName TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    private static final Logger LOG = LoggerFactory.getLogger(UsernameToken.class);
    private static final boolean DO_DEBUG = LOG.isDebugEnabled();
    private Element element;
    private Element elementUsername;
    private Element elementPassword;
    private Element elementNonce;
    private Element elementCreated;
    private Element elementSalt;
    private Element elementIteration;
    private String passwordType;
    private boolean hashed = true;
    private String rawPassword;
    private boolean passwordsAreEncoded;
    private Date createdDate;

    public UsernameToken(Element elem, boolean allowNamespaceQualifiedPasswordTypes, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String createdString;
        int iterInt;
        String iter;
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badElement", new Object[]{TOKEN, el});
        }
        this.elementUsername = WSSecurityUtil.getDirectChildElement(this.element, "Username", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementPassword = WSSecurityUtil.getDirectChildElement(this.element, "Password", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementNonce = WSSecurityUtil.getDirectChildElement(this.element, "Nonce", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementCreated = WSSecurityUtil.getDirectChildElement(this.element, "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.elementSalt = WSSecurityUtil.getDirectChildElement(this.element, "Salt", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        this.elementIteration = WSSecurityUtil.getDirectChildElement(this.element, "Iteration", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        if (this.elementUsername == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badUsernameToken", new Object[]{"Username is missing"});
        }
        this.checkBSPCompliance(bspEnforcer);
        this.hashed = false;
        if (this.elementSalt != null) {
            if (this.elementPassword != null || this.elementIteration == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badUsernameToken", new Object[]{"Password is missing"});
            }
            return;
        }
        if (this.elementIteration != null && (iter = this.nodeString(this.elementIteration)) != null && ((iterInt = Integer.parseInt(iter)) < 0 || iterInt > 10000)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badUsernameToken", new Object[]{"Iteration is missing"});
        }
        if (this.elementPassword != null) {
            if (this.elementPassword.hasAttribute("Type")) {
                this.passwordType = this.elementPassword.getAttributeNS(null, "Type");
            } else if (this.elementPassword.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type")) {
                if (allowNamespaceQualifiedPasswordTypes) {
                    this.passwordType = this.elementPassword.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type");
                } else {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badUsernameToken", new Object[]{"The Password Type is not allowed to be namespace qualified"});
                }
            }
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType)) {
            this.hashed = true;
            if (this.elementNonce == null || this.elementCreated == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badUsernameToken", new Object[]{"Nonce or Created is missing"});
            }
        }
        if (this.elementCreated != null && (createdString = this.getCreated()) != null && !"".equals(createdString)) {
            XMLGregorianCalendar createdCalendar = null;
            try {
                createdCalendar = WSSConfig.datatypeFactory.newXMLGregorianCalendar(createdString);
            }
            catch (IllegalArgumentException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "badUsernameToken", new Object[]{"Error parsing UsernameToken Created value"});
            }
            this.createdDate = createdCalendar.toGregorianCalendar().getTime();
        }
    }

    public UsernameToken(boolean milliseconds, Document doc) {
        this(milliseconds, doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    public UsernameToken(boolean milliseconds, Document doc, String pwType) {
        this(milliseconds, doc, (WSTimeSource)new WSCurrentTimeSource(), pwType);
    }

    public UsernameToken(boolean milliseconds, Document doc, WSTimeSource timeSource, String pwType) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken");
        this.elementUsername = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Username");
        this.elementUsername.appendChild(doc.createTextNode(""));
        this.element.appendChild(this.elementUsername);
        if (pwType != null) {
            this.elementPassword = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Password");
            this.elementPassword.appendChild(doc.createTextNode(""));
            this.element.appendChild(this.elementPassword);
            this.passwordType = pwType;
            if (this.passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                this.addNonce(doc);
                this.addCreated(milliseconds, timeSource, doc);
            } else {
                this.hashed = false;
            }
        }
    }

    public void addWSSENamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public void addNonce(Document doc) {
        if (this.elementNonce != null) {
            return;
        }
        byte[] nonceValue = null;
        try {
            nonceValue = WSSecurityUtil.generateNonce(16);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            return;
        }
        this.elementNonce = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Nonce");
        this.elementNonce.appendChild(doc.createTextNode(Base64.encode((byte[])nonceValue)));
        this.elementNonce.setAttributeNS(null, "EncodingType", BASE64_ENCODING);
        this.element.appendChild(this.elementNonce);
    }

    public void addCreated(boolean milliseconds, Document doc) {
        this.addCreated(milliseconds, (WSTimeSource)new WSCurrentTimeSource(), doc);
    }

    public void addCreated(boolean milliseconds, WSTimeSource timeSource, Document doc) {
        if (this.elementCreated != null) {
            return;
        }
        DateFormat zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        this.elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date currentTime = timeSource.now();
        this.elementCreated.appendChild(doc.createTextNode(zulu.format(currentTime)));
        this.element.appendChild(this.elementCreated);
    }

    public byte[] addSalt(Document doc, byte[] saltValue, boolean mac) {
        if (saltValue == null) {
            saltValue = UsernameTokenUtil.generateSalt((boolean)mac);
        }
        this.elementSalt = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:Salt");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.elementSalt.appendChild(doc.createTextNode(Base64.encode((byte[])saltValue)));
        this.element.appendChild(this.elementSalt);
        return saltValue;
    }

    public void addIteration(Document doc, int iteration) {
        String text = "" + iteration;
        this.elementIteration = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:Iteration");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.elementIteration.appendChild(doc.createTextNode(text));
        this.element.appendChild(this.elementIteration);
    }

    public String getName() {
        return this.nodeString(this.elementUsername);
    }

    public void setName(String name) {
        Text node = this.getFirstNode(this.elementUsername);
        node.setData(name);
    }

    public String getNonce() {
        return this.nodeString(this.elementNonce);
    }

    public String getCreated() {
        return this.nodeString(this.elementCreated);
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getPassword() {
        String password = this.nodeString(this.elementPassword);
        if (password == null && this.elementPassword != null) {
            return "";
        }
        return password;
    }

    public boolean containsPasswordElement() {
        return this.elementPassword != null;
    }

    public byte[] getSalt() throws WSSecurityException {
        String salt = this.nodeString(this.elementSalt);
        if (salt != null) {
            try {
                return Base64.decode((String)salt);
            }
            catch (Base64DecodingException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "decoding.general", (Exception)((Object)e));
            }
        }
        return null;
    }

    public int getIteration() {
        String iter = this.nodeString(this.elementIteration);
        if (iter != null) {
            return Integer.parseInt(iter);
        }
        return 1000;
    }

    public boolean isHashed() {
        return this.hashed;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPassword(String pwd) {
        block9: {
            if (pwd == null) {
                if (this.passwordType != null) {
                    throw new IllegalArgumentException("pwd == null but a password is needed");
                }
                return;
            }
            this.rawPassword = pwd;
            Text node = this.getFirstNode(this.elementPassword);
            try {
                if (this.hashed) {
                    if (this.passwordsAreEncoded) {
                        node.setData(UsernameToken.doPasswordDigest(this.getNonce(), this.getCreated(), Base64.decode((String)pwd)));
                    } else {
                        node.setData(UsernameToken.doPasswordDigest(this.getNonce(), this.getCreated(), pwd));
                    }
                } else {
                    node.setData(pwd);
                }
                if (this.passwordType != null) {
                    this.elementPassword.setAttributeNS(null, "Type", this.passwordType);
                }
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block9;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setRawPassword(RequestData data) throws WSSecurityException {
        WSPasswordCallback pwCb = new WSPasswordCallback(this.getName(), this.getPassword(), this.getPasswordType(), WSPasswordCallback.Usage.USERNAME_TOKEN);
        if (data.getCallbackHandler() == null) {
            LOG.debug("CallbackHandler is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, (Exception)e);
        }
        catch (UnsupportedCallbackException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, (Exception)e);
        }
        this.rawPassword = pwCb.getPassword();
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public static String doPasswordDigest(String nonce, String created, byte[] password) {
        String passwdDigest;
        block2: {
            passwdDigest = null;
            try {
                byte[] b1 = nonce != null ? Base64.decode((String)nonce) : new byte[]{};
                byte[] b2 = created != null ? created.getBytes("UTF-8") : new byte[]{};
                byte[] b3 = password;
                byte[] b4 = new byte[b1.length + b2.length + b3.length];
                int offset = 0;
                System.arraycopy(b1, 0, b4, offset, b1.length);
                System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
                System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
                byte[] digestBytes = WSSecurityUtil.generateDigest(b4);
                passwdDigest = Base64.encode((byte[])digestBytes);
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block2;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return passwdDigest;
    }

    public static String doPasswordDigest(String nonce, String created, String password) {
        String passwdDigest;
        block2: {
            passwdDigest = null;
            try {
                passwdDigest = UsernameToken.doPasswordDigest(nonce, created, password.getBytes("UTF-8"));
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block2;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return passwdDigest;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && 3 == node.getNodeType() ? (Text)node : null;
    }

    private String nodeString(Element e) {
        if (e != null) {
            StringBuilder builder = new StringBuilder();
            boolean found = false;
            for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (3 != node.getNodeType()) continue;
                found = true;
                builder.append(((Text)node).getData());
            }
            if (!found) {
                return null;
            }
            return builder.toString();
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString((Node)this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public byte[] getDerivedKey(BSPEnforcer bspEnforcer) throws WSSecurityException {
        if (this.rawPassword == null) {
            LOG.debug("The raw password was null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (this.elementSalt == null) {
            bspEnforcer.handleBSPRule(BSPRule.R4217);
        }
        if (this.elementIteration == null) {
            bspEnforcer.handleBSPRule(BSPRule.R4218);
        } else {
            String iter = this.nodeString(this.elementIteration);
            if (iter == null || Integer.parseInt(iter) < 1000) {
                bspEnforcer.handleBSPRule(BSPRule.R4218);
            }
        }
        int iteration = this.getIteration();
        byte[] salt = this.getSalt();
        if (this.passwordsAreEncoded) {
            try {
                return UsernameTokenUtil.generateDerivedKey((byte[])Base64.decode((String)this.rawPassword), (byte[])salt, (int)iteration);
            }
            catch (Base64DecodingException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "decoding.general", (Exception)((Object)e));
            }
        }
        return UsernameTokenUtil.generateDerivedKey((String)this.rawPassword, (byte[])salt, (int)iteration);
    }

    public boolean isDerivedKey() throws WSSecurityException {
        return this.elementSalt != null && this.elementIteration != null;
    }

    public Principal createPrincipal() throws WSSecurityException {
        try {
            WSUsernameTokenPrincipalImpl principal = new WSUsernameTokenPrincipalImpl(this.getName(), this.isHashed());
            principal.setNonce(Base64.decode((String)this.getNonce()));
            principal.setPassword(this.getPassword());
            principal.setCreatedTime(this.getCreated());
            return principal;
        }
        catch (Base64DecodingException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "decoding.general", (Exception)((Object)e));
        }
    }

    public boolean verifyCreated(int timeToLive, int futureTimeToLive) {
        return DateUtil.verifyCreated((Date)this.createdDate, (int)timeToLive, (int)futureTimeToLive);
    }

    public int hashCode() {
        int result;
        block8: {
            String created;
            String nonce;
            String passwordType;
            String password;
            result = 17;
            String username = this.getName();
            if (username != null) {
                result = 31 * result + username.hashCode();
            }
            if ((password = this.getPassword()) != null) {
                result = 31 * result + password.hashCode();
            }
            if ((passwordType = this.getPasswordType()) != null) {
                result = 31 * result + passwordType.hashCode();
            }
            if ((nonce = this.getNonce()) != null) {
                result = 31 * result + nonce.hashCode();
            }
            if ((created = this.getCreated()) != null) {
                result = 31 * result + created.hashCode();
            }
            try {
                byte[] salt = this.getSalt();
                if (salt != null) {
                    result = 31 * result + Arrays.hashCode(salt);
                }
            }
            catch (WSSecurityException ex) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        result = 31 * result + Integer.valueOf(this.getIteration()).hashCode();
        return result;
    }

    public boolean equals(Object object) {
        int iteration;
        UsernameToken usernameToken;
        block9: {
            if (!(object instanceof UsernameToken)) {
                return false;
            }
            usernameToken = (UsernameToken)object;
            if (!this.compare(usernameToken.getName(), this.getName())) {
                return false;
            }
            if (!this.compare(usernameToken.getPassword(), this.getPassword())) {
                return false;
            }
            if (!this.compare(usernameToken.getPasswordType(), this.getPasswordType())) {
                return false;
            }
            if (!this.compare(usernameToken.getNonce(), this.getNonce())) {
                return false;
            }
            if (!this.compare(usernameToken.getCreated(), this.getCreated())) {
                return false;
            }
            try {
                byte[] salt = usernameToken.getSalt();
                if (!Arrays.equals(salt, this.getSalt())) {
                    return false;
                }
            }
            catch (WSSecurityException ex) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return (iteration = usernameToken.getIteration()) == this.getIteration();
    }

    private boolean compare(String item1, String item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }

    private void checkBSPCompliance(BSPEnforcer bspEnforcer) throws WSSecurityException {
        List<Element> nonceElements;
        List<Element> createdElements;
        Element passwordChild;
        String type;
        List<Element> passwordElements = WSSecurityUtil.getDirectChildElements(this.element, "Password", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (passwordElements.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The Username Token had more than one password element");
            }
            bspEnforcer.handleBSPRule(BSPRule.R4222);
        }
        if (passwordElements.size() == 1 && ((type = (passwordChild = passwordElements.get(0)).getAttributeNS(null, "Type")) == null || "".equals(type))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The Username Token password does not have a Type attribute");
            }
            bspEnforcer.handleBSPRule(BSPRule.R4201);
        }
        if ((createdElements = WSSecurityUtil.getDirectChildElements(this.element, "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")).size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The Username Token has more than one created element");
            }
            bspEnforcer.handleBSPRule(BSPRule.R4223);
        }
        if ((nonceElements = WSSecurityUtil.getDirectChildElements(this.element, "Nonce", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")).size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The Username Token has more than one nonce element");
            }
            bspEnforcer.handleBSPRule(BSPRule.R4225);
        }
        if (nonceElements.size() == 1) {
            Element nonce = nonceElements.get(0);
            String encodingType = nonce.getAttributeNS(null, "EncodingType");
            if (encodingType == null || "".equals(encodingType)) {
                bspEnforcer.handleBSPRule(BSPRule.R4220);
            } else if (!BASE64_ENCODING.equals(encodingType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The Username Token's nonce element has a bad encoding type");
                }
                bspEnforcer.handleBSPRule(BSPRule.R4221);
            }
        }
    }
}

