/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.security.Key;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.AlgorithmSuiteValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.processor.ReferenceListProcessor;
import org.apache.wss4j.dom.processor.X509Util;
import org.apache.wss4j.dom.str.SecurityTokenRefSTRParser;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedDataProcessor
implements Processor {
    private static Logger log = LoggerFactory.getLogger(EncryptedDataProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element kiElem;
        if (log.isDebugEnabled()) {
            log.debug("Found EncryptedData element");
        }
        if ((kiElem = WSSecurityUtil.getDirectChildElement(elem, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#")) == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noKeyinfo", new Object[0]);
        }
        String symEncAlgo = X509Util.getEncAlgo(elem);
        EncryptedDataProcessor.checkBSPCompliance(symEncAlgo, request.getBSPEnforcer());
        Element secRefToken = WSSecurityUtil.getDirectChildElement(kiElem, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Element encryptedKeyElement = WSSecurityUtil.getDirectChildElement(kiElem, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#");
        if (elem != null && request.isRequireSignedEncryptedDataElements()) {
            WSSecurityUtil.verifySignedElement(elem, elem.getOwnerDocument(), wsDocInfo.getSecurityHeader());
        }
        SecretKey key = null;
        List<WSSecurityEngineResult> encrKeyResults = null;
        Principal principal = null;
        if (secRefToken != null) {
            SecurityTokenRefSTRParser strParser = new SecurityTokenRefSTRParser();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("signature_method", symEncAlgo);
            strParser.parseSecurityTokenReference(secRefToken, request, wsDocInfo, parameters);
            byte[] secretKey = strParser.getSecretKey();
            principal = strParser.getPrincipal();
            key = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])secretKey);
        } else if (encryptedKeyElement != null) {
            EncryptedKeyProcessor encrKeyProc = new EncryptedKeyProcessor();
            encrKeyResults = encrKeyProc.handleToken(encryptedKeyElement, request, wsDocInfo);
            byte[] symmKey = (byte[])encrKeyResults.get(0).get("secret");
            key = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])symmKey);
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noEncKey", new Object[0]);
        }
        AlgorithmSuite algorithmSuite = request.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            if (principal instanceof WSDerivedKeyTokenPrincipal) {
                algorithmSuiteValidator.checkDerivedKeyAlgorithm(((WSDerivedKeyTokenPrincipal)principal).getAlgorithm());
                algorithmSuiteValidator.checkEncryptionDerivedKeyLength(((WSDerivedKeyTokenPrincipal)principal).getLength());
            }
            algorithmSuiteValidator.checkSymmetricKeyLength(key.getEncoded().length);
            algorithmSuiteValidator.checkSymmetricEncryptionAlgorithm(symEncAlgo);
        }
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.setSecureValidation(true);
            xmlCipher.init(2, (Key)key);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
        Node previousSibling = elem.getPreviousSibling();
        Node parent = elem.getParentNode();
        try {
            xmlCipher.doFinal(elem.getOwnerDocument(), elem, false);
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, e);
        }
        WSDataRef dataRef = new WSDataRef();
        dataRef.setWsuId(elem.getAttributeNS(null, "Id"));
        dataRef.setAlgorithm(symEncAlgo);
        dataRef.setContent(false);
        Node decryptedNode = previousSibling == null ? parent.getFirstChild() : previousSibling.getNextSibling();
        if (decryptedNode != null && 1 == decryptedNode.getNodeType()) {
            dataRef.setProtectedElement((Element)decryptedNode);
        }
        dataRef.setXpath(ReferenceListProcessor.getXPath(decryptedNode));
        WSSecurityEngineResult result = new WSSecurityEngineResult(4, Collections.singletonList(dataRef));
        result.put("id", elem.getAttributeNS(null, "Id"));
        wsDocInfo.addResult(result);
        wsDocInfo.addTokenElement(elem);
        ArrayList<WSSecurityEngineResult> completeResults = new ArrayList<WSSecurityEngineResult>();
        if (encrKeyResults != null) {
            completeResults.addAll(encrKeyResults);
        }
        completeResults.add(result);
        WSSConfig wssConfig = request.getWssConfig();
        if (wssConfig != null) {
            Element decryptedElem = previousSibling == null ? (Element)parent.getFirstChild() : (Element)previousSibling.getNextSibling();
            QName el = new QName(decryptedElem.getNamespaceURI(), decryptedElem.getLocalName());
            Processor proc = request.getWssConfig().getProcessor(el);
            if (proc != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Processing decrypted element with: " + proc.getClass().getName());
                }
                List<WSSecurityEngineResult> results = proc.handleToken(decryptedElem, request, wsDocInfo);
                completeResults.addAll(0, results);
                return completeResults;
            }
        }
        return completeResults;
    }

    private static void checkBSPCompliance(String encAlgo, BSPEnforcer bspEnforcer) throws WSSecurityException {
        if (encAlgo == null) {
            bspEnforcer.handleBSPRule(BSPRule.R5601);
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(encAlgo))) {
            bspEnforcer.handleBSPRule(BSPRule.R5620);
        }
    }
}

