/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class DOMSAMLUtil {
    private static Logger log = LoggerFactory.getLogger(DOMSAMLUtil.class);

    private DOMSAMLUtil() {
    }

    public static void validateSAMLResults(List<WSSecurityEngineResult> results, Certificate[] tlsCerts, Element body) throws WSSecurityException {
        ArrayList<Integer> samlActions = new ArrayList<Integer>(2);
        samlActions.add(16);
        samlActions.add(8);
        List<WSSecurityEngineResult> samlResults = WSSecurityUtil.fetchAllActionResults(results, samlActions);
        if (samlResults.isEmpty()) {
            return;
        }
        ArrayList<Integer> signedActions = new ArrayList<Integer>(2);
        signedActions.add(2);
        signedActions.add(64);
        List<WSSecurityEngineResult> signedResults = WSSecurityUtil.fetchAllActionResults(results, signedActions);
        for (WSSecurityEngineResult samlResult : samlResults) {
            SamlAssertionWrapper assertionWrapper = (SamlAssertionWrapper)samlResult.get("saml-assertion");
            if (!DOMSAMLUtil.checkHolderOfKey(assertionWrapper, signedResults, tlsCerts)) {
                log.warn("Assertion fails holder-of-key requirements");
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
            }
            if (DOMSAMLUtil.checkSenderVouches(assertionWrapper, tlsCerts, body, signedResults)) continue;
            log.warn("Assertion fails sender-vouches requirements");
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
    }

    public static boolean checkHolderOfKey(SamlAssertionWrapper assertionWrapper, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            if (tlsCerts == null && (signedResults == null || signedResults.isEmpty())) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (DOMSAMLUtil.compareCredentials(subjectKeyInfo, signedResults, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        byte[] subjectSecretKey = subjectKeyInfo.getSecret();
        if (tlsCerts != null && tlsCerts.length > 0 && subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        if (tlsCerts != null && tlsCerts.length > 0 && subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey)) {
            return true;
        }
        for (WSSecurityEngineResult signedResult : signedResults) {
            X509Certificate[] certs = (X509Certificate[])signedResult.get("x509-certificates");
            PublicKey publicKey = (PublicKey)signedResult.get("public-key");
            byte[] secretKey = (byte[])signedResult.get("secret");
            if (certs != null && certs.length > 0 && subjectCerts != null && subjectCerts.length > 0 && certs[0].equals(subjectCerts[0])) {
                return true;
            }
            if (publicKey != null && publicKey.equals(subjectPublicKey)) {
                return true;
            }
            if (!DOMSAMLUtil.checkSecretKey(secretKey, subjectSecretKey, signedResult)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSecretKey(byte[] secretKey, byte[] subjectSecretKey, WSSecurityEngineResult signedResult) {
        if (secretKey != null && subjectSecretKey != null) {
            if (Arrays.equals(secretKey, subjectSecretKey)) {
                return true;
            }
            Principal principal = (Principal)signedResult.get("principal");
            if (principal instanceof WSDerivedKeyTokenPrincipal && Arrays.equals(secretKey = ((WSDerivedKeyTokenPrincipal)principal).getSecret(), subjectSecretKey)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSenderVouches(SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts, Element body, List<WSSecurityEngineResult> signed) {
        if (tlsCerts != null && tlsCerts.length > 0) {
            return true;
        }
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
            if (signed == null || signed.isEmpty()) {
                return false;
            }
            if (DOMSAMLUtil.checkAssertionAndBodyAreSigned(assertionWrapper, body, signed)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkAssertionAndBodyAreSigned(SamlAssertionWrapper assertionWrapper, Element body, List<WSSecurityEngineResult> signed) {
        for (WSSecurityEngineResult signedResult : signed) {
            List sl = (List)signedResult.get("data-ref-uris");
            boolean assertionIsSigned = false;
            boolean bodyIsSigned = false;
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                Element se = dataRef.getProtectedElement();
                if (se == assertionWrapper.getElement()) {
                    assertionIsSigned = true;
                }
                if (se == body) {
                    bodyIsSigned = true;
                }
                if (!assertionIsSigned || !bodyIsSigned) continue;
                return true;
            }
        }
        return false;
    }
}

