/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.w3c.dom.Element;

public class SAMLElementCallbackHandler
extends AbstractSAMLCallbackHandler {
    public SAMLElementCallbackHandler() {
        this.subjectName = "uid=joe,ou=people,ou=saml-demo,o=example.com";
        this.subjectQualifier = "www.example.com";
        this.confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Element assertionElement;
            SAMLCallback callback;
            if (callbacks[i] instanceof SAMLCallback) {
                callback = (SAMLCallback)callbacks[i];
                try {
                    assertionElement = this.getSAMLAssertion();
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            callback.setAssertionElement(assertionElement);
        }
    }

    private Element getSAMLAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setIssuer(this.issuer);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertionWrapper = new SamlAssertionWrapper(samlCallback);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return samlAssertionWrapper.toDOM(factory.newDocumentBuilder().newDocument());
    }
}

