/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptionAlgorithmSuiteTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionAlgorithmSuiteTest.class);
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public EncryptionAlgorithmSuiteTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testEncryption() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        this.verify(securityHeader, algorithmSuite, this.crypto);
        algorithmSuite.setMinimumAsymmetricKeyLength(1024);
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            EncryptionAlgorithmSuiteTest.fail((String)"Expected failure as 512-bit keys are not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptionKeyTransportRSA15() throws Exception {
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, wssCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, wssCrypto);
            EncryptionAlgorithmSuiteTest.fail((String)"Expected failure as RSA 15 is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addKeyWrapAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        this.verify(securityHeader, algorithmSuite, wssCrypto);
    }

    @Test
    public void testEncryptionMethodAES128() throws Exception {
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, wssCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, wssCrypto);
            EncryptionAlgorithmSuiteTest.fail((String)"Expected failure as AES 128 is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.verify(securityHeader, algorithmSuite, wssCrypto);
    }

    @Test
    public void testSymmetricEncryption() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setKeyIdentifierType(10);
        builder.setSymmetricKey(key);
        builder.setEncryptSymmKey(false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        byte[] encodedBytes = WSSecurityUtil.generateDigest((byte[])keyData);
        String identifier = Base64.encode((byte[])encodedBytes);
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        secretKeyCallbackHandler.addSecretKey(identifier, keyData);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setDecCrypto(this.crypto);
        data.setCallbackHandler((CallbackHandler)secretKeyCallbackHandler);
        data.setAlgorithmSuite(algorithmSuite);
        algorithmSuite.addEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        secEngine.processSecurityHeader(securityHeader, data);
        algorithmSuite.setMinimumSymmetricKeyLength(256);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            EncryptionAlgorithmSuiteTest.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.setMinimumSymmetricKeyLength(64);
        algorithmSuite.setMaximumSymmetricKeyLength(120);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            EncryptionAlgorithmSuiteTest.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    private AlgorithmSuite createAlgorithmSuite() {
        AlgorithmSuite algorithmSuite = new AlgorithmSuite();
        algorithmSuite.setMinimumAsymmetricKeyLength(512);
        algorithmSuite.addKeyWrapAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        algorithmSuite.addEncryptionMethod("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        return algorithmSuite;
    }

    private List<WSSecurityEngineResult> verify(Element securityHeader, AlgorithmSuite algorithmSuite, Crypto decCrypto) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setDecCrypto(decCrypto);
        data.setAlgorithmSuite(algorithmSuite);
        data.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        return secEngine.processSecurityHeader(securityHeader, data);
    }
}

