/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionTest.class);
    private static final QName SOAP_BODY = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler keystoreCallbackHandler = new KeystoreCallbackHandler();
    private SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
    private byte[] keyData;
    private SecretKey key;
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Before
    public void setUp() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        this.key = keyGen.generateKey();
        this.keyData = this.key.getEncoded();
        this.secEngine.setWssConfig(WSSConfig.getNewInstance());
    }

    @Test
    public void testEncryptionDecryptionRSA15() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        LOG.info("Before Encryption Triple DES....");
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        LOG.info("After Encryption Triple DES....");
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-15 keytransport, 3DES:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertFalse((boolean)outputString.contains("counter_port_type"));
        this.verify(encryptedDoc, this.keystoreCallbackHandler, SOAP_BODY);
        builder.setKeyIdentifierType(2);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        builder.setSymmetricKey(null);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        parts.add(encP);
        builder.setParts(parts);
        doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        LOG.info("Before Encryption AES 128/RSA-15....");
        encryptedDoc = builder.build(doc, this.crypto, secHeader);
        LOG.info("After Encryption AES 128/RSA-15....");
        outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-15 keytransport, AES 128:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertFalse((boolean)outputString.contains("counter_port_type"));
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc, this.keystoreCallbackHandler, new QName("http://ws.apache.org/counter/counter_port_type", "add"));
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        EncryptionTest.assertTrue((referenceType == STRParser.REFERENCE_TYPE.ISSUER_SERIAL ? 1 : 0) != 0);
    }

    @Test
    public void testEncryptionDecryptionOAEP() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(3);
        builder.setKeyEnc("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        LOG.info("Before Encryption Triple DES/RSA-OAEP....");
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        LOG.info("After Encryption Triple DES/RSA-OAEP....");
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-OAEP keytransport, 3DES:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
            EncryptionTest.fail((String)"Failure expected on a bad ValueType attribute");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.keystoreCallbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3063));
        List results = newEngine.processSecurityHeader(encryptedDoc, "", data);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)4);
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        EncryptionTest.assertTrue((referenceType == STRParser.REFERENCE_TYPE.KEY_IDENTIFIER ? 1 : 0) != 0);
    }

    @Test
    public void testEncryptionEncryption() throws Exception {
        Crypto encCrypto = CryptoFactory.getInstance();
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        LOG.info("Before Encryption....");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = encrypt.build(doc, encCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After the first encryption:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Document encryptedEncryptedDoc = encrypt.build(encryptedDoc, encCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After the second encryption:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedEncryptedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Encryption....");
        this.verify(encryptedEncryptedDoc, encCrypto, this.keystoreCallbackHandler);
    }

    @Test
    public void testX509EncryptionThumb() throws Exception {
        Crypto encCrypto = CryptoFactory.getInstance();
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(8);
        LOG.info("Before Encrypting ThumbprintSHA1....");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, encCrypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with THUMBPRINT_IDENTIFIER:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertTrue((boolean)outputString.contains("#ThumbprintSHA1"));
        LOG.info("After Encrypting ThumbprintSHA1....");
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc, encCrypto, this.keystoreCallbackHandler);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        EncryptionTest.assertTrue((referenceType == STRParser.REFERENCE_TYPE.THUMBPRINT_SHA1 ? 1 : 0) != 0);
    }

    @Test
    public void testX509EncryptionSHA1() throws Exception {
        Crypto encCrypto = CryptoFactory.getInstance();
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(10);
        LOG.info("Before Encrypting EncryptedKeySHA1....");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, encCrypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with ENCRYPTED_KEY_SHA1_IDENTIFIER:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertTrue((boolean)outputString.contains("#EncryptedKeySHA1"));
        LOG.info("After Encrypting EncryptedKeySHA1....");
        this.verify(encryptedDoc, encCrypto, this.keystoreCallbackHandler);
    }

    @Test
    public void testEncryptionSHA1Symmetric() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setKeyIdentifierType(10);
        builder.setSymmetricKey(this.key);
        builder.setEncryptSymmKey(false);
        LOG.info("Before Encrypting EncryptedKeySHA1....");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        byte[] encodedBytes = WSSecurityUtil.generateDigest((byte[])this.keyData);
        String identifier = Base64.encode((byte[])encodedBytes);
        this.secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with ENCRYPTED_KEY_SHA1_IDENTIFIER:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertTrue((boolean)outputString.contains("#EncryptedKeySHA1"));
        LOG.info("After Encrypting EncryptedKeySHA1....");
        this.verify(encryptedDoc, null, this.secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionSHA1SymmetricBytes() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setKeyIdentifierType(10);
        builder.setEphemeralKey(this.keyData);
        builder.setEncryptSymmKey(false);
        LOG.info("Before Encrypting EncryptedKeySHA1....");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        byte[] encodedBytes = WSSecurityUtil.generateDigest((byte[])this.keyData);
        String identifier = Base64.encode((byte[])encodedBytes);
        this.secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with ENCRYPTED_KEY_SHA1_IDENTIFIER:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertTrue((boolean)outputString.contains("#EncryptedKeySHA1"));
        LOG.info("After Encrypting EncryptedKeySHA1....");
        this.verify(encryptedDoc, this.crypto, this.secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionSHA1SymmetricBytesHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, Object> messageContext = new TreeMap<String, Object>();
        messageContext.put("encryptSymmetricEncryptionKey", "false");
        messageContext.put("encryptionKeyIdentifier", "EncryptedKeySHA1");
        this.secretKeyCallbackHandler.setOutboundSecret(this.keyData);
        messageContext.put("passwordCallbackRef", this.secretKeyCallbackHandler);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(4));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, null, this.secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionDecryptionRSA15STR() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        LOG.info("Before Encryption Triple DES....");
        builder.prepare(doc, this.crypto);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        Element refs = builder.encryptForRef(null, parts);
        builder.addExternalRefElement(refs, secHeader);
        builder.prependToHeader(secHeader);
        builder.prependBSTElementToHeader(secHeader);
        Document encryptedDoc = doc;
        LOG.info("After Encryption Triple DES....");
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-15 keytransport, 3DES:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertFalse((boolean)outputString.contains("counter_port_type"));
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc, this.crypto, this.keystoreCallbackHandler);
        outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        EncryptionTest.assertTrue((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        EncryptionTest.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        EncryptionTest.assertTrue((referenceType == STRParser.REFERENCE_TYPE.DIRECT_REF ? 1 : 0) != 0);
    }

    @Test
    public void testBadAttribute() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        builder.prepare(doc, this.crypto);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        Element refs = builder.encryptForRef(null, parts);
        builder.addExternalRefElement(refs, secHeader);
        Element encryptedKeyElement = builder.getEncryptedKeyElement();
        encryptedKeyElement.setAttributeNS(null, "Type", "SomeType");
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)encryptedKeyElement);
        builder.prependBSTElementToHeader(secHeader);
        Document encryptedDoc = doc;
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
            EncryptionTest.fail((String)"Failure expected on a bad attribute type");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.keystoreCallbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3209));
        newEngine.processSecurityHeader(encryptedDoc, "", data);
    }

    @Test
    public void testEmbeddedEncryptedKey() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(4);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        builder.prepare(doc, this.crypto);
        builder.setEmbedEncryptedKey(true);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        builder.encryptForRef(null, parts);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, this.crypto, this.keystoreCallbackHandler);
    }

    @Test
    public void testEncryptionDecryptionOAEPSHA256() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyEnc("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        builder.setDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        LOG.info("Before Encryption Triple DES/RSA-OAEP....");
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        LOG.info("After Encryption Triple DES/RSA-OAEP....");
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-OAEP keytransport, 3DES:");
            LOG.debug(outputString);
        }
        EncryptionTest.assertTrue((!outputString.contains("counter_port_type") ? 1 : 0) != 0);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        List results = newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)4);
        EncryptionTest.assertNotNull((Object)actionResult);
    }

    private List<WSSecurityEngineResult> verify(Document doc, Crypto decCrypto, CallbackHandler handler) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, handler, decCrypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }

    private List<WSSecurityEngineResult> verify(Document doc, CallbackHandler handler, QName expectedEncryptedElement) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, handler, null, this.crypto);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        EncryptionTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        boolean encrypted = false;
        for (WSSecurityEngineResult result : results) {
            Integer action = (Integer)result.get((Object)"action");
            EncryptionTest.assertNotNull((Object)action);
            if ((action & 4) == 0) continue;
            List refs = (List)result.get((Object)"data-ref-uris");
            EncryptionTest.assertNotNull((Object)refs);
            encrypted = true;
            for (WSDataRef ref : refs) {
                EncryptionTest.assertNotNull((Object)ref);
                EncryptionTest.assertNotNull((Object)ref.getName());
                EncryptionTest.assertEquals((Object)expectedEncryptedElement, (Object)ref.getName());
                EncryptionTest.assertNotNull((Object)ref.getProtectedElement());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("WSDataRef element: ");
                LOG.debug(DOM2Writer.nodeToString((Node)ref.getProtectedElement()));
            }
        }
        EncryptionTest.assertTrue((boolean)encrypted);
        return results;
    }
}

