/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSecurityContextToken;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SecurityContextTokenTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityContextTokenTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private SecretKeyCallbackHandler callbackHandler = new SecretKeyCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testBuild() {
        try {
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.prepare(doc, this.crypto);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            String out = XMLUtils.PrettyDocumentToString((Document)doc);
            if (LOG.isDebugEnabled()) {
                LOG.debug(out);
            }
            SecurityContextTokenTest.assertTrue((String)"SecurityContextToken missing", (out.indexOf("SecurityContextToken") > 0 ? 1 : 0) != 0);
            SecurityContextTokenTest.assertTrue((String)"wsc:Identifier missing", (out.indexOf("Identifier") > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTDKTEncrypt() {
        try {
            List<WSSecurityEngineResult> results;
            WSSecurityEngineResult actionResult;
            SecurityContextToken receivedToken;
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.prepare(doc, this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
            encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encrBuilder.setExternalKey(tempSecret, tokenId);
            encrBuilder.build(doc, secHeader);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.PrettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            SecurityContextTokenTest.assertTrue(((receivedToken = (SecurityContextToken)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(doc), (int)1024)).get((Object)"security-context-token")) != null ? 1 : 0) != 0);
            SecurityContextTokenTest.assertTrue((boolean)"http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(receivedToken.getTokenType()));
            SecurityContextToken clone = new SecurityContextToken(receivedToken.getElement());
            SecurityContextTokenTest.assertTrue((boolean)clone.equals((Object)receivedToken));
            SecurityContextTokenTest.assertTrue((clone.hashCode() == receivedToken.hashCode() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTSign() {
        try {
            List<WSSecurityEngineResult> results;
            WSSecurityEngineResult actionResult;
            SecurityContextToken receivedToken;
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.setWscVersion(2);
            sctBuilder.prepare(doc, this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKSign sigBuilder = new WSSecDKSign();
            sigBuilder.setExternalKey(tempSecret, tokenId);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(doc, secHeader);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.PrettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            SecurityContextTokenTest.assertTrue(((receivedToken = (SecurityContextToken)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(doc), (int)1024)).get((Object)"security-context-token")) != null ? 1 : 0) != 0);
            SecurityContextTokenTest.assertTrue((boolean)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(receivedToken.getTokenType()));
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTSignAbsolute() {
        try {
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.prepare(doc, this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            WSSecDKSign sigBuilder = new WSSecDKSign();
            sigBuilder.setExternalKey(tempSecret, sctBuilder.getIdentifier());
            sigBuilder.setTokenIdDirectId(true);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(doc, secHeader);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DKT Absolute");
                String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
                LOG.debug(outputString);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTSignEncrypt() {
        try {
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.prepare(doc, this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKSign sigBuilder = new WSSecDKSign();
            sigBuilder.setExternalKey(tempSecret, tokenId);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(doc, secHeader);
            WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
            encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encrBuilder.setExternalKey(tempSecret, tokenId);
            encrBuilder.build(doc, secHeader);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.PrettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTEncryptSign() {
        try {
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.prepare(doc, this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
            encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encrBuilder.setExternalKey(tempSecret, tokenId);
            encrBuilder.build(doc, secHeader);
            WSSecDKSign sigBuilder = new WSSecDKSign();
            sigBuilder.setExternalKey(tempSecret, tokenId);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(doc, secHeader);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.PrettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTSign() {
        try {
            Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken();
            sctBuilder.prepare(doc, this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecSignature builder = new WSSecSignature();
            builder.setSecretKey(tempSecret);
            builder.setKeyIdentifierType(9);
            builder.setCustomTokenValueType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            builder.setCustomTokenId(tokenId);
            builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            builder.build(doc, this.crypto, secHeader);
            sctBuilder.prependSCTElementToHeader(doc, secHeader);
            if (LOG.isDebugEnabled()) {
                LOG.debug("SCT sign");
                String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
                LOG.debug(outputString);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityContextTokenTest.fail((String)e.getMessage());
        }
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, (CallbackHandler)this.callbackHandler, this.crypto);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        SecurityContextTokenTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

