/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Principal;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.principal.PublicKeyPrincipal;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureKeyValueTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureKeyValueTest.class);
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignatureKeyValueTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testRSAKeyValue() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(13);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        SignatureKeyValueTest.assertTrue((boolean)outputString.contains("RSAKeyValue"));
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
        List results = secEngine.processSecurityHeader(signedDoc, "", data);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)2);
        SignatureKeyValueTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        SignatureKeyValueTest.assertTrue((boolean)(principal instanceof PublicKeyPrincipal));
        PublicKey publicKey = ((PublicKeyPrincipal)principal).getPublicKey();
        SignatureKeyValueTest.assertTrue((boolean)(publicKey instanceof RSAPublicKey));
    }

    @Test
    public void testBadRSAKeyValue() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("wss86", "security");
        builder.setKeyIdentifierType(13);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, CryptoFactory.getInstance((String)"wss86.properties"), secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        SignatureKeyValueTest.assertTrue((boolean)outputString.contains("RSAKeyValue"));
        try {
            WSSecurityEngine secEngine = new WSSecurityEngine();
            RequestData data = new RequestData();
            data.setSigVerCrypto(this.crypto);
            data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
            secEngine.processSecurityHeader(signedDoc, "", data);
            SignatureKeyValueTest.fail((String)"Failure expected on bad public key");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Test
    public void testDSAKeyValue() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("wss40DSA", "security");
        builder.setKeyIdentifierType(13);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        SignatureKeyValueTest.assertTrue((boolean)outputString.contains("DSAKeyValue"));
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
        List results = secEngine.processSecurityHeader(signedDoc, "", data);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)2);
        SignatureKeyValueTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        SignatureKeyValueTest.assertTrue((boolean)(principal instanceof PublicKeyPrincipal));
        PublicKey publicKey = ((PublicKeyPrincipal)principal).getPublicKey();
        SignatureKeyValueTest.assertTrue((boolean)(publicKey instanceof DSAPublicKey));
    }
}

