/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.IOException;
import java.util.Collections;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SymmetricSignatureTest
extends Assert
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SymmetricSignatureTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
    private byte[] keyData;
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SymmetricSignatureTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Before
    public void setUp() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        this.keyData = key.getEncoded();
    }

    @Test
    public void testSymmetricSignatureSHA1() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecSignature sign = new WSSecSignature();
        sign.setKeyIdentifierType(10);
        sign.setSecretKey(this.keyData);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        byte[] encodedBytes = WSSecurityUtil.generateDigest((byte[])this.keyData);
        String identifier = Base64.encode((byte[])encodedBytes);
        this.secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed symmetric message SHA1:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.secEngine.processSecurityHeader(doc, null, (CallbackHandler)this.secretKeyCallbackHandler, null, this.crypto);
    }

    @Test
    public void testSymmetricSignatureDR() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        encrKey.setKeyIdentifierType(2);
        encrKey.setUserInfo("wss40", "security");
        encrKey.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        encrKey.prepare(doc, this.crypto);
        WSSecSignature sign = new WSSecSignature();
        sign.setKeyIdentifierType(9);
        sign.setCustomTokenId(encrKey.getId());
        sign.setSecretKey(encrKey.getEphemeralKey());
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        encrKey.prependToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed symmetric message DR:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testEncryptedKeySignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        LOG.info("Before Sign/Encryption....");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        encrKey.setKeyIdentifierType(2);
        encrKey.setUserInfo("wss40", "security");
        encrKey.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        encrKey.prepare(doc, this.crypto);
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setEncKeyId(encrKey.getId());
        encrypt.setEphemeralKey(encrKey.getEphemeralKey());
        encrypt.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        encrypt.setEncryptSymmKey(false);
        encrypt.setEncryptedKeyElement(encrKey.getEncryptedKeyElement());
        WSSecSignature sign = new WSSecSignature();
        sign.setKeyIdentifierType(9);
        sign.setCustomTokenId(encrKey.getId());
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        sign.setSecretKey(encrKey.getEphemeralKey());
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        Document encryptedSignedDoc = encrypt.build(signedDoc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed and encrypted message with IssuerSerial key identifier (both), 3DES:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Sign/Encryption....");
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testSymmetricSignatureSHA1Handler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, Object> messageContext = new TreeMap<String, Object>();
        messageContext.put("signatureKeyIdentifier", "EncryptedKeySHA1");
        messageContext.put("signatureAlgorithm", "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        messageContext.put("passwordCallbackRef", this);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        reqData = new RequestData();
        reqData.setWssConfig(WSSConfig.getNewInstance());
        messageContext = new TreeMap();
        messageContext.put("passwordCallbackRef", this);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("");
        handler.receive(Collections.singletonList(2), reqData);
        this.secEngine.processSecurityHeader(doc, null, (CallbackHandler)this, null, this.crypto);
    }

    private void verify(Document doc) throws Exception {
        this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, null, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
            pc.setKey(this.keyData);
        }
    }
}

