/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.WSTimeSource;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.XmlSchemaDateFormat;
import org.apache.wss4j.dom.validate.NoOpValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimestampTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTest.class);

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testValidTimestamp() throws Exception {
        List<WSSecurityEngineResult> wsResult;
        WSSecurityEngineResult actionResult;
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        TimestampTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult(wsResult = this.verify(createdDoc, WSSConfig.getNewInstance()), (int)32)) != null ? 1 : 0) != 0);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        TimestampTest.assertTrue((receivedTimestamp != null ? 1 : 0) != 0);
        Timestamp clone = new Timestamp(receivedTimestamp.getElement(), new BSPEnforcer(true));
        TimestampTest.assertTrue((boolean)clone.equals((Object)receivedTimestamp));
        TimestampTest.assertTrue((clone.hashCode() == receivedTimestamp.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testValidTimestampNoExpires() throws Exception {
        List<WSSecurityEngineResult> wsResult;
        WSSecurityEngineResult actionResult;
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(0);
        Document createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        TimestampTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult(wsResult = this.verify(createdDoc, WSSConfig.getNewInstance()), (int)32)) != null ? 1 : 0) != 0);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        TimestampTest.assertTrue((receivedTimestamp != null ? 1 : 0) != 0);
    }

    @Test
    public void testExpiredTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(-1);
        Document createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(createdDoc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"Expected failure on an expired timestamp");
        }
        catch (WSSecurityException ex) {
            TimestampTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOldTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        Document createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setTimeStampTTL(-1);
        try {
            this.verify(createdDoc, wssConfig);
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            TimestampTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNearFutureCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        long currentTime = createdDate.getTime() + 30000L;
        createdDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSConfig config = WSSConfig.getNewInstance();
        this.verify(doc, config);
        try {
            config.setTimeStampFutureTTL(0);
            this.verify(doc, config);
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            TimestampTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFutureCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        long currentTime = createdDate.getTime() + 120000L;
        createdDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSConfig config = WSSConfig.getNewInstance();
        try {
            this.verify(doc, config);
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            TimestampTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExpiresBeforeCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        long currentTime = createdDate.getTime();
        createdDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        Date expiresDate = new Date();
        expiresDate.setTime(expiresDate.getTime() - 300000L);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        elementExpires.appendChild(doc.createTextNode(zulu.format(expiresDate)));
        timestampElement.appendChild(elementExpires);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleTimestamps() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build(doc, secHeader);
        timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(60);
        createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        try {
            this.verify(createdDoc, wssConfig);
            TimestampTest.fail((String)"Expected failure on multiple timestamps");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        this.verify(createdDoc, Collections.singletonList(BSPRule.R3227));
    }

    @Test
    public void testMultipleCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        timestampElement.appendChild(elementCreated.cloneNode(true));
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed on multiple Created elements");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3203));
    }

    @Test
    public void testNoCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        Date createdDate = new Date();
        long currentTime = createdDate.getTime() + 300000L;
        createdDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed on no Created element");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        ArrayList<BSPRule> rules = new ArrayList<BSPRule>();
        rules.add(BSPRule.R3203);
        rules.add(BSPRule.R3221);
        this.verify(doc, rules);
    }

    @Test
    public void testMultipleExpires() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        long currentTime = createdDate.getTime();
        createdDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        zulu = new XmlSchemaDateFormat();
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        createdDate.setTime(currentTime + 300000L);
        elementExpires.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementExpires);
        timestampElement.appendChild(elementExpires.cloneNode(true));
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed on multiple Expires elements");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3224));
    }

    @Test
    public void testExpiresInFrontOfCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        Date expiresDate = new Date();
        long currentTime = expiresDate.getTime() + 300000L;
        expiresDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(expiresDate)));
        timestampElement.appendChild(elementCreated);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        elementExpires.appendChild(doc.createTextNode(zulu.format(new Date())));
        timestampElement.appendChild(elementExpires);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3221));
    }

    @Test
    public void testCreatedSeconds() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        elementCreated.appendChild(doc.createTextNode("2011-02-08T13:13:84.535Z"));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setValidator(WSSecurityEngine.TIMESTAMP, (Validator)new NoOpValidator());
        try {
            this.verify(doc, wssConfig);
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testCreatedValueType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        long currentTime = createdDate.getTime() + 300000L;
        createdDate.setTime(currentTime);
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        elementCreated.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setValidator(WSSecurityEngine.TIMESTAMP, (Validator)new NoOpValidator());
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        this.verify(doc, wssConfig, Collections.singletonList(BSPRule.R3225));
    }

    @Test
    public void testCustomElement() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date createdDate = new Date();
        elementCreated.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementCreated);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        createdDate.setTime(createdDate.getTime() + 300000L);
        elementExpires.appendChild(doc.createTextNode(zulu.format(createdDate)));
        timestampElement.appendChild(elementExpires);
        Element elementCustom = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Custom");
        timestampElement.appendChild(elementCustom);
        secHeader.getSecurityHeader().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3222));
    }

    @Test
    public void testSpoofedTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(300);
        WSSConfig config = WSSConfig.getNewInstance();
        WSTimeSource spoofedTimeSource = new WSTimeSource(){

            public Date now() {
                Date currentTime = new Date();
                currentTime.setTime(currentTime.getTime() - 500000L);
                return currentTime;
            }
        };
        config.setCurrentTime(spoofedTimeSource);
        timestamp.setWsConfig(config);
        Document createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(createdDoc, WSSConfig.getNewInstance());
            TimestampTest.fail((String)"Expected failure on an expired timestamp");
        }
        catch (WSSecurityException ex) {
            TimestampTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTimestampNoMilliseconds() throws Exception {
        List<WSSecurityEngineResult> wsResult;
        WSSecurityEngineResult actionResult;
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setPrecisionInMilliSeconds(false);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setWsConfig(wssConfig);
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        TimestampTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult(wsResult = this.verify(createdDoc, WSSConfig.getNewInstance()), (int)32)) != null ? 1 : 0) != 0);
    }

    private List<WSSecurityEngineResult> verify(Document doc, WSSConfig wssConfig) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setWssConfig(wssConfig);
        return secEngine.processSecurityHeader(doc, "", requestData);
    }

    private List<WSSecurityEngineResult> verify(Document doc, List<BSPRule> ignoredRules) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setIgnoredBSPRules(ignoredRules);
        return secEngine.processSecurityHeader(doc, "", requestData);
    }

    private List<WSSecurityEngineResult> verify(Document doc, WSSConfig wssConfig, List<BSPRule> ignoredRules) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setWssConfig(wssConfig);
        requestData.setIgnoredBSPRules(ignoredRules);
        return secEngine.processSecurityHeader(doc, "", requestData);
    }
}

