/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.MessageDigest;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.EncodedPasswordCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UTDerivedKeyTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(UTDerivedKeyTest.class);
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testUsernameTokenUnit() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        byte[] salt = usernameToken.addSalt(doc, null, false);
        UTDerivedKeyTest.assertTrue((salt.length == 16 ? 1 : 0) != 0);
        UTDerivedKeyTest.assertTrue((salt[0] == 2 ? 1 : 0) != 0);
        byte[] utSalt = usernameToken.getSalt();
        UTDerivedKeyTest.assertTrue((salt.length == utSalt.length ? 1 : 0) != 0);
        for (int i = 0; i < salt.length; ++i) {
            UTDerivedKeyTest.assertTrue((salt[i] == utSalt[i] ? 1 : 0) != 0);
        }
        usernameToken.addIteration(doc, 500);
        UTDerivedKeyTest.assertTrue((usernameToken.getIteration() == 500 ? 1 : 0) != 0);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)usernameToken.getElement());
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)500);
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        derivedKey = UsernameTokenUtil.generateDerivedKey((byte[])Base64.decode((String)"c2VjdXJpdHk="), (byte[])salt, (int)500);
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
    }

    @Test
    public void testDerivedKeyWithEncodedPasswordBaseline() throws Exception {
        String password = "password";
        byte[] passwordHash = MessageDigest.getInstance("SHA-1").digest(password.getBytes("UTF-8"));
        byte[] salt = Base64.decode((String)"LKpycbfgRzwDnBz6kkhAAQ==");
        int iteration = 1049;
        byte[] expectedDerivedKey = Base64.decode((String)"C7Ll/OY4TECb6hZuMMiX/5hzszo=");
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((byte[])passwordHash, (byte[])salt, (int)iteration);
        UTDerivedKeyTest.assertTrue((String)"the derived key is not as expected", (boolean)Arrays.equals(expectedDerivedKey, derivedKey));
    }

    @Test
    public void testDerivedKeyEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
        try {
            this.verify(encryptedDoc, false);
            UTDerivedKeyTest.fail((String)"Failure expected on deriving keys from a UsernameToken not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testDerivedKeyEncryptionWithEncodedPassword() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setPasswordsAreEncoded(true);
        builder.setUserInfo("bob", Base64.encode((byte[])MessageDigest.getInstance("SHA-1").digest("security".getBytes("UTF-8"))));
        builder.addDerivedKey(false, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.getWssConfig().setPasswordsAreEncoded(true);
        newEngine.getWssConfig().setAllowUsernameTokenNoPassword(true);
        newEngine.processSecurityHeader(encryptedDoc, null, (CallbackHandler)new EncodedPasswordCallbackHandler(), null);
    }

    @Test
    public void testDerivedKeyChangedEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        derivedKey[5] = 122;
        derivedKey[6] = 97;
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a bad derived encryption");
        }
        catch (WSSecurityException ex) {
            UTDerivedKeyTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeyBadUserEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("colm", "security");
        builder.addDerivedKey(false, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a bad derived encryption");
        }
        catch (WSSecurityException ex) {
            UTDerivedKeyTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeySignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(true, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(derivedKey, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        UTDerivedKeyTest.assertTrue((boolean)principal.getName().contains("DK"));
    }

    @Test
    public void testDerivedKeySignatureWithEncodedPassword() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setPasswordsAreEncoded(true);
        builder.setUserInfo("bob", Base64.encode((byte[])MessageDigest.getInstance("SHA-1").digest("security".getBytes("UTF-8"))));
        builder.addDerivedKey(true, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(derivedKey, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.getWssConfig().setPasswordsAreEncoded(true);
        newEngine.getWssConfig().setAllowUsernameTokenNoPassword(true);
        List results = newEngine.processSecurityHeader(signedDoc, null, (CallbackHandler)new EncodedPasswordCallbackHandler(), null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)2);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        UTDerivedKeyTest.assertTrue((boolean)principal.getName().contains("DK"));
    }

    @Test
    public void testDerivedKeyChangedSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(true, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        derivedKey[5] = derivedKey[5] != 12 ? 12 : 13;
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(derivedKey, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a bad derived signature");
        }
        catch (WSSecurityException ex) {
            UTDerivedKeyTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeyBadUserSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("colm", "security");
        builder.addDerivedKey(true, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(derivedKey, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a bad derived signature");
        }
        catch (WSSecurityException ex) {
            UTDerivedKeyTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoSaltEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        WSSConfig config = WSSConfig.getNewInstance();
        usernameToken.setID(config.getIdAllocator().createId("UsernameToken-", (Object)usernameToken));
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        usernameToken.addIteration(doc, 1000);
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)1000);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, usernameToken.getID());
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)usernameToken.getElement());
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on no salt element");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testNoIterationEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        WSSConfig config = WSSConfig.getNewInstance();
        usernameToken.setID(config.getIdAllocator().createId("UsernameToken-", (Object)usernameToken));
        byte[] salt = usernameToken.addSalt(doc, null, false);
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)1000);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, usernameToken.getID());
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)usernameToken.getElement());
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on no iteration element");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testLowIterationEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        WSSConfig config = WSSConfig.getNewInstance();
        usernameToken.setID(config.getIdAllocator().createId("UsernameToken-", (Object)usernameToken));
        usernameToken.addIteration(doc, 500);
        byte[] salt = usernameToken.addSalt(doc, null, false);
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)500);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, usernameToken.getID());
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)usernameToken.getElement());
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a low iteration value");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4218));
        WSSecurityEngine engine = new WSSecurityEngine();
        config.setAllowUsernameTokenNoPassword(true);
        engine.setWssConfig(config);
        engine.processSecurityHeader(doc, "", data);
    }

    @Test
    public void testBadValueType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(derivedKey, tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a bad value type");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setDecCrypto(this.crypto);
        WSSConfig config = WSSConfig.getNewInstance();
        config.setAllowUsernameTokenNoPassword(true);
        newEngine.setWssConfig(config);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4214));
        newEngine.processSecurityHeader(encryptedDoc, "", data);
    }

    @Test
    public void testKeyIdentifier() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, null, 1000);
        builder.prepare(doc);
        byte[] derivedKey = builder.getDerivedKey();
        UTDerivedKeyTest.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecurityTokenReference strEncKey = new SecurityTokenReference(doc);
        strEncKey.setKeyIdentifier("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken", tokenIdentifier, true);
        encrBuilder.setExternalKey(derivedKey, strEncKey.getElement());
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTDerivedKeyTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTDerivedKeyTest.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            UTDerivedKeyTest.fail((String)"Failure expected on a key identifier");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4215));
        WSSConfig config = WSSConfig.getNewInstance();
        config.setAllowUsernameTokenNoPassword(true);
        newEngine.setWssConfig(config);
        newEngine.processSecurityHeader(encryptedDoc, "", data);
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        return this.verify(doc, true);
    }

    private List<WSSecurityEngineResult> verify(Document doc, boolean allowUsernameTokenDerivedKeys) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig config = WSSConfig.getNewInstance();
        config.setAllowUsernameTokenNoPassword(allowUsernameTokenDerivedKeys);
        secEngine.setWssConfig(config);
        return secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
    }
}

