/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.PKIPathSecurity;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinarySecurityTokenTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(BinarySecurityTokenTest.class);
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testX509() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        X509Security bst = new X509Security(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        bst.setX509Certificate(certs[0]);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)bst.getElement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("BST output");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.setWssConfig(WSSConfig.getNewInstance());
        List results = secEngine.processSecurityHeader(doc, null, null, this.crypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)4096);
        BinarySecurity token = (BinarySecurity)actionResult.get((Object)"binary-security-token");
        BinarySecurityTokenTest.assertNotNull((Object)token);
        BinarySecurity clone = new BinarySecurity(token.getElement(), new BSPEnforcer(true));
        BinarySecurityTokenTest.assertTrue((boolean)clone.equals((Object)token));
        BinarySecurityTokenTest.assertTrue((clone.hashCode() == token.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testPKIPath() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        PKIPathSecurity bst = new PKIPathSecurity(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        bst.setX509Certificates(certs, this.crypto);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)bst.getElement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("PKIPath output");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.setWssConfig(WSSConfig.getNewInstance());
        List results = secEngine.processSecurityHeader(doc, null, null, this.crypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)4096);
        PKIPathSecurity token = (PKIPathSecurity)actionResult.get((Object)"binary-security-token");
        BinarySecurityTokenTest.assertNotNull((Object)token);
    }

    @Test
    public void testCustomToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        BinarySecurity bst = new BinarySecurity(doc);
        bst.setToken("12435677".getBytes());
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)bst.getElement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Custom Token output");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.setWssConfig(WSSConfig.getNewInstance());
        try {
            secEngine.processSecurityHeader(doc, null, null, this.crypto);
            BinarySecurityTokenTest.fail((String)"Expected failure on no ValueType");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        bst = new BinarySecurity(doc);
        bst.setToken("12435677".getBytes());
        bst.setValueType("http://custom_value_Type");
        secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)bst.getElement());
        List results = secEngine.processSecurityHeader(doc, null, null, this.crypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((List)results, (int)4096);
        BinarySecurity token = (BinarySecurity)actionResult.get((Object)"binary-security-token");
        BinarySecurityTokenTest.assertNotNull((Object)token);
    }
}

