/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.util.Collections;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.token.Reference;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityTokenReferenceTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityTokenReferenceTest.class);

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testReferenceNoURI() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        Reference ref = new Reference(doc);
        ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        ref.setURI(null);
        str.setReference(ref);
        if (LOG.isDebugEnabled()) {
            LOG.debug(str.toString());
        }
        Element strElement = str.getElement();
        try {
            new SecurityTokenReference(strElement, new BSPEnforcer(true));
            SecurityTokenReferenceTest.fail((String)"Failure expected on a reference with no URI");
        }
        catch (WSSecurityException ex) {
            SecurityTokenReferenceTest.assertTrue((boolean)ex.getMessage().contains("Reference URI is null"));
        }
    }

    @Test
    public void testMultipleChildren() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        str.setKeyIdentifierEncKeySHA1("123456");
        Element strElement = str.getElement();
        Reference ref = new Reference(doc);
        ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        ref.setURI("#123");
        strElement.appendChild(ref.getElement());
        if (LOG.isDebugEnabled()) {
            LOG.debug(str.toString());
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        try {
            new SecurityTokenReference(strElement, bspEnforcer);
            SecurityTokenReferenceTest.fail((String)"Failure expected on multiple data references");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        bspEnforcer.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3061));
        new SecurityTokenReference(strElement, bspEnforcer);
    }

    @Test
    public void testKeyIdentifierNoValueType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        str.setKeyIdentifier(null, "#123");
        Element strElement = str.getElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug(str.toString());
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        try {
            new SecurityTokenReference(strElement, bspEnforcer);
            SecurityTokenReferenceTest.fail((String)"Failure expected on a Key Identifier with no ValueType");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        bspEnforcer.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3054));
    }

    @Test
    public void testKeyIdentifierBadEncodingType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        Element strElement = str.getElement();
        Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        keyId.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1");
        keyId.setAttributeNS(null, "EncodingType", "http://bad_encoding");
        keyId.appendChild(doc.createTextNode("#123"));
        strElement.appendChild(keyId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(str.toString());
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        try {
            new SecurityTokenReference(strElement, bspEnforcer);
            SecurityTokenReferenceTest.fail((String)"Failure expected on a Key Identifier with a Bad EncodingType");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        bspEnforcer.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3071));
    }

    @Test
    public void testKeyIdentifierNoEncodingType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        Element strElement = str.getElement();
        Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        keyId.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1");
        keyId.appendChild(doc.createTextNode("#123"));
        strElement.appendChild(keyId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(str.toString());
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        try {
            new SecurityTokenReference(strElement, bspEnforcer);
            SecurityTokenReferenceTest.fail((String)"Failure expected on a Key Identifier with no EncodingType");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        bspEnforcer.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3070));
    }

    @Test
    public void testKeyIdentifierSAMLNoEncodingType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        Element strElement = str.getElement();
        Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        keyId.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        keyId.appendChild(doc.createTextNode("#123"));
        strElement.appendChild(keyId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(str.toString());
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        new SecurityTokenReference(strElement, bspEnforcer);
    }

    @Test
    public void testEmbeddedSTRChild() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        Element strElement = str.getElement();
        Element embedded = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Embedded");
        str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        embedded.appendChild(str.getElement());
        strElement.appendChild(embedded);
        if (LOG.isDebugEnabled()) {
            LOG.debug(DOM2Writer.nodeToString((Node)strElement));
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        try {
            new SecurityTokenReference(strElement, bspEnforcer);
            SecurityTokenReferenceTest.fail((String)"Failure expected on an Embedded Child with a SecurityTokenReference child");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        bspEnforcer.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3056));
    }

    @Test
    public void testMultipleEmbeddedChildren() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.addWSSENamespace();
        Element strElement = str.getElement();
        Element embedded = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Embedded");
        Element embedded1 = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        Element embedded2 = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        embedded.appendChild(embedded1);
        embedded.appendChild(embedded2);
        strElement.appendChild(embedded);
        if (LOG.isDebugEnabled()) {
            LOG.debug(DOM2Writer.nodeToString((Node)strElement));
        }
        BSPEnforcer bspEnforcer = new BSPEnforcer();
        try {
            new SecurityTokenReference(strElement, bspEnforcer);
            SecurityTokenReferenceTest.fail((String)"Failure expected on an Embedded Child with multiple children");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        bspEnforcer.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3060));
    }
}

