/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.misc;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.message.token.Reference;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FaultCodeTest
extends Assert
implements CallbackHandler {
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public FaultCodeTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testFailedCheck() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt(this.secEngine.getWssConfig());
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = builder.build(doc, this.crypto, secHeader);
        try {
            this.verify(encryptedDoc);
            FaultCodeTest.fail((String)"Failure expected with a bad password");
        }
        catch (WSSecurityException ex) {
            FaultCodeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            FaultCodeTest.assertEquals((Object)"The private key for the supplied alias does not exist in the keystore", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedCheck");
            FaultCodeTest.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testUnsupportedAlgorithm() throws Exception {
        try {
            this.secEngine.getWssConfig();
            WSSecurityUtil.getCipherInstance((String)"Bad Algorithm");
            FaultCodeTest.fail((String)"Failure expected on an unsupported algorithm");
        }
        catch (WSSecurityException ex) {
            FaultCodeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM ? 1 : 0) != 0);
            FaultCodeTest.assertEquals((Object)"unsupported key transport encryption algorithm: No such algorithm: Bad Algorithm", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UnsupportedAlgorithm");
            FaultCodeTest.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testMessageExpired() throws Exception {
        WSSecTimestamp builder = new WSSecTimestamp(this.secEngine.getWssConfig());
        builder.setTimeToLive(-1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document timestampedDoc = builder.build(doc, secHeader);
        try {
            this.verify(timestampedDoc);
            FaultCodeTest.fail((String)"Failure expected on an expired message");
        }
        catch (WSSecurityException ex) {
            FaultCodeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
            FaultCodeTest.assertEquals((Object)"Invalid timestamp: The security semantics of the message have expired", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "MessageExpired");
            FaultCodeTest.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testFailedAuthentication() throws Exception {
        WSSecUsernameToken builder = new WSSecUsernameToken(this.secEngine.getWssConfig());
        builder.addCreated();
        builder.addNonce();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document timestampedDoc = builder.build(doc, secHeader);
        try {
            this.verify(timestampedDoc);
            FaultCodeTest.fail((String)"Failure expected on a bad password");
        }
        catch (WSSecurityException ex) {
            FaultCodeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
            FaultCodeTest.assertEquals((Object)"The security token could not be authenticated or authorized", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication");
            FaultCodeTest.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testInvalidSecurityToken() throws Exception {
        WSSecUsernameToken builder = new WSSecUsernameToken(this.secEngine.getWssConfig());
        builder.addCreated();
        builder.addNonce();
        builder.setUserInfo(null, "security");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        builder.build(doc, secHeader);
        try {
            new UsernameToken(doc.getDocumentElement(), false, new BSPEnforcer());
            FaultCodeTest.fail((String)"Failure expected on an invalid security token");
        }
        catch (WSSecurityException ex) {
            FaultCodeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN ? 1 : 0) != 0);
            FaultCodeTest.assertEquals((Object)"Bad element, expected \"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}UsernameToken\" while got \"{http://schemas.xmlsoap.org/soap/envelope/}Envelope\"", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurityToken");
            FaultCodeTest.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testInvalidSecurity() throws Exception {
        try {
            new Reference((Element)null);
            FaultCodeTest.fail((String)"Failure expected on processing the security header");
        }
        catch (WSSecurityException ex) {
            FaultCodeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
            FaultCodeTest.assertEquals((Object)"<Reference> token could not be retrieved", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity");
            FaultCodeTest.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    private void verify(Document doc) throws Exception {
        this.secEngine.processSecurityHeader(doc, null, (CallbackHandler)this, this.crypto);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("securit");
        }
    }
}

