/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.saml.SignedSamlTokenHOKTest;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlReferenceTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SamlReferenceTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"crypto.properties");
    private Crypto trustCrypto = null;
    private Crypto issuerCrypto = null;
    private Crypto userCrypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SamlReferenceTest() throws Exception {
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidateSamlSubjectConfirmation(false);
        this.secEngine.setWssConfig(config);
        this.issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SignedSamlTokenHOKTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40_server.jks");
        keyStore.load(input, "security".toCharArray());
        ((Merlin)this.issuerCrypto).setKeyStore(keyStore);
        this.trustCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        ((Merlin)this.trustCrypto).setTrustStore(trustStore);
    }

    @Test
    public void testSAML1SVKeyIdentifier() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML message Key Identifier (sender vouches):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.crypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML1SVDirectReference() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        wsSign.setUseDirectReferenceToAssertion(true);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML message Direct Reference (sender vouches):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.crypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML1HOKKeyIdentifier() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML message Key Identifier (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.trustCrypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1HOKDirectReference() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setUseDirectReferenceToAssertion(true);
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML message Direct Reference (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.trustCrypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testAssertionBelowSTR() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Crypto crypto = CryptoFactory.getInstance((String)"crypto.properties");
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document samlDoc = wsSign.build(doc, null, samlAssertion, crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        builder.setKeyIdentifierType(1);
        Document encryptedDoc = builder.build(samlDoc, crypto, secHeader);
        Element secHeaderElement = secHeader.getSecurityHeader();
        Node assertionNode = secHeaderElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
        secHeaderElement.removeChild(assertionNode);
        secHeaderElement.appendChild(assertionNode);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message:");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        this.verify(encryptedDoc, crypto, crypto);
    }

    @Test
    public void testSAML1HOKEKKeyIdentifier() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        Element assertionNode = samlAssertion.toDOM(doc);
        secHeader.insertSecurityHeader(doc);
        secHeader.getSecurityHeader().appendChild(assertionNode);
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyIdentifierType(12);
        builder.setCustomEKTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        builder.setCustomEKTokenId(samlAssertion.getId());
        builder.prepare(doc, this.userCrypto);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        parts.add(encP);
        Element refElement = builder.encryptForRef(null, parts);
        builder.addInternalRefElement(refElement);
        builder.appendToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted SAML 1.1 message Key Identifier (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        List<WSSecurityEngineResult> results = this.verify(doc, this.trustCrypto, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body/add", (Object)xpath);
    }

    @Test
    public void testSAML1HOKEKDirectReference() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        Element assertionNode = samlAssertion.toDOM(doc);
        secHeader.insertSecurityHeader(doc);
        secHeader.getSecurityHeader().appendChild(assertionNode);
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyIdentifierType(9);
        builder.setCustomEKTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        builder.setCustomEKTokenId(samlAssertion.getId());
        builder.prepare(doc, this.userCrypto);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        parts.add(encP);
        Element refElement = builder.encryptForRef(null, parts);
        builder.addInternalRefElement(refElement);
        builder.appendToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted SAML 1.1 message Direct Reference (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        List<WSSecurityEngineResult> results = this.verify(doc, this.trustCrypto, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body/add", (Object)xpath);
    }

    @Test
    public void testSAML2SVKeyIdentifier() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML2 message Key Identifier (sender vouches):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.crypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml2:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML2SVDirectReference() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        wsSign.setUseDirectReferenceToAssertion(true);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML2 message Direct Reference (sender vouches):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertFalse((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.crypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml2:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML2HOKKeyIdentifier() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML2 message Key Identifier (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.trustCrypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2HOKDirectReference() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setUseDirectReferenceToAssertion(true);
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML2 message Direct Reference (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertFalse((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.trustCrypto, null);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2HOKEKKeyIdentifier() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        Element assertionNode = samlAssertion.toDOM(doc);
        secHeader.insertSecurityHeader(doc);
        secHeader.getSecurityHeader().appendChild(assertionNode);
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyIdentifierType(12);
        builder.setCustomEKTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        builder.setCustomEKTokenId(samlAssertion.getId());
        builder.prepare(doc, this.userCrypto);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        parts.add(encP);
        Element refElement = builder.encryptForRef(null, parts);
        builder.addInternalRefElement(refElement);
        builder.appendToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted SAML 2 message Key Identifier (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        List<WSSecurityEngineResult> results = this.verify(doc, this.trustCrypto, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body/add", (Object)xpath);
    }

    @Test
    public void testSAML2HOKEKDirectReference() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        Element assertionNode = samlAssertion.toDOM(doc);
        secHeader.insertSecurityHeader(doc);
        secHeader.getSecurityHeader().appendChild(assertionNode);
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyIdentifierType(9);
        builder.setCustomEKTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        builder.setCustomEKTokenId(samlAssertion.getId());
        builder.prepare(doc, this.userCrypto);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        parts.add(encP);
        Element refElement = builder.encryptForRef(null, parts);
        builder.addInternalRefElement(refElement);
        builder.appendToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted SAML 2 message Direct Reference (holder-of-key):");
            LOG.debug(outputString);
        }
        SamlReferenceTest.assertFalse((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        SamlReferenceTest.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        List<WSSecurityEngineResult> results = this.verify(doc, this.trustCrypto, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlReferenceTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlReferenceTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        SamlReferenceTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlReferenceTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlReferenceTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlReferenceTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body/add", (Object)xpath);
    }

    private List<WSSecurityEngineResult> verify(Document doc, Crypto verifyCrypto, Crypto decCrypto) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, verifyCrypto, decCrypto);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        SamlReferenceTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

