/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.CustomSamlAssertionValidator;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SAMLElementCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSAMLToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.Validator;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlTokenTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SamlTokenTest() {
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSSecurityEngine.SAML_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidator(WSSecurityEngine.SAML2_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidateSamlSubjectConfirmation(false);
        this.secEngine.setWssConfig(config);
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
        SamlTokenTest.assertTrue((receivedSamlAssertion.getSignatureValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSAML1AuthnAssertionViaElement() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAMLElementCallbackHandler callbackHandler = new SAMLElementCallbackHandler();
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches - from an Element):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
        SamlTokenTest.assertTrue((receivedSamlAssertion.getSignatureValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSAML1AttrAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Attr Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1AuthzAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHZ);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setResource("http://resource.org");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authz Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AttrAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Attr Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AuthzAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHZ);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setResource("http://resource.org");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authz Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSaml1Action() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, SAML1CallbackHandler> config = new TreeMap<String, SAML1CallbackHandler>();
        config.put("samlCallbackRef", new SAML1CallbackHandler());
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsigned SAML 1.1 authentication assertion via an Action:");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertFalse((boolean)outputString.contains("Signature"));
        List<WSSecurityEngineResult> results = this.verify(doc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1AuthnBadIssuerAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example2.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(unsignedDoc);
            SamlTokenTest.fail((String)"Failure expected on a bad issuer");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSAML2AuthnBadIssuerAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example2.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(unsignedDoc);
            SamlTokenTest.fail((String)"Failure expected on a bad issuer");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSAML1SubjectNameIDFormat() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectNameIDFormat() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1SubjectLocality() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality("12.34.56.780", "test-dns");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("12.34.56.780"));
        SamlTokenTest.assertTrue((boolean)outputString.contains("test-dns"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SessionNotOnOrAfter() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setSessionNotOnOrAfter(new DateTime().plusHours(1));
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2.0 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("SessionNotOnOrAfter"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectLocality() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality("12.34.56.780", "test-dns");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("12.34.56.780"));
        SamlTokenTest.assertTrue((boolean)outputString.contains("test-dns"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1Resource() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHZ);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setResource("http://resource.org");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authz Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("http://resource.org"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AttrAssertionCustomAttribute() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder conditionsV2Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsV2Builder.buildObject();
        DateTime newNotBefore = new DateTime();
        conditions.setNotBefore(newNotBefore);
        conditions.setNotOnOrAfter(newNotBefore.plusMinutes(5));
        XMLObjectBuilder xsAnyBuilder = builderFactory.getBuilder(XSAny.TYPE_NAME);
        XSAny attributeValue = (XSAny)xsAnyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        attributeValue.getUnknownXMLObjects().add(conditions);
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        attributeValues.add(attributeValue);
        callbackHandler.setCustomAttributeValues(attributeValues);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Attr Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AttrAssertionIntegerAttribute() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        XMLObjectBuilder xsIntegerBuilder = builderFactory.getBuilder(XSInteger.TYPE_NAME);
        XSInteger attributeValue = (XSInteger)xsIntegerBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSInteger.TYPE_NAME);
        attributeValue.setValue(Integer.valueOf(5));
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        attributeValues.add(attributeValue);
        callbackHandler.setCustomAttributeValues(attributeValues);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectConfirmationData() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
        subjectConfirmationData.setAddress("http://apache.org");
        subjectConfirmationData.setInResponseTo("12345");
        subjectConfirmationData.setNotAfter(new DateTime().plusMinutes(5));
        subjectConfirmationData.setRecipient("http://recipient.apache.org");
        callbackHandler.setSubjectConfirmationData(subjectConfirmationData);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        SamlTokenTest.assertTrue((boolean)outputString.contains("http://recipient.apache.org"));
        List<WSSecurityEngineResult> results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)8);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SamlTokenTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SamlTokenTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, null, null);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        SamlTokenTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

