/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml.ext;

import java.io.InputStream;
import java.security.KeyStore;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.opensaml.xml.signature.Signature;

public class AssertionSigningTest
extends Assert {
    private Crypto issuerCrypto = null;
    private final String defaultCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final String defaultRSASignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private final String defaultDSASignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private final String customSignatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private final String customCanonicalizationAlgorithm = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public AssertionSigningTest() throws Exception {
        WSSConfig.init();
        this.issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(AssertionSigningTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/client_keystore.jks");
        keyStore.load(input, "password".toCharArray());
        ((Merlin)this.issuerCrypto).setKeyStore(keyStore);
    }

    @Test
    public void testSigningWithDefaultAlgorithms() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("client_certchain", "password", this.issuerCrypto, false);
        Signature signature = samlAssertion.getSaml2().getSignature();
        Assert.assertTrue((signature.getSignatureAlgorithm().equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || signature.getSignatureAlgorithm().equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)signature.getCanonicalizationAlgorithm());
    }

    @Test
    public void testSigningWithCustomAlgorithms() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("client_certchain", "password", this.issuerCrypto, false, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Signature signature = samlAssertion.getSaml2().getSignature();
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Object)signature.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (Object)signature.getCanonicalizationAlgorithm());
    }
}

