/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.WSSecBase;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecSAMLToken
extends WSSecBase {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecSAMLToken.class);
    private Document document;
    private SamlAssertionWrapper saml;

    public WSSecSAMLToken() {
    }

    public WSSecSAMLToken(WSSConfig config) {
        super(config);
    }

    public void prepare(Document doc, SamlAssertionWrapper samlAssertion) {
        this.document = doc;
        this.saml = samlAssertion;
    }

    public void prependToHeader(WSSecHeader secHeader) {
        try {
            Element element = this.saml.toDOM(this.document);
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), element);
        }
        catch (WSSecurityException ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public String getId() {
        if (this.saml == null) {
            return null;
        }
        return this.saml.getId();
    }

    public Document build(Document doc, SamlAssertionWrapper samlAssertion, WSSecHeader secHeader) {
        LOG.debug("Begin add SAMLAssertion token...");
        this.prepare(doc, samlAssertion);
        this.prependToHeader(secHeader);
        return doc;
    }
}

