/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.util.Collections;
import java.util.List;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TimestampProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found Timestamp list element");
        }
        Timestamp timestamp = new Timestamp(elem, data.getBSPEnforcer());
        Credential credential = new Credential();
        credential.setTimestamp(timestamp);
        WSSecurityEngineResult result = new WSSecurityEngineResult(32, timestamp);
        result.put("id", timestamp.getID());
        Validator validator = data.getValidator(WSSecurityEngine.TIMESTAMP);
        if (validator != null) {
            validator.validate(credential, data);
            result.put("validated-token", Boolean.TRUE);
        }
        wsDocInfo.addTokenElement(elem);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }
}

