/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.WSSecBase;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecUsernameToken
extends WSSecBase {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecUsernameToken.class);
    private String passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private UsernameToken ut;
    private boolean nonce;
    private boolean created;
    private boolean useDerivedKey;
    private boolean useMac;
    private byte[] saltValue;
    private int iteration = 1000;
    private boolean passwordsAreEncoded;

    public WSSecUsernameToken() {
    }

    public WSSecUsernameToken(WSSConfig config) {
        super(config);
    }

    public void setPasswordType(String pwType) {
        this.passwordType = pwType;
    }

    public void addNonce() {
        this.nonce = true;
    }

    public void addCreated() {
        this.created = true;
    }

    public void addDerivedKey(boolean useMac, byte[] saltValue, int iteration) {
        this.passwordType = null;
        this.useDerivedKey = true;
        this.useMac = useMac;
        this.saltValue = saltValue;
        if (iteration > 0) {
            this.iteration = iteration;
        }
    }

    public byte[] getDerivedKey() throws WSSecurityException {
        if (this.ut == null || !this.useDerivedKey) {
            return null;
        }
        if (this.passwordsAreEncoded) {
            try {
                return UsernameTokenUtil.generateDerivedKey((byte[])Base64.decode((String)this.password), (byte[])this.saltValue, (int)this.iteration);
            }
            catch (Base64DecodingException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "decoding.general");
            }
        }
        return UsernameTokenUtil.generateDerivedKey((String)this.password, (byte[])this.saltValue, (int)this.iteration);
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public String getId() {
        if (this.ut == null) {
            return null;
        }
        return this.ut.getID();
    }

    public void prepare(Document doc) {
        this.ut = new UsernameToken(this.getWsConfig().isPrecisionInMilliSeconds(), doc, this.getWsConfig().getCurrentTime(), this.passwordType);
        this.ut.setPasswordsAreEncoded(this.passwordsAreEncoded);
        this.ut.setName(this.user);
        if (this.useDerivedKey) {
            this.saltValue = this.ut.addSalt(doc, this.saltValue, this.useMac);
            this.ut.addIteration(doc, this.iteration);
        } else {
            this.ut.setPassword(this.password);
        }
        if (this.nonce) {
            this.ut.addNonce(doc);
        }
        if (this.created) {
            this.ut.addCreated(this.getWsConfig().isPrecisionInMilliSeconds(), this.getWsConfig().getCurrentTime(), doc);
        }
        this.ut.setID(this.getWsConfig().getIdAllocator().createId("UsernameToken-", this.ut));
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.ut.getElement());
    }

    public void appendToHeader(WSSecHeader secHeader) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(this.ut.getElement());
    }

    public Document build(Document doc, WSSecHeader secHeader) {
        LOG.debug("Begin add username token...");
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }

    public Element getUsernameTokenElement() {
        return this.ut.getElement();
    }
}

