/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.dsig.Reference;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class UsernameTokenSignedAction
implements Action {
    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, Document doc, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = reqData.getCallbackHandler();
        if (callbackHandler == null) {
            callbackHandler = handler.getPasswordCallbackHandler(reqData);
        }
        WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getUsername(), 64, callbackHandler, reqData);
        WSSecUsernameToken builder = new WSSecUsernameToken(reqData.getWssConfig());
        int iterations = reqData.getDerivedKeyIterations();
        boolean useMac = reqData.isUseDerivedKeyForMAC();
        builder.addDerivedKey(useMac, null, iterations);
        builder.setUserInfo(reqData.getUsername(), passwordCallback.getPassword());
        builder.addCreated();
        builder.addNonce();
        builder.prepare(doc);
        SignatureActionToken signatureToken = null;
        if (actionToken instanceof SignatureActionToken) {
            signatureToken = (SignatureActionToken)actionToken;
        }
        if (signatureToken == null) {
            signatureToken = reqData.getSignatureToken();
        }
        WSSecSignature sign = new WSSecSignature(reqData.getWssConfig());
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        sign.setCustomTokenId(builder.getId());
        sign.setSecretKey(builder.getDerivedKey());
        sign.setKeyIdentifierType(9);
        if (signatureToken.getDigestAlgorithm() != null) {
            sign.setDigestAlgo(signatureToken.getDigestAlgorithm());
        }
        if (signatureToken.getSignatureAlgorithm() != null) {
            sign.setSignatureAlgorithm(signatureToken.getSignatureAlgorithm());
        } else {
            sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        }
        sign.prepare(doc, null, reqData.getSecHeader());
        ArrayList<WSEncryptionPart> parts = null;
        if (signatureToken.getParts().size() > 0) {
            parts = signatureToken.getParts();
        } else {
            SOAPConstants soapConstants = reqData.getSoapConstants();
            if (soapConstants == null) {
                soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
            }
            parts = new ArrayList<WSEncryptionPart>();
            WSEncryptionPart encP = new WSEncryptionPart("Body", soapConstants.getEnvelopeURI(), "Content");
            parts.add(encP);
        }
        List<Reference> referenceList = sign.addReferencesToSign((List<WSEncryptionPart>)parts, reqData.getSecHeader());
        try {
            sign.computeSignature(referenceList);
            reqData.getSignatureValues().add(sign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", (Exception)((Object)e), new Object[]{"WSHandler: Error during UsernameTokenSignature"});
        }
        builder.prependToHeader(reqData.getSecHeader());
    }
}

