/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.Reference;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.AttachmentUtils;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WsuIdAllocator;
import org.apache.wss4j.dom.message.CallbackLookup;
import org.apache.wss4j.dom.message.DOMCallbackLookup;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.TransformSerializer;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecEncrypt
extends WSSecEncryptedKey {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecEncrypt.class);
    private SecurityTokenReference securityTokenReference;
    private boolean encryptSymmKey = true;
    private String customReferenceValue;
    private boolean encKeyIdDirectId;
    private boolean embedEncryptedKey;
    private List<Element> attachmentEncryptedDataElements;

    @Override
    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        this.document = doc;
        this.attachmentEncryptedDataElements = new ArrayList<Element>();
        if (this.symmetricKey == null) {
            if (this.getEphemeralKey() != null) {
                this.symmetricKey = KeyUtils.prepareSecretKey((String)this.getSymmetricEncAlgorithm(), (byte[])this.getEphemeralKey());
            } else {
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)this.getSymmetricEncAlgorithm());
                this.symmetricKey = keyGen.generateKey();
            }
        }
        if (this.encryptSymmKey && this.encryptedEphemeralKey == null) {
            X509Certificate remoteCert = this.getUseThisCert();
            if (remoteCert == null) {
                CryptoType cryptoType = null;
                if (this.keyIdentifierType == 14) {
                    cryptoType = new CryptoType(CryptoType.TYPE.ENDPOINT);
                    cryptoType.setEndpoint(this.user);
                } else {
                    cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                    cryptoType.setAlias(this.user);
                }
                X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
                if (certs == null || certs.length <= 0) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noUserCertsFound", new Object[]{this.user, "encryption"});
                }
                remoteCert = certs[0];
            }
            this.prepareInternal(this.symmetricKey, remoteCert, crypto);
        } else if (this.encryptedEphemeralKey != null) {
            this.prepareInternal(this.symmetricKey);
        } else {
            this.encryptedEphemeralKey = this.symmetricKey.getEncoded();
        }
    }

    public Document build(Document doc, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = LOG.isDebugEnabled();
        this.prepare(doc, crypto);
        if (this.doDebug) {
            LOG.debug("Beginning Encryption...");
        }
        Element refs = this.encrypt();
        this.addAttachmentEncryptedDataElements(secHeader);
        if (this.getEncryptedKeyElement() != null) {
            this.addInternalRefElement(refs);
            this.prependToHeader(secHeader);
        } else {
            this.addExternalRefElement(refs, secHeader);
        }
        this.prependBSTElementToHeader(secHeader);
        this.clean();
        LOG.debug("Encryption complete.");
        return doc;
    }

    public Element encrypt() throws WSSecurityException {
        if (this.getParts().isEmpty()) {
            this.getParts().add(WSSecurityUtil.getDefaultEncryptionPart(this.document));
        }
        return this.encryptForRef(null, this.getParts());
    }

    public Element encryptForRef(Element dataRef, List<WSEncryptionPart> references) throws WSSecurityException {
        KeyInfo keyInfo = this.createKeyInfo();
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.symmetricKey.getEncoded(), this.symmetricKey.getAlgorithm());
        List<String> encDataRefs = WSSecEncrypt.doEncryption(this.document, this.getIdAllocator(), keyInfo, secretKeySpec, this.getSymmetricEncAlgorithm(), references, this.callbackLookup, this.attachmentCallbackHandler, this.attachmentEncryptedDataElements, this.storeBytesInAttachment);
        if (encDataRefs.isEmpty()) {
            return null;
        }
        if (dataRef == null) {
            dataRef = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
            if (!this.encryptSymmKey) {
                XMLUtils.setNamespace((Element)dataRef, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"xenc");
            }
        }
        return WSSecEncrypt.createDataRefList(this.document, dataRef, encDataRefs);
    }

    public void addInternalRefElement(Element dataRef) {
        if (dataRef != null) {
            this.getEncryptedKeyElement().appendChild(dataRef);
        }
    }

    public void addExternalRefElement(Element dataRef, WSSecHeader secHeader) {
        if (dataRef != null) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), dataRef);
        }
    }

    public void addAttachmentEncryptedDataElements(WSSecHeader secHeader) {
        if (this.attachmentEncryptedDataElements != null) {
            for (int i = 0; i < this.attachmentEncryptedDataElements.size(); ++i) {
                Element encryptedData = this.attachmentEncryptedDataElements.get(i);
                WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), encryptedData);
            }
        }
    }

    public static List<String> doEncryption(Document doc, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, List<WSEncryptionPart> references, CallbackLookup callbackLookup) throws WSSecurityException {
        return WSSecEncrypt.doEncryption(doc, idAllocator, keyInfo, secretKey, encryptionAlgorithm, references, callbackLookup, null, null, false);
    }

    public static List<String> doEncryption(Document doc, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, List<WSEncryptionPart> references, CallbackLookup callbackLookup, CallbackHandler attachmentCallbackHandler, List<Element> attachmentEncryptedDataElements, boolean storeBytesInAttachment) throws WSSecurityException {
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)encryptionAlgorithm);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
        ArrayList<String> encDataRef = new ArrayList<String>();
        WSEncryptionPart attachmentEncryptionPart = null;
        for (int part = 0; part < references.size(); ++part) {
            String id;
            List<Element> elementsToEncrypt;
            WSEncryptionPart encPart = references.get(part);
            if (encPart.getId() != null && encPart.getId().startsWith("cid:")) {
                attachmentEncryptionPart = encPart;
                continue;
            }
            if (callbackLookup == null) {
                callbackLookup = new DOMCallbackLookup(doc);
            }
            if ((elementsToEncrypt = WSSecurityUtil.findElements(encPart, callbackLookup, doc)) == null || elementsToEncrypt.size() == 0) {
                if (!encPart.isRequired()) continue;
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noEncElement", new Object[]{"{" + encPart.getNamespace() + "}" + encPart.getName()});
            }
            if (storeBytesInAttachment) {
                for (Element elementToEncrypt : elementsToEncrypt) {
                    try {
                        id = WSSecEncrypt.encryptElementInAttachment(doc, idAllocator, keyInfo, secretKey, encryptionAlgorithm, attachmentCallbackHandler, encPart, elementToEncrypt);
                        encPart.setEncId(id);
                        encDataRef.add("#" + id);
                    }
                    catch (Exception ex) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, ex);
                    }
                }
                continue;
            }
            for (Element elementToEncrypt : elementsToEncrypt) {
                id = WSSecEncrypt.encryptElement(doc, elementToEncrypt, encPart.getEncModifier(), idAllocator, xmlCipher, secretKey, keyInfo);
                encPart.setEncId(id);
                encDataRef.add("#" + id);
            }
        }
        if (attachmentEncryptionPart != null) {
            WSSecEncrypt.encryptAttachment(doc, idAllocator, keyInfo, secretKey, encryptionAlgorithm, attachmentCallbackHandler, attachmentEncryptionPart, encDataRef, attachmentEncryptedDataElements);
        }
        return encDataRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String encryptElementInAttachment(Document doc, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, CallbackHandler attachmentCallbackHandler, WSEncryptionPart encryptionPart, Element elementToEncrypt) throws Exception {
        String type = "http://www.w3.org/2001/04/xmlenc#Element";
        if ("Content".equals(encryptionPart.getEncModifier())) {
            type = "http://www.w3.org/2001/04/xmlenc#Content";
        }
        String attachmentId = idAllocator.createId("", doc);
        String encEncryptedDataId = idAllocator.createId("ED-", attachmentId);
        if ("Header".equals(encryptionPart.getEncModifier()) && elementToEncrypt.getParentNode().equals(WSSecurityUtil.getSOAPHeader(doc))) {
            WSSecEncrypt.createEncryptedHeaderElement(doc, elementToEncrypt, idAllocator);
        }
        Element encryptedData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedData");
        encryptedData.setAttributeNS(null, "Id", encEncryptedDataId);
        encryptedData.setAttributeNS(null, "Type", type);
        Element encryptionMethod = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethod.setAttributeNS(null, "Algorithm", encryptionAlgorithm);
        encryptedData.appendChild(encryptionMethod);
        encryptedData.appendChild(keyInfo.getElement());
        Element cipherData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValue = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherData.appendChild(cipherValue);
        encryptedData.appendChild(cipherData);
        Cipher cipher = WSSecEncrypt.createCipher(encryptionAlgorithm, secretKey);
        TransformSerializer serializer = new TransformSerializer();
        serializer.setCanonicalizer(Canonicalizer.getInstance((String)"http://santuario.apache.org/c14n/physical"));
        serializer.setSecureValidation(true);
        byte[] serializedOctets = null;
        if (type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            NodeList children = elementToEncrypt.getChildNodes();
            if (null == children) throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, "Element has no content.");
            serializedOctets = serializer.serializeToByteArray(children);
        } else {
            serializedOctets = serializer.serializeToByteArray(elementToEncrypt);
        }
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = cipher.doFinal(serializedOctets);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, (Exception)ibse);
        }
        catch (BadPaddingException bpe) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, (Exception)bpe);
        }
        byte[] iv = cipher.getIV();
        byte[] finalEncryptedBytes = new byte[iv.length + encryptedBytes.length];
        System.arraycopy(iv, 0, finalEncryptedBytes, 0, iv.length);
        System.arraycopy(encryptedBytes, 0, finalEncryptedBytes, iv.length, encryptedBytes.length);
        if ("Content".equals(encryptionPart.getEncModifier())) {
            Node child = elementToEncrypt.getFirstChild();
            while (child != null) {
                Node sibling = child.getNextSibling();
                elementToEncrypt.removeChild(child);
                child = sibling;
            }
            elementToEncrypt.appendChild(encryptedData);
        } else {
            elementToEncrypt.getParentNode().replaceChild(encryptedData, elementToEncrypt);
        }
        WSSecurityUtil.storeBytesInAttachment(cipherValue, doc, attachmentId, finalEncryptedBytes, attachmentCallbackHandler);
        return encEncryptedDataId;
    }

    private static void encryptAttachment(Document doc, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, CallbackHandler attachmentCallbackHandler, WSEncryptionPart attachmentEncryptionPart, List<String> encDataRef, List<Element> attachmentEncryptedDataElements) throws WSSecurityException {
        if (attachmentCallbackHandler == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"no attachment callbackhandler supplied"});
        }
        AttachmentRequestCallback attachmentRequestCallback = new AttachmentRequestCallback();
        String id = attachmentEncryptionPart.getId().substring(4);
        attachmentRequestCallback.setAttachmentId(id);
        try {
            attachmentCallbackHandler.handle(new Callback[]{attachmentRequestCallback});
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, e);
        }
        String attachmentEncryptedDataType = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only";
        if ("Element".equals(attachmentEncryptionPart.getEncModifier())) {
            attachmentEncryptedDataType = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete";
        }
        for (Attachment attachment : attachmentRequestCallback.getAttachments()) {
            String attachmentId = attachment.getId();
            String encEncryptedDataId = idAllocator.createId("ED-", attachmentId);
            encDataRef.add("#" + encEncryptedDataId);
            Element encryptedData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedData");
            encryptedData.setAttributeNS(null, "Id", encEncryptedDataId);
            encryptedData.setAttributeNS(null, "MimeType", attachment.getMimeType());
            encryptedData.setAttributeNS(null, "Type", attachmentEncryptedDataType);
            Element encryptionMethod = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
            encryptionMethod.setAttributeNS(null, "Algorithm", encryptionAlgorithm);
            encryptedData.appendChild(encryptionMethod);
            encryptedData.appendChild(keyInfo.getElement());
            Element cipherData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
            Element cipherReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherReference");
            cipherReference.setAttributeNS(null, "URI", "cid:" + attachmentId);
            Element transforms = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:Transforms");
            Element transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
            transform.setAttributeNS(null, "Algorithm", "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform");
            transforms.appendChild(transform);
            cipherReference.appendChild(transforms);
            cipherData.appendChild(cipherReference);
            encryptedData.appendChild(cipherData);
            attachmentEncryptedDataElements.add(encryptedData);
            Attachment resultAttachment = new Attachment();
            resultAttachment.setId(attachmentId);
            resultAttachment.setMimeType("application/octet-stream");
            Cipher cipher = WSSecEncrypt.createCipher(encryptionAlgorithm, secretKey);
            HashMap headers = new HashMap(attachment.getHeaders());
            resultAttachment.setSourceStream(AttachmentUtils.setupAttachmentEncryptionStream((Cipher)cipher, (boolean)"Element".equals(attachmentEncryptionPart.getEncModifier()), (Attachment)attachment, headers));
            resultAttachment.addHeaders(headers);
            AttachmentResultCallback attachmentResultCallback = new AttachmentResultCallback();
            attachmentResultCallback.setAttachmentId(attachmentId);
            attachmentResultCallback.setAttachment(resultAttachment);
            try {
                attachmentCallbackHandler.handle(new Callback[]{attachmentResultCallback});
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, e);
            }
        }
    }

    private static Cipher createCipher(String encryptionAlgorithm, SecretKey secretKey) throws WSSecurityException {
        String jceAlgorithm = JCEMapper.translateURItoJCEID((String)encryptionAlgorithm);
        try {
            Cipher cipher = Cipher.getInstance(jceAlgorithm);
            if ("http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(encryptionAlgorithm) || "http://www.w3.org/2009/xmlenc11#aes192-gcm".equals(encryptionAlgorithm) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(encryptionAlgorithm)) {
                byte[] iv = WSSecurityUtil.generateNonce(12);
                IvParameterSpec paramSpec = new IvParameterSpec(iv);
                cipher.init(1, (Key)secretKey, paramSpec);
            } else {
                cipher.init(1, secretKey);
            }
            return cipher;
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, e);
        }
    }

    private static String encryptElement(Document doc, Element elementToEncrypt, String modifier, WsuIdAllocator idAllocator, XMLCipher xmlCipher, SecretKey secretKey, KeyInfo keyInfo) throws WSSecurityException {
        boolean content = "Content".equals(modifier);
        String xencEncryptedDataId = idAllocator.createId("ED-", elementToEncrypt);
        try {
            if ("Header".equals(modifier) && elementToEncrypt.getParentNode().equals(WSSecurityUtil.getSOAPHeader(doc))) {
                WSSecEncrypt.createEncryptedHeaderElement(doc, elementToEncrypt, idAllocator);
            }
            xmlCipher.init(1, (Key)secretKey);
            EncryptedData encData = xmlCipher.getEncryptedData();
            encData.setId(xencEncryptedDataId);
            encData.setKeyInfo(keyInfo);
            xmlCipher.doFinal(doc, elementToEncrypt, content);
            return xencEncryptedDataId;
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, ex);
        }
    }

    private static void createEncryptedHeaderElement(Document doc, Element elementToEncrypt, WsuIdAllocator idAllocator) {
        Element elem = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:EncryptedHeader");
        XMLUtils.setNamespace((Element)elem, (String)"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", (String)"wsse11");
        String wsuPrefix = XMLUtils.setNamespace((Element)elem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"wsu");
        String headerId = idAllocator.createId("EH-", elementToEncrypt);
        elem.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", headerId);
        Node parent = elementToEncrypt.getParentNode();
        elementToEncrypt = (Element)parent.replaceChild(elem, elementToEncrypt);
        elem.appendChild(elementToEncrypt);
        NamedNodeMap map = elementToEncrypt.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            if (!attr.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !attr.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) continue;
            String soapEnvPrefix = XMLUtils.setNamespace((Element)elem, (String)attr.getNamespaceURI(), (String)"soapenv");
            elem.setAttributeNS(attr.getNamespaceURI(), soapEnvPrefix + ":" + attr.getLocalName(), attr.getValue());
        }
    }

    private KeyInfo createKeyInfo() throws WSSecurityException {
        SecurityTokenReference secToken;
        KeyInfo keyInfo = new KeyInfo(this.document);
        if (this.embedEncryptedKey) {
            keyInfo.addUnknownElement(this.getEncryptedKeyElement());
        } else if (this.keyIdentifierType == 10) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            if (this.customReferenceValue != null) {
                secToken.setKeyIdentifierEncKeySHA1(this.customReferenceValue);
            } else {
                byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.encryptedEphemeralKey);
                secToken.setKeyIdentifierEncKeySHA1(Base64.encode((byte[])encodedBytes));
            }
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            secToken.setKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", this.getId());
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            secToken.setKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", this.getId());
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
            secToken.setKeyIdentifier(this.customReferenceValue, this.getId(), true);
            keyInfo.addUnknownElement(secToken.getElement());
        } else if (this.securityTokenReference != null) {
            Element tmpE = this.securityTokenReference.getElement();
            tmpE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tmpE.getPrefix(), tmpE.getNamespaceURI());
            keyInfo.addUnknownElement(this.securityTokenReference.getElement());
        } else if (this.getId() != null) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            Reference ref = new Reference(this.document);
            if (this.encKeyIdDirectId) {
                ref.setURI(this.getId());
            } else {
                ref.setURI("#" + this.getId());
            }
            if (this.customReferenceValue != null) {
                ref.setValueType(this.customReferenceValue);
            }
            secToken.setReference(ref);
            if (KerberosSecurity.isKerberosToken(this.customReferenceValue)) {
                secToken.addTokenType(this.customReferenceValue);
            } else if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(this.customReferenceValue)) {
                secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            }
            keyInfo.addUnknownElement(secToken.getElement());
        } else if (!this.encryptSymmKey && this.keyIdentifierType == 2) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            if (this.customReferenceValue != null) {
                secToken.setKeyIdentifierEncKeySHA1(this.customReferenceValue);
            } else {
                byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.encryptedEphemeralKey);
                secToken.setKeyIdentifierEncKeySHA1(Base64.encode((byte[])encodedBytes));
            }
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            keyInfo.addUnknownElement(secToken.getElement());
        }
        Element keyInfoElement = keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        return keyInfo;
    }

    public static Element createDataRefList(Document doc, Element referenceList, List<String> encDataRefs) {
        for (String dataReferenceUri : encDataRefs) {
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        return referenceList;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReference = reference;
    }

    public boolean isEncryptSymmKey() {
        return this.encryptSymmKey;
    }

    public void setEncryptSymmKey(boolean encryptSymmKey) {
        this.encryptSymmKey = encryptSymmKey;
    }

    public void setCustomReferenceValue(String customReferenceValue) {
        this.customReferenceValue = customReferenceValue;
    }

    public void setEncKeyIdDirectId(boolean b) {
        this.encKeyIdDirectId = b;
    }

    public void setEmbedEncryptedKey(boolean embedEncryptedKey) {
        this.embedEncryptedKey = embedEncryptedKey;
    }

    public boolean isEmbedEncryptedKey() {
        return this.embedEncryptedKey;
    }

    public List<Element> getAttachmentEncryptedDataElements() {
        return this.attachmentEncryptedDataElements;
    }
}

