/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.EncryptedParts;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.EncryptedPartSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class EncryptedPartsAssertionState
extends AssertionState
implements Assertable {
    public EncryptedPartsAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.EncryptedPart};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        EncryptedPartSecurityEvent encryptedPartSecurityEvent = (EncryptedPartSecurityEvent)securityEvent;
        EncryptedParts encryptedParts = (EncryptedParts)this.getAssertion();
        if (encryptedParts.isBody() && WSSUtils.isInSOAPBody((List)encryptedPartSecurityEvent.getElementPath())) {
            if (encryptedPartSecurityEvent.isEncrypted()) {
                this.setAsserted(true);
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("SOAP-Body must be encrypted");
            return false;
        }
        for (int i = 0; i < encryptedParts.getHeaders().size(); ++i) {
            Header header = (Header)encryptedParts.getHeaders().get(i);
            QName headerQName = new QName(header.getNamespace(), header.getName() == null ? "" : header.getName());
            LinkedList<QName> header11Path = new LinkedList<QName>();
            header11Path.addAll(WSSConstants.SOAP_11_HEADER_PATH);
            header11Path.add(headerQName);
            if (!WSSUtils.pathMatches(header11Path, (List)encryptedPartSecurityEvent.getElementPath(), (boolean)true, (header.getName() == null ? 1 : 0) != 0)) continue;
            if (encryptedPartSecurityEvent.isEncrypted()) {
                this.setAsserted(true);
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("Element " + WSSUtils.pathAsString((List)encryptedPartSecurityEvent.getElementPath()) + " must be encrypted");
            return false;
        }
        return true;
    }
}

