/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.RequiredElements;
import org.apache.wss4j.policy.model.XPath;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.policy.stax.PolicyUtils;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.RequiredElementSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class RequiredElementsAssertionState
extends AssertionState
implements Assertable {
    private final Map<List<QName>, Boolean> pathElements = new HashMap<List<QName>, Boolean>();

    public RequiredElementsAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
        if (assertion instanceof RequiredElements) {
            RequiredElements requiredElements = (RequiredElements)assertion;
            for (int i = 0; i < requiredElements.getXPaths().size(); ++i) {
                XPath xPath = (XPath)requiredElements.getXPaths().get(i);
                List<QName> elements = PolicyUtils.getElementPath(xPath);
                this.pathElements.put(elements, Boolean.FALSE);
            }
        }
    }

    public void addElement(List<QName> pathElement) {
        this.pathElements.put(pathElement, Boolean.FALSE);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.RequiredElement};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        RequiredElementSecurityEvent requiredElementSecurityEvent = (RequiredElementSecurityEvent)securityEvent;
        for (Map.Entry<List<QName>, Boolean> next : this.pathElements.entrySet()) {
            List<QName> qNameList = next.getKey();
            if (!WSSUtils.pathMatches(qNameList, (List)requiredElementSecurityEvent.getElementPath(), (boolean)true, (boolean)false)) continue;
            next.setValue(Boolean.TRUE);
            break;
        }
        return true;
    }

    @Override
    public boolean isAsserted() {
        this.clearErrorMessage();
        for (Map.Entry<List<QName>, Boolean> next : this.pathElements.entrySet()) {
            if (!Boolean.FALSE.equals(next.getValue())) continue;
            this.setErrorMessage("Element " + WSSUtils.pathAsString(next.getKey()) + " must be present");
            return false;
        }
        return true;
    }
}

