/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.SamlToken;
import org.apache.wss4j.policy.stax.assertionStates.TokenAssertionState;
import org.apache.wss4j.stax.securityEvent.SamlTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.SamlSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.opensaml.common.SAMLVersion;

public class SamlTokenAssertionState
extends TokenAssertionState {
    public SamlTokenAssertionState(AbstractSecurityAssertion assertion, boolean asserted, boolean initiator) {
        super(assertion, asserted, initiator);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.SamlToken};
    }

    @Override
    public boolean assertToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, AbstractToken abstractToken) throws WSSPolicyException, XMLSecurityException {
        if (!(tokenSecurityEvent instanceof SamlTokenSecurityEvent)) {
            throw new WSSPolicyException("Expected a SamlTokenSecurityEvent but got " + tokenSecurityEvent.getClass().getName());
        }
        SamlTokenSecurityEvent samlTokenSecurityEvent = (SamlTokenSecurityEvent)tokenSecurityEvent;
        SamlToken samlToken = (SamlToken)abstractToken;
        if (samlToken.getIssuerName() != null && !samlToken.getIssuerName().equals(samlTokenSecurityEvent.getIssuerName())) {
            this.setErrorMessage("IssuerName in Policy (" + samlToken.getIssuerName() + ") didn't match with the one in the SamlToken (" + samlTokenSecurityEvent.getIssuerName() + ")");
            return false;
        }
        if (samlToken.isRequireKeyIdentifierReference() && !WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier.equals((Object)((SamlSecurityToken)samlTokenSecurityEvent.getSecurityToken()).getKeyIdentifier())) {
            this.setErrorMessage("Policy enforces KeyIdentifierReference but we got " + ((SamlSecurityToken)samlTokenSecurityEvent.getSecurityToken()).getTokenType());
            return false;
        }
        if (samlToken.getSamlTokenType() != null) {
            SamlAssertionWrapper samlAssertionWrapper = samlTokenSecurityEvent.getSamlAssertionWrapper();
            switch (samlToken.getSamlTokenType()) {
                case WssSamlV11Token10: {
                    if (samlAssertionWrapper.getSamlVersion() == SAMLVersion.VERSION_11) break;
                    this.setErrorMessage("Policy enforces SamlVersion11Profile10 but we got " + samlAssertionWrapper.getSamlVersion());
                    return false;
                }
                case WssSamlV11Token11: {
                    if (samlAssertionWrapper.getSamlVersion() == SAMLVersion.VERSION_11) break;
                    this.setErrorMessage("Policy enforces SamlVersion11Profile11 but we got " + samlAssertionWrapper.getSamlVersion());
                    return false;
                }
                case WssSamlV20Token11: {
                    if (samlAssertionWrapper.getSamlVersion() == SAMLVersion.VERSION_20) break;
                    this.setErrorMessage("Policy enforces SamlVersion20Profile11 but we got " + samlAssertionWrapper.getSamlVersion());
                    return false;
                }
                case WssSamlV10Token10: 
                case WssSamlV10Token11: {
                    this.setErrorMessage("Unsupported token type: " + samlToken.getSamlTokenType());
                    return false;
                }
            }
        }
        return true;
    }
}

