/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.stax.assertionStates.TokenAssertionState;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.securityEvent.UsernameTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.UsernameSecurityToken;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class UsernameTokenAssertionState
extends TokenAssertionState {
    public UsernameTokenAssertionState(AbstractSecurityAssertion assertion, boolean asserted, boolean initiator) {
        super(assertion, asserted, initiator);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.UsernameToken};
    }

    @Override
    public boolean assertToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, AbstractToken abstractToken) throws WSSPolicyException, XMLSecurityException {
        if (!(tokenSecurityEvent instanceof UsernameTokenSecurityEvent)) {
            throw new WSSPolicyException("Expected a UsernameSecurityTokenEvent but got " + tokenSecurityEvent.getClass().getName());
        }
        UsernameSecurityToken usernameSecurityToken = (UsernameSecurityToken)tokenSecurityEvent.getSecurityToken();
        UsernameTokenSecurityEvent usernameTokenSecurityEvent = (UsernameTokenSecurityEvent)tokenSecurityEvent;
        UsernameToken usernameToken = (UsernameToken)abstractToken;
        if (usernameToken.getPasswordType() != null) {
            switch (usernameToken.getPasswordType()) {
                case NoPassword: {
                    if (usernameTokenSecurityEvent.getUsernameTokenPasswordType() == WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE) break;
                    this.setErrorMessage("UsernameToken contains a password but the policy prohibits it");
                    return false;
                }
                case HashPassword: {
                    if (usernameTokenSecurityEvent.getUsernameTokenPasswordType() == WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST) break;
                    this.setErrorMessage("UsernameToken does not contain a hashed password");
                    return false;
                }
            }
        } else {
            if (usernameTokenSecurityEvent.getUsernameTokenPasswordType() == WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE) {
                this.setErrorMessage("UsernameToken must contain a password");
                return false;
            }
            if (usernameTokenSecurityEvent.getUsernameTokenPasswordType() == WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST) {
                this.setErrorMessage("UsernameToken password must not be hashed");
                return false;
            }
        }
        if (usernameToken.isCreated() && (usernameSecurityToken.getCreatedTime() == null || usernameTokenSecurityEvent.getUsernameTokenPasswordType() != WSSConstants.UsernameTokenPasswordType.PASSWORD_TEXT)) {
            this.setErrorMessage("UsernameToken does not contain a created timestamp or password is not plain text");
            return false;
        }
        if (usernameToken.isNonce() && (usernameSecurityToken.getNonce() == null || usernameTokenSecurityEvent.getUsernameTokenPasswordType() != WSSConstants.UsernameTokenPasswordType.PASSWORD_TEXT)) {
            this.setErrorMessage("UsernameToken does not contain a nonce or password is not plain text");
            return false;
        }
        if (usernameToken.getUsernameTokenType() != null && usernameTokenSecurityEvent.getUsernameTokenProfile() != null) {
            switch (usernameToken.getUsernameTokenType()) {
                case WssUsernameToken10: {
                    if (!usernameTokenSecurityEvent.getUsernameTokenProfile().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0")) break;
                    this.setErrorMessage("Policy enforces UsernameToken profile 1.0 but we got 1.1");
                    return false;
                }
                case WssUsernameToken11: {
                    if (usernameTokenSecurityEvent.getUsernameTokenProfile().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0")) break;
                    this.setErrorMessage("Policy enforces UsernameToken profile 1.1 but we got 1.0");
                    return false;
                }
            }
        }
        return true;
    }
}

