/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.builders.PrimitiveAssertion;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.ContentEncryptedElements;
import org.apache.wss4j.policy.model.EncryptedElements;
import org.apache.wss4j.policy.model.EncryptedParts;
import org.apache.wss4j.policy.model.HttpsToken;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.KerberosToken;
import org.apache.wss4j.policy.model.KeyValueToken;
import org.apache.wss4j.policy.model.RelToken;
import org.apache.wss4j.policy.model.RequiredElements;
import org.apache.wss4j.policy.model.RequiredParts;
import org.apache.wss4j.policy.model.SamlToken;
import org.apache.wss4j.policy.model.SecureConversationToken;
import org.apache.wss4j.policy.model.SecurityContextToken;
import org.apache.wss4j.policy.model.SignedElements;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.model.SpnegoContextToken;
import org.apache.wss4j.policy.model.SupportingTokens;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.model.Wss11;
import org.apache.wss4j.policy.model.X509Token;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.policy.stax.OperationPolicy;
import org.apache.wss4j.policy.stax.PolicyViolationException;
import org.apache.wss4j.policy.stax.assertionStates.AlgorithmSuiteAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.ContentEncryptedElementsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.EncryptedElementsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.EncryptedPartsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.HttpsTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.IncludeTimeStampAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.IssuedTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.KerberosTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.KeyValueTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.OnlySignEntireHeadersAndBodyAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.ProtectionOrderAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.RelTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.RequiredElementsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.RequiredPartsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SamlTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SecureConversationTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SecurityContextTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SignatureConfirmationAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SignatureProtectionAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SignedElementsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SignedPartsAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.SpnegoContextTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.TokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.TokenProtectionAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.UsernameTokenAssertionState;
import org.apache.wss4j.policy.stax.assertionStates.X509TokenAssertionState;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.securityEvent.NoSecuritySecurityEvent;
import org.apache.wss4j.stax.securityEvent.OperationSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEnforcer
implements SecurityEventListener {
    protected static final transient Logger log = LoggerFactory.getLogger(PolicyEnforcer.class);
    private static final QName SOAP11_FAULT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final QName SOAP12_FAULT = new QName("http://www.w3.org/2003/05/soap-envelope", "Fault");
    private final List<OperationPolicy> operationPolicies;
    private OperationPolicy effectivePolicy;
    private final List<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> assertionStateMap;
    private final List<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> failedAssertionStateMap;
    private final Deque<SecurityEvent> securityEventQueue = new LinkedList<SecurityEvent>();
    private boolean operationSecurityEventOccured = false;
    private boolean initiator;
    private String actorOrRole;
    private int attachmentCount;
    private boolean noSecurityHeader;
    private boolean faultOccurred;

    public PolicyEnforcer(List<OperationPolicy> operationPolicies, String soapAction, boolean initiator, String actorOrRole, int attachmentCount) throws WSSPolicyException {
        this.operationPolicies = operationPolicies;
        this.initiator = initiator;
        this.actorOrRole = actorOrRole;
        this.attachmentCount = attachmentCount;
        this.assertionStateMap = new LinkedList<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>>();
        this.failedAssertionStateMap = new LinkedList<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>>();
        if (soapAction != null && !soapAction.isEmpty()) {
            this.effectivePolicy = this.findPolicyBySOAPAction(operationPolicies, soapAction);
            if (this.effectivePolicy != null) {
                this.buildAssertionStateMap((PolicyComponent)this.effectivePolicy.getPolicy(), this.assertionStateMap);
            }
        }
    }

    private OperationPolicy findPolicyBySOAPAction(List<OperationPolicy> operationPolicies, String soapAction) {
        for (OperationPolicy operationPolicy : operationPolicies) {
            if (!soapAction.equals(operationPolicy.getOperationAction())) continue;
            return operationPolicy;
        }
        return null;
    }

    private OperationPolicy findPolicyBySOAPOperationName(List<OperationPolicy> operationPolicies, String soapOperationName) {
        for (OperationPolicy operationPolicy : operationPolicies) {
            if (!soapOperationName.equals(operationPolicy.getOperationName())) continue;
            return operationPolicy;
        }
        return null;
    }

    private void buildAssertionStateMap(PolicyComponent policyComponent, List<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> assertionStateMap) throws WSSPolicyException {
        if (policyComponent instanceof PolicyOperator) {
            PolicyOperator policyOperator = (PolicyOperator)policyComponent;
            List policyComponents = policyOperator.getPolicyComponents();
            int alternative = 0;
            for (PolicyComponent curPolicyComponent : policyComponents) {
                if (policyOperator instanceof ExactlyOne) {
                    assertionStateMap.add(new HashMap());
                    this.buildAssertionStateMap(curPolicyComponent, assertionStateMap, alternative++);
                    continue;
                }
                this.buildAssertionStateMap(curPolicyComponent, assertionStateMap);
            }
        } else {
            throw new WSSPolicyException("Invalid PolicyComponent: " + policyComponent + " " + policyComponent.getType());
        }
    }

    private void buildAssertionStateMap(PolicyComponent policyComponent, List<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> assertionStateMap, int alternative) throws WSSPolicyException {
        if (policyComponent instanceof PolicyOperator) {
            PolicyOperator policyOperator = (PolicyOperator)policyComponent;
            List policyComponents = policyOperator.getPolicyComponents();
            for (PolicyComponent curPolicyComponent : policyComponents) {
                this.buildAssertionStateMap(curPolicyComponent, assertionStateMap, alternative);
            }
        } else if (policyComponent instanceof AbstractSecurityAssertion) {
            AbstractSecurityAssertion abstractSecurityAssertion = (AbstractSecurityAssertion)policyComponent;
            List<Assertable> assertablesList = this.getAssertableForAssertion(abstractSecurityAssertion);
            for (Assertable assertable : assertablesList) {
                Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> map = assertionStateMap.get(alternative);
                SecurityEventConstants.Event[] securityEventType = assertable.getSecurityEventType();
                for (int j = 0; j < securityEventType.length; ++j) {
                    SecurityEventConstants.Event event = securityEventType[j];
                    Map<Assertion, List<Assertable>> assertables = map.get(event);
                    if (assertables == null) {
                        assertables = new HashMap<Assertion, List<Assertable>>();
                        map.put(event, assertables);
                    }
                    this.addAssertionState(assertables, (Assertion)abstractSecurityAssertion, assertable);
                }
            }
            if (abstractSecurityAssertion instanceof PolicyContainingAssertion) {
                this.buildAssertionStateMap((PolicyComponent)((PolicyContainingAssertion)abstractSecurityAssertion).getPolicy(), assertionStateMap, alternative);
            }
        } else if (!(policyComponent instanceof PrimitiveAssertion)) {
            throw new WSSPolicyException("Unsupported PolicyComponent: " + policyComponent + " type: " + policyComponent.getType());
        }
    }

    private void addAssertionState(Map<Assertion, List<Assertable>> assertables, Assertion keyAssertion, Assertable assertable) {
        List<Assertable> assertableList = assertables.get(keyAssertion);
        if (assertableList == null) {
            assertableList = new LinkedList<Assertable>();
            assertables.put(keyAssertion, assertableList);
        }
        assertableList.add(assertable);
    }

    protected List<Assertable> getAssertableForAssertion(AbstractSecurityAssertion abstractSecurityAssertion) throws WSSPolicyException {
        LinkedList<Assertable> assertableList = new LinkedList<Assertable>();
        if (abstractSecurityAssertion instanceof AbstractToken) {
            SPConstants.IncludeTokenType includeTokenType = ((AbstractToken)abstractSecurityAssertion).getIncludeTokenType();
            if (includeTokenType == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
                return assertableList;
            }
            if (this.initiator && includeTokenType == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT) {
                return assertableList;
            }
            if (this.initiator && includeTokenType == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE) {
                return assertableList;
            }
            if (!this.initiator && includeTokenType == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR) {
                return assertableList;
            }
        }
        if (abstractSecurityAssertion instanceof ContentEncryptedElements) {
            assertableList.add(new ContentEncryptedElementsAssertionState(abstractSecurityAssertion, true));
        } else if (abstractSecurityAssertion instanceof EncryptedParts) {
            assertableList.add(new EncryptedPartsAssertionState(abstractSecurityAssertion, true, this.attachmentCount));
        } else if (abstractSecurityAssertion instanceof EncryptedElements) {
            assertableList.add(new EncryptedElementsAssertionState(abstractSecurityAssertion, true));
        } else if (abstractSecurityAssertion instanceof SignedParts) {
            assertableList.add(new SignedPartsAssertionState(abstractSecurityAssertion, true, this.attachmentCount));
        } else if (abstractSecurityAssertion instanceof SignedElements) {
            assertableList.add(new SignedElementsAssertionState(abstractSecurityAssertion, true));
        } else if (abstractSecurityAssertion instanceof RequiredElements) {
            assertableList.add(new RequiredElementsAssertionState(abstractSecurityAssertion, false));
        } else if (abstractSecurityAssertion instanceof RequiredParts) {
            assertableList.add(new RequiredPartsAssertionState(abstractSecurityAssertion, false));
        } else if (abstractSecurityAssertion instanceof UsernameToken) {
            assertableList.add(new UsernameTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof IssuedToken) {
            assertableList.add(new IssuedTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof X509Token) {
            assertableList.add(new X509TokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof KerberosToken) {
            assertableList.add(new KerberosTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof SpnegoContextToken) {
            assertableList.add(new SpnegoContextTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof SecureConversationToken) {
            assertableList.add(new SecureConversationTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof SecurityContextToken) {
            assertableList.add(new SecurityContextTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof SamlToken) {
            assertableList.add(new SamlTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof RelToken) {
            assertableList.add(new RelTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof HttpsToken && !this.initiator) {
            assertableList.add(new HttpsTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof KeyValueToken) {
            assertableList.add(new KeyValueTokenAssertionState(abstractSecurityAssertion, false, this.initiator));
        } else if (abstractSecurityAssertion instanceof AlgorithmSuite) {
            assertableList.add(new AlgorithmSuiteAssertionState(abstractSecurityAssertion, true));
        } else if (abstractSecurityAssertion instanceof AbstractBinding) {
            AbstractBinding abstractBinding = (AbstractBinding)abstractSecurityAssertion;
            if (abstractBinding instanceof AbstractSymmetricAsymmetricBinding) {
                AbstractSymmetricAsymmetricBinding abstractSymmetricAsymmetricBinding = (AbstractSymmetricAsymmetricBinding)abstractSecurityAssertion;
                assertableList.add(new ProtectionOrderAssertionState((AbstractSecurityAssertion)abstractSymmetricAsymmetricBinding, true));
                assertableList.add(new SignatureProtectionAssertionState((AbstractSecurityAssertion)abstractSymmetricAsymmetricBinding, true));
                if (abstractSymmetricAsymmetricBinding.isOnlySignEntireHeadersAndBody()) {
                    assertableList.add(new OnlySignEntireHeadersAndBodyAssertionState(abstractSecurityAssertion, true, this.actorOrRole));
                }
                assertableList.add(new TokenProtectionAssertionState((Assertion)abstractSecurityAssertion, true));
            }
            assertableList.add(new IncludeTimeStampAssertionState((AbstractSecurityAssertion)abstractBinding, true));
            if (abstractBinding.isIncludeTimestamp()) {
                LinkedList<QName> timestampElementPath = new LinkedList<QName>();
                timestampElementPath.addAll(WSSConstants.WSSE_SECURITY_HEADER_PATH);
                timestampElementPath.add(WSSConstants.TAG_wsu_Timestamp);
                RequiredElementsAssertionState requiredElementsAssertionState = new RequiredElementsAssertionState((AbstractSecurityAssertion)abstractBinding, false);
                requiredElementsAssertionState.addElement(timestampElementPath);
                assertableList.add(requiredElementsAssertionState);
                SignedElementsAssertionState signedElementsAssertionState = new SignedElementsAssertionState(abstractSecurityAssertion, true);
                signedElementsAssertionState.addElement(timestampElementPath);
                assertableList.add(signedElementsAssertionState);
            }
        } else if (abstractSecurityAssertion instanceof Wss11) {
            Wss11 wss11 = (Wss11)abstractSecurityAssertion;
            if (this.initiator) {
                assertableList.add(new SignatureConfirmationAssertionState((AbstractSecurityAssertion)wss11, true));
                if (wss11.isRequireSignatureConfirmation()) {
                    LinkedList<QName> signatureConfirmationElementPath = new LinkedList<QName>();
                    signatureConfirmationElementPath.addAll(WSSConstants.WSSE_SECURITY_HEADER_PATH);
                    signatureConfirmationElementPath.add(WSSConstants.TAG_wsse11_SignatureConfirmation);
                    RequiredElementsAssertionState requiredElementsAssertionState = new RequiredElementsAssertionState((AbstractSecurityAssertion)wss11, false);
                    requiredElementsAssertionState.addElement(signatureConfirmationElementPath);
                    assertableList.add(requiredElementsAssertionState);
                    SignedElementsAssertionState signedElementsAssertionState = new SignedElementsAssertionState((AbstractSecurityAssertion)wss11, true);
                    signedElementsAssertionState.addElement(signatureConfirmationElementPath);
                    assertableList.add(signedElementsAssertionState);
                }
            }
        }
        return assertableList;
    }

    private void verifyPolicy(SecurityEvent securityEvent) throws WSSPolicyException, XMLSecurityException {
        block0: for (Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> map : this.failedAssertionStateMap) {
            Map<Assertion, List<Assertable>> assertionListMap = map.get(securityEvent.getSecurityEventType());
            if (assertionListMap == null || assertionListMap.size() <= 0) continue;
            for (Map.Entry<Assertion, List<Assertable>> assertionStateEntry : assertionListMap.entrySet()) {
                List<Assertable> assertionStates = assertionStateEntry.getValue();
                for (Assertable assertable : assertionStates) {
                    boolean asserted = assertable.assertEvent(securityEvent);
                    if (asserted) continue;
                    continue block0;
                }
            }
        }
        String assertionMessage = null;
        Iterator<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> assertionStateMapIterator = this.assertionStateMap.iterator();
        block3: while (assertionStateMapIterator.hasNext()) {
            Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> map = assertionStateMapIterator.next();
            Map<Assertion, List<Assertable>> assertionListMap = map.get(securityEvent.getSecurityEventType());
            if (assertionListMap == null || assertionListMap.size() <= 0) continue;
            for (Map.Entry<Assertion, List<Assertable>> assertionStateEntry : assertionListMap.entrySet()) {
                List<Assertable> assertionStates = assertionStateEntry.getValue();
                for (Assertable assertable : assertionStates) {
                    boolean asserted = assertable.assertEvent(securityEvent);
                    if (asserted) continue;
                    assertionMessage = assertable.getErrorMessage();
                    this.failedAssertionStateMap.add(map);
                    assertionStateMapIterator.remove();
                    continue block3;
                }
            }
        }
        if (!(!this.assertionStateMap.isEmpty() || this.faultOccurred && this.noSecurityHeader && this.initiator)) {
            this.logFailedAssertions();
            throw new PolicyViolationException(assertionMessage);
        }
    }

    private void verifyPolicy() throws WSSPolicyException {
        String assertionMessage = null;
        Iterator<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> assertionStateMapIterator = this.assertionStateMap.iterator();
        block0: while (assertionStateMapIterator.hasNext()) {
            Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> map = assertionStateMapIterator.next();
            for (Map.Entry<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> mapEntry : map.entrySet()) {
                for (Map.Entry<Assertion, List<Assertable>> assertionListEntry : mapEntry.getValue().entrySet()) {
                    List<Assertable> assertableList = assertionListEntry.getValue();
                    for (Assertable assertable : assertableList) {
                        if (assertable.isAsserted()) continue;
                        assertionMessage = assertable.getErrorMessage();
                        this.failedAssertionStateMap.add(map);
                        assertionStateMapIterator.remove();
                        continue block0;
                    }
                }
            }
        }
        if (!(!this.assertionStateMap.isEmpty() || this.faultOccurred && this.noSecurityHeader && this.initiator)) {
            this.logFailedAssertions();
            throw new WSSPolicyException(assertionMessage);
        }
    }

    private void verifyPolicyAfterOperationSecurityEvent() throws WSSPolicyException {
        String assertionMessage = null;
        Iterator<Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> assertionStateMapIterator = this.assertionStateMap.iterator();
        block0: while (assertionStateMapIterator.hasNext()) {
            Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> map = assertionStateMapIterator.next();
            for (Map.Entry<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> mapEntry : map.entrySet()) {
                for (Map.Entry<Assertion, List<Assertable>> assertionListEntry : mapEntry.getValue().entrySet()) {
                    List<Assertable> assertableList = assertionListEntry.getValue();
                    for (Assertable assertable : assertableList) {
                        boolean doAssert = false;
                        if (assertable instanceof TokenAssertionState) {
                            TokenAssertionState tokenAssertionState = (TokenAssertionState)assertable;
                            AbstractToken abstractToken = (AbstractToken)tokenAssertionState.getAssertion();
                            AbstractSecurityAssertion assertion = abstractToken.getParentAssertion();
                            if (assertion instanceof SupportingTokens || assertable instanceof HttpsTokenAssertionState || assertable instanceof RelTokenAssertionState || assertable instanceof SecurityContextTokenAssertionState || assertable instanceof SpnegoContextTokenAssertionState || assertable instanceof UsernameTokenAssertionState) {
                                doAssert = true;
                            }
                        } else if (assertable instanceof TokenProtectionAssertionState || assertable instanceof SignatureConfirmationAssertionState || assertable instanceof IncludeTimeStampAssertionState || assertable instanceof RequiredPartsAssertionState || assertable instanceof SignatureProtectionAssertionState) {
                            doAssert = true;
                        }
                        if (!doAssert && !assertable.isHardFailure() || assertable.isAsserted()) continue;
                        assertionMessage = assertable.getErrorMessage();
                        this.failedAssertionStateMap.add(map);
                        assertionStateMapIterator.remove();
                        continue block0;
                    }
                }
            }
        }
        if (!(!this.assertionStateMap.isEmpty() || this.faultOccurred && this.noSecurityHeader && this.initiator)) {
            this.logFailedAssertions();
            throw new WSSPolicyException(assertionMessage);
        }
    }

    private void logFailedAssertions() {
        for (Map<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> map : this.failedAssertionStateMap) {
            Set<Map.Entry<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>>> entrySet = map.entrySet();
            for (Map.Entry<SecurityEventConstants.Event, Map<Assertion, List<Assertable>>> eventCollectionEntry : entrySet) {
                Map<Assertion, List<Assertable>> assertionListMap = eventCollectionEntry.getValue();
                for (Map.Entry<Assertion, List<Assertable>> entry : assertionListMap.entrySet()) {
                    List<Assertable> assertionStates = entry.getValue();
                    for (Assertable assertable : assertionStates) {
                        if (assertable.isAsserted() || assertable.isLogged()) continue;
                        log.error(entry.getKey().getName() + " not satisfied: " + assertable.getErrorMessage());
                        assertable.setLogged(true);
                    }
                }
            }
        }
    }

    public synchronized void registerSecurityEvent(SecurityEvent securityEvent) throws WSSecurityException {
        if (securityEvent instanceof NoSecuritySecurityEvent) {
            this.noSecurityHeader = true;
        }
        if (this.operationSecurityEventOccured) {
            try {
                this.verifyPolicy(securityEvent);
            }
            catch (WSSPolicyException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)e));
            }
            catch (XMLSecurityException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)e));
            }
        }
        if (WSSecurityEventConstants.Operation.equals((Object)securityEvent.getSecurityEventType())) {
            this.operationSecurityEventOccured = true;
            OperationSecurityEvent operationSecurityEvent = (OperationSecurityEvent)securityEvent;
            if (SOAP11_FAULT.equals(operationSecurityEvent.getOperation()) || SOAP12_FAULT.equals(operationSecurityEvent.getOperation())) {
                this.faultOccurred = true;
            }
            if (this.effectivePolicy == null) {
                this.effectivePolicy = this.findPolicyBySOAPOperationName(this.operationPolicies, operationSecurityEvent.getOperation().getLocalPart());
                if (this.effectivePolicy == null) {
                    this.effectivePolicy = new OperationPolicy("NoPolicyFoundForOperation");
                    this.effectivePolicy.setPolicy(new Policy());
                }
                try {
                    this.buildAssertionStateMap((PolicyComponent)this.effectivePolicy.getPolicy(), this.assertionStateMap);
                }
                catch (WSSPolicyException e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)e));
                }
            }
            try {
                Iterator<SecurityEvent> securityEventIterator = this.securityEventQueue.descendingIterator();
                while (securityEventIterator.hasNext()) {
                    SecurityEvent prevSecurityEvent = securityEventIterator.next();
                    this.verifyPolicy(prevSecurityEvent);
                }
                this.verifyPolicy(securityEvent);
                this.verifyPolicyAfterOperationSecurityEvent();
            }
            catch (WSSPolicyException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)e));
            }
            catch (XMLSecurityException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)e));
            }
            this.securityEventQueue.clear();
            return;
        }
        this.securityEventQueue.push(securityEvent);
    }

    public void doFinal() throws WSSPolicyException {
        this.verifyPolicy();
    }
}

