/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.InboundWSSec;
import org.apache.wss4j.stax.ext.OutboundWSSec;
import org.apache.wss4j.stax.ext.WSSConfigurationException;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.Init;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;

public class WSSec {
    public static OutboundWSSec getOutboundWSSec(WSSSecurityProperties securityProperties) throws WSSecurityException {
        if (securityProperties == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "missingSecurityProperties");
        }
        securityProperties = WSSec.validateAndApplyDefaultsToOutboundSecurityProperties(securityProperties);
        return new OutboundWSSec(securityProperties);
    }

    public static InboundWSSec getInboundWSSec(WSSSecurityProperties securityProperties) throws WSSecurityException {
        if (securityProperties == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "missingSecurityProperties");
        }
        securityProperties = WSSec.validateAndApplyDefaultsToInboundSecurityProperties(securityProperties);
        return new InboundWSSec(securityProperties);
    }

    public static WSSSecurityProperties validateAndApplyDefaultsToOutboundSecurityProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        if (securityProperties.getOutAction() == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noOutputAction");
        }
        for (int i = 0; i < securityProperties.getOutAction().length; ++i) {
            XMLSecurityConstants.Action action = securityProperties.getOutAction()[i];
            if (WSSConstants.TIMESTAMP.equals((Object)action)) {
                if (securityProperties.getTimestampTTL() != null) continue;
                securityProperties.setTimestampTTL(300);
                continue;
            }
            if (WSSConstants.SIGNATURE.equals((Object)action)) {
                if (!"http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(securityProperties.getSignatureAlgorithm())) {
                    if (securityProperties.getSignatureKeyStore() == null && securityProperties.getSignatureCryptoProperties() == null && securityProperties.getSignatureCrypto() == null) {
                        throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "signatureKeyStoreNotSet");
                    }
                    if (securityProperties.getSignatureUser() == null) {
                        throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noSignatureUser");
                    }
                    if (securityProperties.getCallbackHandler() == null) {
                        throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                    }
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                if (securityProperties.getSignatureKeyIdentifier() != null) continue;
                securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_IssuerSerial);
                continue;
            }
            if (WSSConstants.ENCRYPT.equals((Object)action)) {
                if (securityProperties.getEncryptionUseThisCertificate() == null && securityProperties.getEncryptionKeyStore() == null && securityProperties.getEncryptionCryptoProperties() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncrytionKey() && securityProperties.getEncryptionCrypto() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "encryptionKeyStoreNotSet");
                }
                if (securityProperties.getEncryptionUser() == null && securityProperties.getEncryptionUseThisCertificate() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncrytionKey()) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noEncryptionUser");
                }
                if (securityProperties.getEncryptionSymAlgorithm() == null) {
                    securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (securityProperties.getEncryptionKeyTransportAlgorithm() == null) {
                    securityProperties.setEncryptionKeyTransportAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
                }
                if (securityProperties.getEncryptionKeyIdentifier() != null) continue;
                securityProperties.setEncryptionKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_IssuerSerial);
                continue;
            }
            if (WSSConstants.USERNAMETOKEN.equals((Object)action)) {
                if (securityProperties.getTokenUser() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noTokenUser");
                }
                if (securityProperties.getCallbackHandler() == null && WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE != securityProperties.getUsernameTokenPasswordType()) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getUsernameTokenPasswordType() != null) continue;
                securityProperties.setUsernameTokenPasswordType(WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST);
                continue;
            }
            if (WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)action)) {
                if (securityProperties.getTokenUser() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noTokenUser");
                }
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_UsernameTokenReference);
                if (securityProperties.getUsernameTokenPasswordType() != null) continue;
                securityProperties.setUsernameTokenPasswordType(WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST);
                continue;
            }
            if (WSSConstants.SIGNATURE_WITH_DERIVED_KEY.equals((Object)action)) {
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                if (securityProperties.getSignatureKeyIdentifier() == null) {
                    securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference);
                }
                if (securityProperties.getEncryptionSymAlgorithm() == null) {
                    securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (securityProperties.getEncryptionKeyTransportAlgorithm() == null) {
                    securityProperties.setEncryptionKeyTransportAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
                }
                if (securityProperties.getEncryptionKeyIdentifier() == null) {
                    securityProperties.setEncryptionKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
                }
                if (securityProperties.getDerivedKeyKeyIdentifier() == null) {
                    securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
                }
                if (securityProperties.getDerivedKeyTokenReference() == null) {
                    securityProperties.setDerivedKeyTokenReference(WSSConstants.DerivedKeyTokenReference.DirectReference);
                }
                if (securityProperties.getDerivedKeyTokenReference() == WSSConstants.DerivedKeyTokenReference.DirectReference) continue;
                securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference);
                continue;
            }
            if (WSSConstants.ENCRYPT_WITH_DERIVED_KEY.equals((Object)action)) {
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getEncryptionUseThisCertificate() == null && securityProperties.getEncryptionKeyStore() == null && securityProperties.getEncryptionCryptoProperties() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncrytionKey() && securityProperties.getEncryptionCrypto() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "encryptionKeyStoreNotSet");
                }
                if (securityProperties.getEncryptionUser() == null && securityProperties.getEncryptionUseThisCertificate() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncrytionKey()) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noEncryptionUser");
                }
                if (securityProperties.getEncryptionSymAlgorithm() == null) {
                    securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (securityProperties.getEncryptionKeyTransportAlgorithm() == null) {
                    securityProperties.setEncryptionKeyTransportAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
                }
                if (securityProperties.getEncryptionKeyIdentifier() == null) {
                    securityProperties.setEncryptionKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
                }
                if (securityProperties.getDerivedKeyKeyIdentifier() == null) {
                    securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
                }
                if (securityProperties.getDerivedKeyTokenReference() == null) {
                    securityProperties.setDerivedKeyTokenReference(WSSConstants.DerivedKeyTokenReference.EncryptedKey);
                }
                if (securityProperties.getDerivedKeyTokenReference() == WSSConstants.DerivedKeyTokenReference.DirectReference) continue;
                securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference);
                continue;
            }
            if (WSSConstants.SAML_TOKEN_SIGNED.equals((Object)action)) {
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSamlCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noSAMLCallbackHandler");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                if (securityProperties.getSignatureKeyIdentifier() != null) continue;
                securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference);
                continue;
            }
            if (WSSConstants.SAML_TOKEN_UNSIGNED.equals((Object)action) && securityProperties.getSamlCallbackHandler() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noSAMLCallbackHandler");
            }
            if (WSSConstants.SIGNATURE_WITH_KERBEROS_TOKEN.equals((Object)action)) {
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                if (securityProperties.getSignatureKeyIdentifier() != null) continue;
                securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference);
                continue;
            }
            if (!WSSConstants.ENCRYPT_WITH_KERBEROS_TOKEN.equals((Object)action)) continue;
            if (securityProperties.getCallbackHandler() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
            }
            if (securityProperties.getEncryptionSymAlgorithm() == null) {
                securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            }
            if (securityProperties.getSignatureKeyIdentifier() != null) continue;
            securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference);
        }
        return new WSSSecurityProperties(securityProperties);
    }

    public static WSSSecurityProperties validateAndApplyDefaultsToInboundSecurityProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        return new WSSSecurityProperties(securityProperties);
    }

    static {
        WSProviderConfig.init();
        try {
            Init.init((URI)WSSec.class.getClassLoader().getResource("wss/wss-config.xml").toURI());
        }
        catch (XMLSecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

