/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.input;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.wss4j.binding.wss10.SecurityTokenReferenceType;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.EncryptedPartSecurityEvent;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.binding.xmldsig.KeyInfoType;
import org.apache.xml.security.binding.xmldsig.TransformType;
import org.apache.xml.security.binding.xmldsig.TransformsType;
import org.apache.xml.security.binding.xmlenc.EncryptedDataType;
import org.apache.xml.security.binding.xmlenc.ReferenceList;
import org.apache.xml.security.binding.xmlenc.ReferenceType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.ConfigurationProperties;
import org.apache.xml.security.stax.config.TransformerAlgorithmMapper;
import org.apache.xml.security.stax.ext.DocumentContext;
import org.apache.xml.security.stax.ext.InboundSecurityContext;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.ext.XMLSecurityUtils;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.processor.input.AbstractDecryptInputProcessor;
import org.apache.xml.security.stax.impl.util.LimitingInputStream;
import org.apache.xml.security.stax.securityEvent.ContentEncryptedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.EncryptedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.InboundSecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptInputProcessor
extends AbstractDecryptInputProcessor {
    private static final transient Logger log = LoggerFactory.getLogger(DecryptInputProcessor.class);
    private static final Long maximumAllowedDecompressedBytes = Long.valueOf(ConfigurationProperties.getProperty((String)"MaximumAllowedDecompressedBytes"));

    public DecryptInputProcessor(KeyInfoType keyInfoType, ReferenceList referenceList, WSSSecurityProperties securityProperties, WSInboundSecurityContext securityContext) throws XMLSecurityException {
        super(keyInfoType, referenceList, (XMLSecurityProperties)securityProperties);
        this.checkBSPCompliance(keyInfoType, referenceList, securityContext, BSPRule.R3006);
    }

    private void checkBSPCompliance(KeyInfoType keyInfoType, ReferenceList referenceList, WSInboundSecurityContext securityContext, BSPRule bspRule) throws WSSecurityException {
        if (keyInfoType != null) {
            SecurityTokenReferenceType securityTokenReferenceType;
            if (keyInfoType.getContent().size() != 1) {
                securityContext.handleBSPRule(BSPRule.R5424);
            }
            if ((securityTokenReferenceType = (SecurityTokenReferenceType)XMLSecurityUtils.getQNameType((List)keyInfoType.getContent(), (QName)WSSConstants.TAG_wsse_SecurityTokenReference)) == null) {
                securityContext.handleBSPRule(BSPRule.R5426);
            }
        }
        if (referenceList != null) {
            List references = referenceList.getDataReferenceOrKeyReference();
            Iterator referenceTypeIterator = references.iterator();
            while (referenceTypeIterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)((JAXBElement)referenceTypeIterator.next()).getValue();
                if (referenceType.getURI().startsWith("#")) continue;
                securityContext.handleBSPRule(bspRule);
            }
        }
    }

    protected InputStream applyTransforms(ReferenceType referenceType, InputStream inputStream) throws XMLSecurityException {
        TransformsType transformsType;
        if (referenceType != null && (transformsType = (TransformsType)XMLSecurityUtils.getQNameType((List)referenceType.getAny(), (QName)XMLSecurityConstants.TAG_dsig_Transforms)) != null) {
            List transformTypes = transformsType.getTransform();
            if (transformTypes.size() > 1) {
                throw new XMLSecurityException("stax.encryption.Transforms.NotYetImplemented");
            }
            TransformType transformType = (TransformType)transformTypes.get(0);
            Class transformerClass = TransformerAlgorithmMapper.getTransformerClass((String)transformType.getAlgorithm(), (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.IN);
            try {
                Constructor constructor = transformerClass.getConstructor(InputStream.class);
                inputStream = new LimitingInputStream((InputStream)constructor.newInstance(inputStream), maximumAllowedDecompressedBytes.longValue());
            }
            catch (InvocationTargetException e) {
                throw new XMLSecurityException((Exception)e);
            }
            catch (NoSuchMethodException e) {
                throw new XMLSecurityException((Exception)e);
            }
            catch (InstantiationException e) {
                throw new XMLSecurityException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new XMLSecurityException((Exception)e);
            }
        }
        return inputStream;
    }

    protected void handleEncryptedContent(InputProcessorChain inputProcessorChain, XMLSecStartElement parentStartXMLEvent, InboundSecurityToken inboundSecurityToken, EncryptedDataType encryptedDataType) throws XMLSecurityException {
        DocumentContext documentContext = inputProcessorChain.getDocumentContext();
        List elementPath = parentStartXMLEvent.getElementPath();
        if (elementPath.size() == 2 && WSSUtils.isInSOAPBody(elementPath)) {
            EncryptedPartSecurityEvent encryptedPartSecurityEvent = new EncryptedPartSecurityEvent(inboundSecurityToken, true, documentContext.getProtectionOrder());
            encryptedPartSecurityEvent.setElementPath(elementPath);
            encryptedPartSecurityEvent.setXmlSecEvent((XMLSecEvent)parentStartXMLEvent);
            encryptedPartSecurityEvent.setCorrelationID(encryptedDataType.getId());
            inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)encryptedPartSecurityEvent);
        } else {
            ContentEncryptedElementSecurityEvent contentEncryptedElementSecurityEvent = new ContentEncryptedElementSecurityEvent(inboundSecurityToken, true, documentContext.getProtectionOrder());
            contentEncryptedElementSecurityEvent.setElementPath(elementPath);
            contentEncryptedElementSecurityEvent.setXmlSecEvent((XMLSecEvent)parentStartXMLEvent);
            contentEncryptedElementSecurityEvent.setCorrelationID(encryptedDataType.getId());
            inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)contentEncryptedElementSecurityEvent);
        }
    }

    protected AbstractDecryptInputProcessor.AbstractDecryptedEventReaderInputProcessor newDecryptedEventReaderInputProcessor(boolean encryptedHeader, XMLSecStartElement xmlSecStartElement, EncryptedDataType encryptedDataType, InboundSecurityToken inboundSecurityToken, InboundSecurityContext inboundSecurityContext) throws XMLSecurityException {
        String encryptionAlgorithm = encryptedDataType.getEncryptionMethod().getAlgorithm();
        if (this.getSecurityProperties().getEncryptionSymAlgorithm() != null && !this.getSecurityProperties().getEncryptionSymAlgorithm().equals(encryptionAlgorithm)) {
            log.debug("The Key encryption method does not match the requirement");
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(encryptionAlgorithm) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(encryptionAlgorithm) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(encryptionAlgorithm) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(encryptionAlgorithm) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(encryptionAlgorithm))) {
            ((WSInboundSecurityContext)inboundSecurityContext).handleBSPRule(BSPRule.R5620);
        }
        return new DecryptedEventReaderInputProcessor(this.getSecurityProperties(), SecurePart.Modifier.getModifier((String)encryptedDataType.getType()), encryptedHeader, xmlSecStartElement, encryptedDataType, this, inboundSecurityToken);
    }

    protected void handleSecurityToken(InboundSecurityToken inboundSecurityToken, InboundSecurityContext inboundSecurityContext, EncryptedDataType encryptedDataType) throws XMLSecurityException {
        inboundSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_Encryption);
        TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent = WSSUtils.createTokenSecurityEvent(inboundSecurityToken, encryptedDataType.getId());
        inboundSecurityContext.registerSecurityEvent(tokenSecurityEvent);
    }

    public void doFinal(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
        List encryptedDataRefs = inputProcessorChain.getSecurityContext().getAsList((Object)"PROP_ENCRYPTED_DATA_REFS");
        if (encryptedDataRefs != null && !encryptedDataRefs.isEmpty()) {
            Map references = this.getReferences();
            List processedReferences = this.getProcessedReferences();
            if (references != null) {
                for (Map.Entry next : references.entrySet()) {
                    ReferenceType referenceType = (ReferenceType)next.getValue();
                    String uri = WSSUtils.dropReferenceMarker((String)referenceType.getURI());
                    for (String s : encryptedDataRefs) {
                        if (!s.equals(uri)) continue;
                        processedReferences.add(referenceType);
                    }
                }
            }
        }
        super.doFinal(inputProcessorChain);
    }

    class DecryptedEventReaderInputProcessor
    extends AbstractDecryptInputProcessor.AbstractDecryptedEventReaderInputProcessor {
        DecryptedEventReaderInputProcessor(XMLSecurityProperties securityProperties, SecurePart.Modifier encryptionModifier, boolean encryptedHeader, XMLSecStartElement xmlSecStartElement, EncryptedDataType encryptedDataType, DecryptInputProcessor decryptInputProcessor2, InboundSecurityToken inboundSecurityToken) {
            super((AbstractDecryptInputProcessor)DecryptInputProcessor.this, securityProperties, encryptionModifier, encryptedHeader, xmlSecStartElement, encryptedDataType, (AbstractDecryptInputProcessor)decryptInputProcessor2, inboundSecurityToken);
        }

        protected void handleEncryptedElement(InputProcessorChain inputProcessorChain, XMLSecStartElement xmlSecStartElement, InboundSecurityToken inboundSecurityToken, EncryptedDataType encryptedDataType) throws XMLSecurityException {
            DocumentContext documentContext = inputProcessorChain.getDocumentContext();
            List elementPath = xmlSecStartElement.getElementPath();
            if (elementPath.size() == 3 && WSSUtils.isInSOAPHeader(elementPath)) {
                EncryptedPartSecurityEvent encryptedPartSecurityEvent = new EncryptedPartSecurityEvent(inboundSecurityToken, true, documentContext.getProtectionOrder());
                encryptedPartSecurityEvent.setElementPath(elementPath);
                encryptedPartSecurityEvent.setXmlSecEvent((XMLSecEvent)xmlSecStartElement);
                encryptedPartSecurityEvent.setCorrelationID(encryptedDataType.getId());
                inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)encryptedPartSecurityEvent);
            } else {
                EncryptedElementSecurityEvent encryptedElementSecurityEvent = new EncryptedElementSecurityEvent(inboundSecurityToken, true, documentContext.getProtectionOrder());
                encryptedElementSecurityEvent.setElementPath(elementPath);
                encryptedElementSecurityEvent.setXmlSecEvent((XMLSecEvent)xmlSecStartElement);
                encryptedElementSecurityEvent.setCorrelationID(encryptedDataType.getId());
                inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)encryptedElementSecurityEvent);
            }
        }
    }
}

