/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.input;

import java.util.Deque;
import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.impl.processor.input.DecryptInputProcessor;
import org.apache.xml.security.binding.xmlenc.ReferenceList;
import org.apache.xml.security.binding.xmlenc.ReferenceType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.AbstractInputSecurityHeaderHandler;
import org.apache.xml.security.stax.ext.InputProcessor;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;

public class EncryptedDataInputHandler
extends AbstractInputSecurityHeaderHandler {
    public void handle(final InputProcessorChain inputProcessorChain, XMLSecurityProperties securityProperties, Deque<XMLSecEvent> eventQueue, Integer index) throws XMLSecurityException {
        XMLSecEvent xmlSecEvent = null;
        Iterator<XMLSecEvent> xmlSecEventIterator = eventQueue.descendingIterator();
        int curIdx = 0;
        while (curIdx++ <= index) {
            xmlSecEvent = xmlSecEventIterator.next();
        }
        if (!(xmlSecEvent instanceof XMLSecStartElement)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
        }
        final XMLSecStartElement encryptedDataElement = xmlSecEvent.asStartElement();
        final Attribute idAttribute = encryptedDataElement.getAttributeByName(XMLSecurityConstants.ATT_NULL_Id);
        DecryptInputProcessor decryptInputProcessor = new DecryptInputProcessor(null, new ReferenceList(), (WSSSecurityProperties)securityProperties, (WSInboundSecurityContext)inputProcessorChain.getSecurityContext()){

            protected ReferenceType matchesReferenceId(XMLSecStartElement xmlSecStartElement) {
                if (xmlSecStartElement == encryptedDataElement) {
                    ReferenceType referenceType = new ReferenceType();
                    if (idAttribute != null) {
                        String uri = idAttribute.getValue();
                        referenceType.setURI("#" + uri);
                        inputProcessorChain.getSecurityContext().putAsList((Object)"PROP_ENCRYPTED_DATA_REFS", (Object)uri);
                    }
                    inputProcessorChain.removeProcessor((InputProcessor)this);
                    return referenceType;
                }
                return null;
            }
        };
        inputProcessorChain.addProcessor((InputProcessor)decryptInputProcessor);
    }
}

