/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.input;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.wss4j.binding.wss10.TransformationParametersType;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.SignedPartSecurityEvent;
import org.apache.wss4j.stax.securityEvent.TimestampSecurityEvent;
import org.apache.wss4j.stax.securityToken.SecurityTokenReference;
import org.apache.xml.security.binding.excc14n.InclusiveNamespaces;
import org.apache.xml.security.binding.xmldsig.CanonicalizationMethodType;
import org.apache.xml.security.binding.xmldsig.ReferenceType;
import org.apache.xml.security.binding.xmldsig.SignatureType;
import org.apache.xml.security.binding.xmldsig.TransformType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.DocumentContext;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.Transformer;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.ext.XMLSecurityUtils;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.processor.input.AbstractSignatureReferenceVerifyInputProcessor;
import org.apache.xml.security.stax.securityEvent.AlgorithmSuiteSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SignedElementSecurityEvent;
import org.apache.xml.security.stax.securityToken.InboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class WSSSignatureReferenceVerifyInputProcessor
extends AbstractSignatureReferenceVerifyInputProcessor {
    private boolean replayChecked = false;

    public WSSSignatureReferenceVerifyInputProcessor(InputProcessorChain inputProcessorChain, SignatureType signatureType, InboundSecurityToken inboundSecurityToken, XMLSecurityProperties securityProperties) throws XMLSecurityException {
        super(inputProcessorChain, signatureType, inboundSecurityToken, securityProperties);
        this.addAfterProcessor(WSSSignatureReferenceVerifyInputProcessor.class.getName());
        this.checkBSPCompliance((WSInboundSecurityContext)inputProcessorChain.getSecurityContext());
    }

    private void checkBSPCompliance(WSInboundSecurityContext securityContext) throws WSSecurityException {
        List references = this.getSignatureType().getSignedInfo().getReference();
        for (int i = 0; i < references.size(); ++i) {
            ReferenceType referenceType = (ReferenceType)references.get(i);
            if (referenceType.getTransforms() == null) {
                securityContext.handleBSPRule(BSPRule.R5416);
            } else if (referenceType.getTransforms().getTransform().size() == 0) {
                securityContext.handleBSPRule(BSPRule.R5411);
            } else {
                List transformTypes = referenceType.getTransforms().getTransform();
                for (int j = 0; j < transformTypes.size(); ++j) {
                    TransformationParametersType transformationParametersType;
                    TransformType transformType = (TransformType)transformTypes.get(j);
                    String algorithm = transformType.getAlgorithm();
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(algorithm) || "http://www.w3.org/2002/06/xmldsig-filter2".equals(algorithm) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithm) || "http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algorithm) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform".equals(algorithm) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform".equals(algorithm)) continue;
                    securityContext.handleBSPRule(BSPRule.R5423);
                    if (!(j != transformTypes.size() - 1 || "http://www.w3.org/2001/10/xml-exc-c14n#".equals(algorithm) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithm) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform".equals(algorithm) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform".equals(algorithm))) {
                        securityContext.handleBSPRule(BSPRule.R5412);
                    }
                    InclusiveNamespaces inclusiveNamespacesType = (InclusiveNamespaces)XMLSecurityUtils.getQNameType((List)transformType.getContent(), (QName)XMLSecurityConstants.TAG_c14nExcl_InclusiveNamespaces);
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(algorithm) && inclusiveNamespacesType != null && inclusiveNamespacesType.getPrefixList().size() == 0) {
                        securityContext.handleBSPRule(BSPRule.R5407);
                    }
                    if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithm)) continue;
                    if (inclusiveNamespacesType != null && inclusiveNamespacesType.getPrefixList().size() == 0) {
                        securityContext.handleBSPRule(BSPRule.R5413);
                    }
                    if ((transformationParametersType = (TransformationParametersType)XMLSecurityUtils.getQNameType((List)transformType.getContent(), (QName)WSSConstants.TAG_wsse_TransformationParameters)) == null) {
                        securityContext.handleBSPRule(BSPRule.R3065);
                        continue;
                    }
                    CanonicalizationMethodType canonicalizationMethodType = (CanonicalizationMethodType)XMLSecurityUtils.getQNameType((List)transformationParametersType.getAny(), (QName)WSSConstants.TAG_dsig_CanonicalizationMethod);
                    if (canonicalizationMethodType != null) continue;
                    securityContext.handleBSPRule(BSPRule.R3065);
                }
            }
            if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(referenceType.getDigestMethod().getAlgorithm()) || "http://www.w3.org/2001/04/xmlenc#sha256".equals(referenceType.getDigestMethod().getAlgorithm()) || "http://www.w3.org/2001/04/xmlenc#sha512".equals(referenceType.getDigestMethod().getAlgorithm())) continue;
            securityContext.handleBSPRule(BSPRule.R5420);
        }
    }

    public XMLSecEvent processNextEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
        if (!this.replayChecked) {
            this.replayChecked = true;
            this.detectReplayAttack(inputProcessorChain);
        }
        return super.processNextEvent(inputProcessorChain);
    }

    protected void processElementPath(List<QName> elementPath, InputProcessorChain inputProcessorChain, XMLSecEvent xmlSecEvent, ReferenceType referenceType) throws XMLSecurityException {
        DocumentContext documentContext = inputProcessorChain.getDocumentContext();
        if (elementPath.size() == 3 && WSSUtils.isInSOAPHeader(elementPath) || elementPath.size() == 2 && WSSUtils.isInSOAPBody(elementPath)) {
            SignedPartSecurityEvent signedPartSecurityEvent = new SignedPartSecurityEvent(this.getInboundSecurityToken(), true, documentContext.getProtectionOrder());
            signedPartSecurityEvent.setElementPath(elementPath);
            signedPartSecurityEvent.setXmlSecEvent(xmlSecEvent);
            signedPartSecurityEvent.setCorrelationID(referenceType.getId());
            inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)signedPartSecurityEvent);
        } else {
            SignedElementSecurityEvent signedElementSecurityEvent = new SignedElementSecurityEvent(this.getInboundSecurityToken(), true, documentContext.getProtectionOrder());
            signedElementSecurityEvent.setElementPath(elementPath);
            signedElementSecurityEvent.setXmlSecEvent(xmlSecEvent);
            signedElementSecurityEvent.setCorrelationID(referenceType.getId());
            inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)signedElementSecurityEvent);
        }
    }

    protected InternalSignatureReferenceVerifier getSignatureReferenceVerifier(XMLSecurityProperties securityProperties, InputProcessorChain inputProcessorChain, ReferenceType referenceType, XMLSecStartElement startElement) throws XMLSecurityException {
        return new InternalSignatureReferenceVerifier((WSSSecurityProperties)securityProperties, inputProcessorChain, referenceType, startElement);
    }

    private void detectReplayAttack(InputProcessorChain inputProcessorChain) throws WSSecurityException {
        TimestampSecurityEvent timestampSecurityEvent = (TimestampSecurityEvent)((Object)inputProcessorChain.getSecurityContext().get("PROP_TIMESTAMP"));
        ReplayCache replayCache = ((WSSSecurityProperties)this.getSecurityProperties()).getTimestampReplayCache();
        if (timestampSecurityEvent != null && replayCache != null) {
            String cacheKey = String.valueOf(timestampSecurityEvent.getCreated().getTimeInMillis()) + "" + Arrays.hashCode(this.getSignatureType().getSignatureValue().getValue());
            if (replayCache.contains(cacheKey)) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.MESSAGE_EXPIRED);
            }
            Calendar expiresCal = timestampSecurityEvent.getExpires();
            if (expiresCal != null) {
                Date rightNow = new Date();
                long currentTime = rightNow.getTime();
                long expiresTime = expiresCal.getTimeInMillis();
                replayCache.add(cacheKey, 1L + (expiresTime - currentTime) / 1000L);
            } else {
                replayCache.add(cacheKey);
            }
        }
    }

    protected Transformer buildTransformerChain(ReferenceType referenceType, OutputStream outputStream, InputProcessorChain inputProcessorChain, AbstractSignatureReferenceVerifyInputProcessor.InternalSignatureReferenceVerifier internalSignatureReferenceVerifier) throws XMLSecurityException {
        if (referenceType.getTransforms() == null || referenceType.getTransforms().getTransform().size() == 0) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
        List transformTypeList = referenceType.getTransforms().getTransform();
        if (transformTypeList.size() > maximumAllowedTransformsPerReference) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "secureProcessing.MaximumAllowedTransformsPerReference", new Object[]{transformTypeList.size(), maximumAllowedTransformsPerReference});
        }
        String algorithm = null;
        Transformer parentTransformer = null;
        for (int i = transformTypeList.size() - 1; i >= 0; --i) {
            List inclusiveNamespaces;
            InclusiveNamespaces inclusiveNamespacesType;
            CanonicalizationMethodType canonicalizationMethodType;
            TransformType transformType = (TransformType)transformTypeList.get(i);
            TransformationParametersType transformationParametersType = (TransformationParametersType)XMLSecurityUtils.getQNameType((List)transformType.getContent(), (QName)WSSConstants.TAG_wsse_TransformationParameters);
            if (transformationParametersType != null && (canonicalizationMethodType = (CanonicalizationMethodType)XMLSecurityUtils.getQNameType((List)transformationParametersType.getAny(), (QName)WSSConstants.TAG_dsig_CanonicalizationMethod)) != null) {
                inclusiveNamespacesType = (InclusiveNamespaces)XMLSecurityUtils.getQNameType((List)canonicalizationMethodType.getContent(), (QName)XMLSecurityConstants.TAG_c14nExcl_InclusiveNamespaces);
                inclusiveNamespaces = inclusiveNamespacesType != null ? inclusiveNamespacesType.getPrefixList() : null;
                algorithm = canonicalizationMethodType.getAlgorithm();
                parentTransformer = WSSUtils.getTransformer((Object)inclusiveNamespaces, (Object)outputStream, (String)algorithm, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.IN);
            }
            algorithm = transformType.getAlgorithm();
            AlgorithmSuiteSecurityEvent algorithmSuiteSecurityEvent = new AlgorithmSuiteSecurityEvent();
            algorithmSuiteSecurityEvent.setAlgorithmURI(algorithm);
            algorithmSuiteSecurityEvent.setAlgorithmUsage(WSSConstants.C14n);
            algorithmSuiteSecurityEvent.setCorrelationID(referenceType.getId());
            inputProcessorChain.getSecurityContext().registerSecurityEvent((SecurityEvent)algorithmSuiteSecurityEvent);
            inclusiveNamespacesType = (InclusiveNamespaces)XMLSecurityUtils.getQNameType((List)transformType.getContent(), (QName)XMLSecurityConstants.TAG_c14nExcl_InclusiveNamespaces);
            inclusiveNamespaces = inclusiveNamespacesType != null ? inclusiveNamespacesType.getPrefixList() : null;
            parentTransformer = parentTransformer != null ? WSSUtils.getTransformer((Object)parentTransformer, (Object)inclusiveNamespaces, (String)algorithm, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.IN) : WSSUtils.getTransformer((Object)inclusiveNamespaces, (Object)outputStream, (String)algorithm, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.IN);
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithm)) {
            internalSignatureReferenceVerifier.setTransformer(parentTransformer);
            SecurityTokenProvider securityTokenProvider = inputProcessorChain.getSecurityContext().getSecurityTokenProvider(XMLSecurityUtils.dropReferenceMarker((String)referenceType.getURI()));
            if (securityTokenProvider == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noReference", new Object[0]);
            }
            SecurityToken securityToken = (SecurityToken)securityTokenProvider.getSecurityToken();
            if (!(securityToken instanceof SecurityTokenReference)) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_SECURITY_TOKEN);
            }
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)securityToken;
            inputProcessorChain.getDocumentContext().setIsInSignedContent(inputProcessorChain.getProcessors().indexOf(internalSignatureReferenceVerifier), (Object)internalSignatureReferenceVerifier);
            XMLSecStartElement xmlSecStartElement = securityTokenReference.getXmlSecEvents().getLast().asStartElement();
            internalSignatureReferenceVerifier.setStartElement(xmlSecStartElement);
            Iterator<XMLSecEvent> xmlSecEventIterator = securityTokenReference.getXmlSecEvents().descendingIterator();
            try {
                while (xmlSecEventIterator.hasNext()) {
                    internalSignatureReferenceVerifier.processEvent(xmlSecEventIterator.next(), inputProcessorChain);
                }
            }
            catch (XMLStreamException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)e);
            }
        }
        return parentTransformer;
    }

    class InternalSignatureReferenceVerifier
    extends AbstractSignatureReferenceVerifyInputProcessor.InternalSignatureReferenceVerifier {
        InternalSignatureReferenceVerifier(WSSSecurityProperties securityProperties, InputProcessorChain inputProcessorChain, ReferenceType referenceType, XMLSecStartElement startElement) throws XMLSecurityException {
            super((AbstractSignatureReferenceVerifyInputProcessor)WSSSignatureReferenceVerifyInputProcessor.this, (XMLSecurityProperties)securityProperties, inputProcessorChain, referenceType, startElement);
            this.addAfterProcessor(WSSSignatureReferenceVerifyInputProcessor.class.getName());
        }
    }
}

