/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.output;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.impl.processor.output.EncryptEndingOutputProcessor;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.TransformerAlgorithmMapper;
import org.apache.xml.security.stax.ext.AbstractOutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.EncryptionPartDef;
import org.apache.xml.security.stax.impl.processor.output.AbstractEncryptOutputProcessor;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptOutputProcessor
extends AbstractEncryptOutputProcessor {
    private static final transient Logger logger = LoggerFactory.getLogger(EncryptOutputProcessor.class);

    public void init(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
        super.init(outputProcessorChain);
        EncryptEndingOutputProcessor encryptEndingOutputProcessor = new EncryptEndingOutputProcessor();
        encryptEndingOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
        encryptEndingOutputProcessor.setAction(this.getAction());
        encryptEndingOutputProcessor.init(outputProcessorChain);
    }

    public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        if (xmlSecEvent.getEventType() == 1) {
            SecurePart securePart;
            XMLSecStartElement xmlSecStartElement = xmlSecEvent.asStartElement();
            if (this.getActiveInternalEncryptionOutputProcessor() == null && (securePart = this.securePartMatches(xmlSecStartElement, outputProcessorChain, "encryptionParts")) != null) {
                logger.debug("Matched encryptionPart for encryption");
                String tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTION");
                SecurityTokenProvider securityTokenProvider = outputProcessorChain.getSecurityContext().getSecurityTokenProvider(tokenId);
                OutboundSecurityToken securityToken = (OutboundSecurityToken)securityTokenProvider.getSecurityToken();
                EncryptionPartDef encryptionPartDef = new EncryptionPartDef();
                encryptionPartDef.setSecurePart(securePart);
                encryptionPartDef.setModifier(securePart.getModifier());
                encryptionPartDef.setEncRefId(IDGenerator.generateID(null));
                encryptionPartDef.setKeyId(securityTokenProvider.getId());
                encryptionPartDef.setSymmetricKey(securityToken.getSecretKey(this.getSecurityProperties().getEncryptionSymAlgorithm()));
                outputProcessorChain.getSecurityContext().putAsList(EncryptionPartDef.class, (Object)encryptionPartDef);
                InternalEncryptionOutputProcessor internalEncryptionOutputProcessor = new InternalEncryptionOutputProcessor(encryptionPartDef, xmlSecStartElement, outputProcessorChain.getDocumentContext().getEncoding(), securityToken.getSha1Identifier(), securityToken.getTokenType());
                internalEncryptionOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
                internalEncryptionOutputProcessor.setAction(this.getAction());
                internalEncryptionOutputProcessor.init(outputProcessorChain);
                this.setActiveInternalEncryptionOutputProcessor(internalEncryptionOutputProcessor);
                if ("Body".equals(xmlSecStartElement.getName().getLocalPart()) && WSSUtils.isInSOAPBody((XMLSecEvent)xmlSecStartElement)) {
                    this.doFinalInternal(outputProcessorChain);
                    outputProcessorChain.removeProcessor((OutputProcessor)this);
                }
            }
        }
        outputProcessorChain.processEvent(xmlSecEvent);
    }

    class InternalEncryptionOutputProcessor
    extends AbstractEncryptOutputProcessor.AbstractInternalEncryptionOutputProcessor {
        private boolean doEncryptedHeader;
        private final String sha1Identifier;
        private final SecurityTokenConstants.TokenType tokenType;

        InternalEncryptionOutputProcessor(EncryptionPartDef encryptionPartDef, XMLSecStartElement xmlSecStartElement, String encoding, String sha1Identifier, SecurityTokenConstants.TokenType tokenType) throws XMLSecurityException, XMLStreamException {
            super((AbstractEncryptOutputProcessor)EncryptOutputProcessor.this, encryptionPartDef, xmlSecStartElement, encoding);
            this.doEncryptedHeader = false;
            this.addBeforeProcessor(EncryptEndingOutputProcessor.class.getName());
            this.addBeforeProcessor(InternalEncryptionOutputProcessor.class.getName());
            this.addAfterProcessor(EncryptOutputProcessor.class.getName());
            this.sha1Identifier = sha1Identifier;
            this.tokenType = tokenType;
        }

        protected OutputStream applyTransforms(OutputStream outputStream) throws XMLSecurityException {
            String compressionAlgorithm = ((WSSSecurityProperties)this.getSecurityProperties()).getEncryptionCompressionAlgorithm();
            if (compressionAlgorithm != null) {
                Class transformerClass = TransformerAlgorithmMapper.getTransformerClass((String)compressionAlgorithm, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.OUT);
                try {
                    Constructor constructor = transformerClass.getConstructor(OutputStream.class);
                    outputStream = (OutputStream)constructor.newInstance(outputStream);
                }
                catch (InvocationTargetException e) {
                    throw new XMLSecurityException((Exception)e);
                }
                catch (NoSuchMethodException e) {
                    throw new XMLSecurityException((Exception)e);
                }
                catch (InstantiationException e) {
                    throw new XMLSecurityException((Exception)e);
                }
                catch (IllegalAccessException e) {
                    throw new XMLSecurityException((Exception)e);
                }
            }
            return outputStream;
        }

        protected void processEventInternal(XMLSecStartElement xmlSecStartElement, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            List elementPath = xmlSecStartElement.getElementPath();
            if (elementPath.size() == 3 && WSSUtils.isInSOAPHeader(elementPath)) {
                this.doEncryptedHeader = true;
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                Iterator attributeIterator = this.getXmlSecStartElement().getAttributes();
                while (attributeIterator.hasNext()) {
                    Attribute attribute = (Attribute)attributeIterator.next();
                    if (attribute.isNamespace() || !"http://schemas.xmlsoap.org/soap/envelope/".equals(attribute.getName().getNamespaceURI()) && !"http://www.w3.org/2003/05/soap-envelope".equals(attribute.getName().getNamespaceURI())) continue;
                    attributes.add(this.createAttribute(attribute.getName(), attribute.getValue()));
                }
                this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse11_EncryptedHeader, true, attributes);
            }
            super.processEventInternal(xmlSecStartElement, outputProcessorChain);
        }

        protected void createKeyInfoStructure(OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            this.createStartElementAndOutputAsEvent(outputProcessorChain, XMLSecurityConstants.TAG_dsig_KeyInfo, true, null);
            SecurityTokenConstants.KeyIdentifier keyIdentifier = ((WSSSecurityProperties)this.getSecurityProperties()).getEncryptionKeyIdentifier();
            if (WSSecurityTokenConstants.KeyIdentifier_EncryptedKeySha1Identifier.equals((Object)keyIdentifier)) {
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
                this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                if (this.sha1Identifier != null) {
                    WSSUtils.createEncryptedKeySha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.sha1Identifier);
                } else {
                    WSSUtils.createEncryptedKeySha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.getEncryptionPartDef().getSymmetricKey());
                }
            } else if (WSSecurityTokenConstants.KeyIdentifier_KerberosSha1Identifier.equals((Object)keyIdentifier)) {
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ"));
                this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                WSSUtils.createKerberosSha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.sha1Identifier);
            } else {
                ArrayList<XMLSecAttribute> attributes;
                boolean isSAMLToken = false;
                if (WSSecurityTokenConstants.KerberosToken.equals((Object)this.tokenType)) {
                    attributes = new ArrayList<XMLSecAttribute>(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                } else if (WSSecurityTokenConstants.Saml10Token.equals((Object)this.tokenType) || WSSecurityTokenConstants.Saml11Token.equals((Object)this.tokenType)) {
                    attributes = new ArrayList(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                    isSAMLToken = true;
                } else if (WSSecurityTokenConstants.Saml20Token.equals((Object)this.tokenType)) {
                    attributes = new ArrayList(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                    isSAMLToken = true;
                } else if (WSSecurityTokenConstants.EncryptedKeyToken.equals((Object)this.tokenType)) {
                    attributes = new ArrayList(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                } else {
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, true, null);
                }
                if (isSAMLToken) {
                    WSSUtils.createSAMLKeyIdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.tokenType, this.getEncryptionPartDef().getKeyId());
                } else {
                    attributes = new ArrayList(1);
                    attributes.add(this.createAttribute(WSSConstants.ATT_NULL_URI, "#" + this.getEncryptionPartDef().getKeyId()));
                    if (WSSecurityTokenConstants.KerberosToken.equals((Object)this.tokenType)) {
                        attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"));
                    } else if (WSSecurityTokenConstants.DerivedKeyToken.equals((Object)this.tokenType)) {
                        boolean use200512Namespace = ((WSSSecurityProperties)this.getSecurityProperties()).isUse200512Namespace();
                        if (use200512Namespace) {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk"));
                        } else {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk"));
                        }
                    } else if (WSSecurityTokenConstants.SpnegoContextToken.equals((Object)this.tokenType) || WSSecurityTokenConstants.SecurityContextToken.equals((Object)this.tokenType) || WSSecurityTokenConstants.SecureConversationToken.equals((Object)this.tokenType)) {
                        boolean use200512Namespace = ((WSSSecurityProperties)this.getSecurityProperties()).isUse200512Namespace();
                        if (use200512Namespace) {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct"));
                        } else {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct"));
                        }
                    } else if (WSSecurityTokenConstants.EncryptedKeyToken.equals((Object)this.tokenType)) {
                        attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
                    }
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_Reference, false, attributes);
                    this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_Reference);
                }
            }
            this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference);
            this.createEndElementAndOutputAsEvent(outputProcessorChain, XMLSecurityConstants.TAG_dsig_KeyInfo);
        }

        protected void doFinalInternal(OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            super.doFinalInternal(outputProcessorChain);
            if (this.doEncryptedHeader) {
                this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse11_EncryptedHeader);
            }
        }
    }
}

