/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.output;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.impl.processor.output.WSSSignatureEndingOutputProcessor;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.Transformer;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityUtils;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.SignaturePartDef;
import org.apache.xml.security.stax.impl.processor.output.AbstractSignatureOutputProcessor;
import org.apache.xml.security.stax.impl.transformer.TransformIdentity;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSSSignatureOutputProcessor
extends AbstractSignatureOutputProcessor {
    private static final transient Logger logger = LoggerFactory.getLogger(WSSSignatureOutputProcessor.class);

    public void init(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
        super.init(outputProcessorChain);
        WSSSignatureEndingOutputProcessor signatureEndingOutputProcessor = new WSSSignatureEndingOutputProcessor(this);
        signatureEndingOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
        signatureEndingOutputProcessor.setAction(this.getAction());
        signatureEndingOutputProcessor.init(outputProcessorChain);
    }

    public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        if (xmlSecEvent.getEventType() == 1) {
            SecurePart securePart;
            XMLSecStartElement xmlSecStartElement = xmlSecEvent.asStartElement();
            if (this.getActiveInternalSignatureOutputProcessor() == null && (securePart = this.securePartMatches(xmlSecStartElement, outputProcessorChain, "signatureParts")) != null) {
                logger.debug("Matched securePart for signature");
                SignaturePartDef signaturePartDef = new SignaturePartDef();
                signaturePartDef.setSecurePart(securePart);
                signaturePartDef.setTransforms(securePart.getTransforms());
                signaturePartDef.setExcludeVisibleC14Nprefixes(true);
                String digestMethod = securePart.getDigestMethod();
                if (digestMethod == null) {
                    digestMethod = this.getSecurityProperties().getSignatureDigestAlgorithm();
                }
                signaturePartDef.setDigestAlgo(digestMethod);
                if (securePart.getIdToSign() == null) {
                    signaturePartDef.setGenerateXPointer(securePart.isGenerateXPointer());
                    signaturePartDef.setSigRefId(IDGenerator.generateID(null));
                    Attribute attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_wsu_Id);
                    if (attribute != null) {
                        signaturePartDef.setSigRefId(attribute.getValue());
                    } else {
                        ArrayList<XMLSecAttribute> attributeList = new ArrayList<XMLSecAttribute>(1);
                        attributeList.add(this.createAttribute(WSSConstants.ATT_wsu_Id, signaturePartDef.getSigRefId()));
                        xmlSecEvent = this.addAttributes(xmlSecStartElement, attributeList);
                    }
                } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(securePart.getName().getLocalPart())) {
                    signaturePartDef.setSigRefId(securePart.getIdToReference());
                    String[] transforms = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "http://www.w3.org/2001/10/xml-exc-c14n#"};
                    signaturePartDef.setTransforms(transforms);
                } else {
                    signaturePartDef.setSigRefId(securePart.getIdToSign());
                }
                this.getSignaturePartDefList().add(signaturePartDef);
                InternalWSSSignatureOutputProcessor internalSignatureOutputProcessor = new InternalWSSSignatureOutputProcessor(signaturePartDef, xmlSecStartElement);
                internalSignatureOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
                internalSignatureOutputProcessor.setAction(this.getAction());
                internalSignatureOutputProcessor.addAfterProcessor(WSSSignatureOutputProcessor.class.getName());
                internalSignatureOutputProcessor.addBeforeProcessor(WSSSignatureEndingOutputProcessor.class.getName());
                internalSignatureOutputProcessor.init(outputProcessorChain);
                this.setActiveInternalSignatureOutputProcessor(internalSignatureOutputProcessor);
                if ("Body".equals(xmlSecStartElement.getName().getLocalPart()) && WSSUtils.isInSOAPBody((XMLSecEvent)xmlSecStartElement)) {
                    this.doFinalInternal(outputProcessorChain);
                    outputProcessorChain.removeProcessor((OutputProcessor)this);
                }
            }
        }
        outputProcessorChain.processEvent(xmlSecEvent);
    }

    protected SecurePart securePartMatches(XMLSecStartElement xmlSecStartElement, Map<Object, SecurePart> secureParts) {
        SecurePart securePart = secureParts.get(xmlSecStartElement.getName());
        if (securePart == null) {
            if (xmlSecStartElement.getOnElementDeclaredAttributes().size() == 0) {
                return null;
            }
            Attribute attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_wsu_Id);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
            attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_NULL_Id);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
            attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_NULL_ID);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
            attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_NULL_AssertionID);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
        }
        return securePart;
    }

    protected Transformer buildTransformerChain(OutputStream outputStream, SignaturePartDef signaturePartDef, XMLSecStartElement xmlSecStartElement) throws XMLSecurityException {
        String[] transforms = signaturePartDef.getTransforms();
        if (transforms == null || transforms.length == 0) {
            TransformIdentity transformer = new TransformIdentity();
            transformer.setOutputStream(outputStream);
            return transformer;
        }
        ArrayList<String> inclusiveNamespacePrefixes = null;
        Transformer parentTransformer = null;
        for (int i = transforms.length - 1; i >= 0; --i) {
            String transform = transforms[i];
            if (this.getSecurityProperties().isAddExcC14NInclusivePrefixes() && "http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform)) {
                Set prefixSet = XMLSecurityUtils.getExcC14NInclusiveNamespacePrefixes((XMLSecStartElement)xmlSecStartElement, (boolean)signaturePartDef.isExcludeVisibleC14Nprefixes());
                inclusiveNamespacePrefixes = new ArrayList<String>(prefixSet.size());
                StringBuilder prefixes = new StringBuilder();
                for (String prefix : prefixSet) {
                    if (!inclusiveNamespacePrefixes.contains(prefix)) {
                        inclusiveNamespacePrefixes.add(prefix);
                    }
                    if (prefixes.length() != 0) {
                        prefixes.append(" ");
                    }
                    prefixes.append(prefix);
                }
                signaturePartDef.setInclusiveNamespacesPrefixes(prefixes.toString());
            }
            parentTransformer = parentTransformer != null ? XMLSecurityUtils.getTransformer(parentTransformer, null, (String)transform, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.OUT) : XMLSecurityUtils.getTransformer(inclusiveNamespacePrefixes, (Object)outputStream, (String)transform, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.OUT);
        }
        return parentTransformer;
    }

    class InternalWSSSignatureOutputProcessor
    extends AbstractSignatureOutputProcessor.InternalSignatureOutputProcessor {
        public InternalWSSSignatureOutputProcessor(SignaturePartDef signaturePartDef, XMLSecStartElement xmlSecStartElement) throws XMLSecurityException {
            super((AbstractSignatureOutputProcessor)WSSSignatureOutputProcessor.this, signaturePartDef, xmlSecStartElement);
            this.addBeforeProcessor(InternalWSSSignatureOutputProcessor.class.getName());
        }
    }
}

